/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.com.google.common.collect;

import javax.annotation.CheckForNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.NonNegative;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.com.google.common.annotations.GwtCompatible;
import org.checkerframework.nullaway.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.nullaway.com.google.common.annotations.J2ktIncompatible;
import org.checkerframework.nullaway.com.google.common.base.Preconditions;
import org.checkerframework.nullaway.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.checkerframework.nullaway.com.google.common.collect.ImmutableList;
import org.checkerframework.nullaway.com.google.common.collect.ImmutableSet;
import org.checkerframework.nullaway.com.google.common.collect.Iterators;
import org.checkerframework.nullaway.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<@SubstringIndexBottom E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    @Pure
    public @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int size() {
        return 1;
    }

    @Override
    @Pure
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean contains(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object target) {
        return this.element.equals(target);
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean isPartialView() {
        return false;
    }

    @Override
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int copyIntoArray(@Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] dst, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    @Pure
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int hashCode(@UnknownSignedness SingletonImmutableSet<E> this) {
        return this.element.hashCode();
    }

    @Override
    @Pure
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object writeReplace() {
        return super.writeReplace();
    }

    @Override
    @Pure
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean equals(@Nullable @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized Object arg0) {
        return super.equals(arg0);
    }
}

