/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class AnnotationUtil {
    public static <T extends Annotation> T selectFirstMatching(JCas jCas, Class<T> selectedType, Annotation annotation) {
        List<T> selected = AnnotationUtil.selectMatching(jCas, selectedType, annotation);
        return (T)(selected.size() > 0 ? (Annotation)selected.get(0) : null);
    }

    public static <T extends Annotation> List<T> selectMatching(JCas jCas, Class<T> selectedType, Annotation annotation) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation selected : JCasUtil.selectCovered((JCas)jCas, selectedType, (AnnotationFS)annotation)) {
            if (selected.getBegin() != annotation.getBegin() || selected.getEnd() != annotation.getEnd()) continue;
            result.add(selected);
        }
        return result;
    }

    public static boolean contains(Annotation bigAnnotation, Annotation smallAnnotation) {
        if (bigAnnotation == null || smallAnnotation == null) {
            return false;
        }
        return bigAnnotation.getBegin() <= smallAnnotation.getBegin() && bigAnnotation.getEnd() >= smallAnnotation.getEnd();
    }

    public static boolean overlaps(Annotation annotation1, Annotation annotation2) {
        Annotation secondAnnotation;
        Annotation firstAnnotation;
        if (annotation1.getBegin() == annotation2.getBegin()) {
            return true;
        }
        if (annotation1.getBegin() < annotation2.getBegin()) {
            firstAnnotation = annotation1;
            secondAnnotation = annotation2;
        } else {
            firstAnnotation = annotation2;
            secondAnnotation = annotation1;
        }
        return firstAnnotation.getEnd() > secondAnnotation.getBegin();
    }

    public static int size(Annotation annotation) {
        return annotation.getEnd() - annotation.getBegin();
    }

    public static <TOKEN_TYPE extends Annotation> String getSurroundingText(JCas jCas, Annotation annotation, Class<TOKEN_TYPE> tokenClass, int numberOfTokens, boolean before) {
        int end;
        int start;
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("numberOfTokens must be greater than zero.  Actual values is: " + numberOfTokens);
        }
        String documentText = jCas.getDocumentText();
        if (before) {
            start = 0;
            end = annotation.getBegin();
            List anns = JCasUtil.selectPreceding((JCas)jCas, tokenClass, (AnnotationFS)annotation, (int)numberOfTokens);
            if (anns.size() > 0) {
                start = ((Annotation)anns.get(0)).getBegin();
            }
        } else {
            start = annotation.getEnd();
            end = documentText.length();
            List anns = JCasUtil.selectFollowing((JCas)jCas, tokenClass, (AnnotationFS)annotation, (int)numberOfTokens);
            if (anns.size() > 0) {
                end = ((Annotation)anns.get(anns.size() - 1)).getEnd();
            }
        }
        return documentText.substring(start, end);
    }

    public static <T extends Annotation> void sort(List<T> annotations) {
        Collections.sort(annotations, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1.getBegin() != o2.getBegin()) {
                    return o1.getBegin() < o2.getBegin() ? -1 : 1;
                }
                if (o1.getEnd() != o2.getEnd()) {
                    return o1.getEnd() < o2.getEnd() ? -1 : 1;
                }
                return 0;
            }
        });
    }

    public static int[] getAnnotationsExtent(List<? extends Annotation> annotations) {
        int start = Integer.MAX_VALUE;
        int end = 0;
        for (Annotation annotation : annotations) {
            if (annotation.getBegin() < start) {
                start = annotation.getBegin();
            }
            if (annotation.getEnd() <= end) continue;
            end = annotation.getEnd();
        }
        return new int[]{start, end};
    }
}

