/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.ae;

import java.io.InputStream;
import java.net.URI;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;

public class UriToXmiCasAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_XML_SCHEME = "xmlScheme";
    @ConfigurationParameter(name="xmlScheme", defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' and 'XCAS'")
    private XmlScheme xmlScheme;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(UriToXmiCasAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getCreateViewAggregateDescription(String targetViewName) throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", targetViewName}), new String[0]);
        builder.add(UriToXmiCasAnnotator.getDescription(), new String[]{"_InitialView", targetViewName});
        return builder.createAggregateDescription();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        URI uri = ViewUriUtil.getURI(jCas);
        InputStream inputStream = null;
        try {
            inputStream = uri.toURL().openStream();
            switch (this.xmlScheme) {
                case XMI: {
                    XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
                    break;
                }
                case XCAS: {
                    XCASDeserializer.deserialize((InputStream)inputStream, (CAS)jCas.getCas());
                }
            }
            inputStream.close();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public static enum XmlScheme {
        XMI,
        XCAS;

    }
}

