/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.serviceinstances;

import java.util.Map;
import org.cloudfoundry.client.v3.serviceInstances.ListServiceInstancesRequest;
import org.cloudfoundry.client.v3.serviceInstances.ListServiceInstancesResponse;
import org.cloudfoundry.client.v3.serviceInstances.ListSharedSpacesRelationshipRequest;
import org.cloudfoundry.client.v3.serviceInstances.ListSharedSpacesRelationshipResponse;
import org.cloudfoundry.client.v3.serviceInstances.ServiceInstancesV3;
import org.cloudfoundry.client.v3.serviceInstances.ShareServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceInstances.ShareServiceInstanceResponse;
import org.cloudfoundry.client.v3.serviceInstances.UnshareServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceInstances.UpdateServiceInstanceRequest;
import org.cloudfoundry.client.v3.serviceInstances.UpdateServiceInstanceResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServiceInstancesV3
extends AbstractClientV3Operations
implements ServiceInstancesV3 {
    public ReactorServiceInstancesV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<ListServiceInstancesResponse> list(ListServiceInstancesRequest request) {
        return this.get((Object)request, ListServiceInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances"})).checkpoint();
    }

    public Mono<ListSharedSpacesRelationshipResponse> listSharedSpacesRelationship(ListSharedSpacesRelationshipRequest request) {
        return this.get((Object)request, ListSharedSpacesRelationshipResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces"})).checkpoint();
    }

    public Mono<ShareServiceInstanceResponse> share(ShareServiceInstanceRequest request) {
        return this.post(request, ShareServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces"})).checkpoint();
    }

    public Mono<Void> unshare(UnshareServiceInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "relationships", "shared_spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<UpdateServiceInstanceResponse> update(UpdateServiceInstanceRequest request) {
        return this.patch(request, UpdateServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()}));
    }
}

