/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import reactor.core.Exceptions;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> Optional<T> findAnnotation(Class<?> type, Class<T> annotationType) {
        Class<?> clazz = type;
        T annotation = clazz.getAnnotation(annotationType);
        while (annotation == null && (clazz = clazz.getSuperclass()) != null && Object.class != clazz) {
            annotation = clazz.getAnnotation(annotationType);
        }
        return Optional.ofNullable(annotation);
    }

    public static <T extends Annotation> Stream<AnnotatedValue<T>> streamAnnotatedValues(Object instance, Class<T> annotationClass) {
        Class<?> instanceClass = instance.getClass();
        return Arrays.stream(instanceClass.getMethods()).sorted(MethodNameComparator.INSTANCE).map(AnnotationUtils.processMethod(instance, annotationClass)).filter(Objects::nonNull);
    }

    private static <T extends Annotation> Optional<T> findAnnotation(Method method, Class<T> annotationType) {
        Class<?> clazz = method.getDeclaringClass();
        T annotation = method.getAnnotation(annotationType);
        while (annotation == null && (clazz = clazz.getSuperclass()) != null && Object.class != clazz) {
            try {
                annotation = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()).getAnnotation(annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return Optional.ofNullable(annotation);
    }

    private static Optional<Object> getValue(Method method, Object instance) {
        try {
            return Optional.ofNullable(method.invoke(instance, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static <T extends Annotation> Function<T, Optional<AnnotatedValue<T>>> processAnnotation(Method method, Object instance) {
        return annotation -> AnnotationUtils.getValue(method, instance).map(value -> new AnnotatedValue<Annotation>((Annotation)annotation, value));
    }

    private static <T extends Annotation> Function<Method, AnnotatedValue<T>> processMethod(Object instance, Class<T> annotationClass) {
        return method -> AnnotationUtils.findAnnotation(method, annotationClass).flatMap(AnnotationUtils.processAnnotation(method, instance)).orElse(null);
    }

    public static class AnnotatedValue<T extends Annotation> {
        private final T annotation;
        private final Object value;

        public AnnotatedValue(T annotation, Object value) {
            this.annotation = annotation;
            this.value = value;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

