/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.resourcematch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v2.resourcematch.Resource;
import org.cloudfoundry.client.v2.resourcematch._ListMatchingResourcesResponse;
import org.immutables.value.Generated;

@Generated(from="_ListMatchingResourcesResponse", generator="Immutables")
public final class ListMatchingResourcesResponse
extends _ListMatchingResourcesResponse {
    private final List<Resource> resources;

    private ListMatchingResourcesResponse(Builder builder) {
        this.resources = ListMatchingResourcesResponse.createUnmodifiableList(true, builder.resources);
    }

    @Override
    @JsonProperty(value="resources")
    public List<Resource> getResources() {
        return this.resources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListMatchingResourcesResponse && this.equalTo((ListMatchingResourcesResponse)another);
    }

    private boolean equalTo(ListMatchingResourcesResponse another) {
        return this.resources.equals(another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.resources.hashCode();
        return h;
    }

    public String toString() {
        return "ListMatchingResourcesResponse{resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListMatchingResourcesResponse fromJson(Json json) {
        Builder builder = ListMatchingResourcesResponse.builder();
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<Resource> resources = new ArrayList<Resource>();

        private Builder() {
        }

        public final Builder from(ListMatchingResourcesResponse instance) {
            return this.from((_ListMatchingResourcesResponse)instance);
        }

        final Builder from(_ListMatchingResourcesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllResources(instance.getResources());
            return this;
        }

        public final Builder resource(Resource element) {
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(Resource ... elements) {
            for (Resource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        @JsonProperty(value="resources")
        public final Builder resources(Iterable<? extends Resource> elements) {
            this.resources.clear();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends Resource> elements) {
            for (Resource resource : elements) {
                this.resources.add(Objects.requireNonNull(resource, "resources element"));
            }
            return this;
        }

        public ListMatchingResourcesResponse build() {
            return new ListMatchingResourcesResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ListMatchingResourcesResponse {
        List<Resource> resources = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="resources")
        public void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        @Override
        public List<Resource> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

