/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.securitygroups._ListSecurityGroupSpacesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListSecurityGroupSpacesRequest", generator="Immutables")
public final class ListSecurityGroupSpacesRequest
extends _ListSecurityGroupSpacesRequest {
    @Nullable
    private final List<String> applicationIds;
    @Nullable
    private final List<String> developerIds;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> organizationIds;
    private final String securityGroupId;
    @Nullable
    private final String spaceId;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListSecurityGroupSpacesRequest(Builder builder) {
        this.applicationIds = builder.applicationIds == null ? null : ListSecurityGroupSpacesRequest.createUnmodifiableList(true, builder.applicationIds);
        this.developerIds = builder.developerIds == null ? null : ListSecurityGroupSpacesRequest.createUnmodifiableList(true, builder.developerIds);
        this.names = builder.names == null ? null : ListSecurityGroupSpacesRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = builder.organizationIds == null ? null : ListSecurityGroupSpacesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.securityGroupId = builder.securityGroupId;
        this.spaceId = builder.spaceId;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    @Nullable
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    @Override
    @Nullable
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSecurityGroupSpacesRequest && this.equalTo((ListSecurityGroupSpacesRequest)another);
    }

    private boolean equalTo(ListSecurityGroupSpacesRequest another) {
        return Objects.equals(this.applicationIds, another.applicationIds) && Objects.equals(this.developerIds, another.developerIds) && Objects.equals(this.names, another.names) && Objects.equals(this.organizationIds, another.organizationIds) && this.securityGroupId.equals(another.securityGroupId) && Objects.equals(this.spaceId, another.spaceId) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationIds);
        h += (h << 5) + Objects.hashCode(this.developerIds);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + this.securityGroupId.hashCode();
        h += (h << 5) + Objects.hashCode(this.spaceId);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListSecurityGroupSpacesRequest{applicationIds=" + this.applicationIds + ", developerIds=" + this.developerIds + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", securityGroupId=" + this.securityGroupId + ", spaceId=" + this.spaceId + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SECURITY_GROUP_ID = 1L;
        private long initBits = 1L;
        private List<String> applicationIds = null;
        private List<String> developerIds = null;
        private List<String> names = null;
        private List<String> organizationIds = null;
        private String securityGroupId;
        private String spaceId;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(ListSecurityGroupSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListSecurityGroupSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListSecurityGroupSpacesRequest) {
                List<String> applicationIdsValue;
                List<String> organizationIdsValue;
                List<String> namesValue;
                instance = (_ListSecurityGroupSpacesRequest)object;
                List<String> developerIdsValue = ((_ListSecurityGroupSpacesRequest)instance).getDeveloperIds();
                if (developerIdsValue != null) {
                    this.addAllDeveloperIds(developerIdsValue);
                }
                this.securityGroupId(((_ListSecurityGroupSpacesRequest)instance).getSecurityGroupId());
                String spaceIdValue = ((_ListSecurityGroupSpacesRequest)instance).getSpaceId();
                if (spaceIdValue != null) {
                    this.spaceId(spaceIdValue);
                }
                if ((namesValue = ((_ListSecurityGroupSpacesRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
                if ((organizationIdsValue = ((_ListSecurityGroupSpacesRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
                if ((applicationIdsValue = ((_ListSecurityGroupSpacesRequest)instance).getApplicationIds()) != null) {
                    this.addAllApplicationIds(applicationIdsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder applicationId(String element) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.applicationIds = null;
                return this;
            }
            this.applicationIds = new ArrayList<String>();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "applicationIds element");
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder developerId(String element) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            return this;
        }

        public final Builder developerIds(String ... elements) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder developerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.developerIds = null;
                return this;
            }
            this.developerIds = new ArrayList<String>();
            return this.addAllDeveloperIds(elements);
        }

        public final Builder addAllDeveloperIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "developerIds element");
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder spaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSecurityGroupSpacesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListSecurityGroupSpacesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("securityGroupId");
            }
            return "Cannot build ListSecurityGroupSpacesRequest, some of required attributes are not set " + attributes;
        }
    }
}

