/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.droplets.DropletState;
import org.cloudfoundry.client.v3.droplets._ListDropletsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListDropletsRequest", generator="Immutables")
public final class ListDropletsRequest
extends _ListDropletsRequest {
    private final List<String> applicationIds;
    private final List<String> dropletIds;
    private final List<String> organizationIds;
    private final List<String> spaceIds;
    private final List<DropletState> states;
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListDropletsRequest(Builder builder) {
        this.applicationIds = ListDropletsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.dropletIds = ListDropletsRequest.createUnmodifiableList(true, builder.dropletIds);
        this.organizationIds = ListDropletsRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceIds = ListDropletsRequest.createUnmodifiableList(true, builder.spaceIds);
        this.states = ListDropletsRequest.createUnmodifiableList(true, builder.states);
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getDropletIds() {
        return this.dropletIds;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    public List<DropletState> getStates() {
        return this.states;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListDropletsRequest && this.equalTo((ListDropletsRequest)another);
    }

    private boolean equalTo(ListDropletsRequest another) {
        return this.applicationIds.equals(another.applicationIds) && this.dropletIds.equals(another.dropletIds) && this.organizationIds.equals(another.organizationIds) && this.spaceIds.equals(another.spaceIds) && this.states.equals(another.states) && Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.dropletIds.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        h += (h << 5) + this.states.hashCode();
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListDropletsRequest{applicationIds=" + this.applicationIds + ", dropletIds=" + this.dropletIds + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", states=" + this.states + ", orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> dropletIds = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private List<DropletState> states = new ArrayList<DropletState>();
        private String orderBy;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(ListDropletsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListDropletsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListDropletsRequest) {
                instance = (_ListDropletsRequest)object;
                this.addAllDropletIds(((_ListDropletsRequest)instance).getDropletIds());
                this.addAllSpaceIds(((_ListDropletsRequest)instance).getSpaceIds());
                this.addAllOrganizationIds(((_ListDropletsRequest)instance).getOrganizationIds());
                this.addAllApplicationIds(((_ListDropletsRequest)instance).getApplicationIds());
                this.addAllStates(((_ListDropletsRequest)instance).getStates());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder dropletId(String element) {
            this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
            return this;
        }

        public final Builder dropletIds(String ... elements) {
            for (String element : elements) {
                this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
            }
            return this;
        }

        public final Builder dropletIds(Iterable<String> elements) {
            this.dropletIds.clear();
            return this.addAllDropletIds(elements);
        }

        public final Builder addAllDropletIds(Iterable<String> elements) {
            for (String element : elements) {
                this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder state(DropletState element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder states(DropletState ... elements) {
            for (DropletState element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<? extends DropletState> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<? extends DropletState> elements) {
            for (DropletState dropletState : elements) {
                this.states.add(Objects.requireNonNull(dropletState, "states element"));
            }
            return this;
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListDropletsRequest build() {
            return new ListDropletsRequest(this);
        }
    }
}

