/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.packages._UploadPackageRequest;
import org.immutables.value.Generated;

@Generated(from="_UploadPackageRequest", generator="Immutables")
public final class UploadPackageRequest
extends _UploadPackageRequest {
    private final Path bits;
    private final String packageId;

    private UploadPackageRequest(Builder builder) {
        this.bits = builder.bits;
        this.packageId = builder.packageId;
    }

    @Override
    public Path getBits() {
        return this.bits;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UploadPackageRequest && this.equalTo((UploadPackageRequest)another);
    }

    private boolean equalTo(UploadPackageRequest another) {
        return this.bits.equals(another.bits) && this.packageId.equals(another.packageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bits.hashCode();
        h += (h << 5) + this.packageId.hashCode();
        return h;
    }

    public String toString() {
        return "UploadPackageRequest{bits=" + this.bits + ", packageId=" + this.packageId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BITS = 1L;
        private static final long INIT_BIT_PACKAGE_ID = 2L;
        private long initBits = 3L;
        private Path bits;
        private String packageId;

        private Builder() {
        }

        public final Builder from(UploadPackageRequest instance) {
            return this.from((_UploadPackageRequest)instance);
        }

        final Builder from(_UploadPackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.bits(instance.getBits());
            this.packageId(instance.getPackageId());
            return this;
        }

        public final Builder bits(Path bits) {
            this.bits = Objects.requireNonNull(bits, "bits");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder packageId(String packageId) {
            this.packageId = Objects.requireNonNull(packageId, "packageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public UploadPackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UploadPackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bits");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("packageId");
            }
            return "Cannot build UploadPackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

