/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients.AbstractCreateClient;
import org.cloudfoundry.uaa.clients._CreateClientRequest;
import org.cloudfoundry.uaa.tokens.GrantType;
import org.immutables.value.Generated;

@Generated(from="_CreateClientRequest", generator="Immutables")
public final class CreateClientRequest
extends _CreateClientRequest {
    @Nullable
    private final Long accessTokenValidity;
    @Nullable
    private final List<String> allowedProviders;
    @Nullable
    private final Boolean approvalsDeleted;
    @Nullable
    private final List<String> authorities;
    @Nullable
    private final List<GrantType> authorizedGrantTypes;
    @Nullable
    private final List<String> autoApproves;
    private final String clientId;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String createdWith;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> redirectUriPatterns;
    @Nullable
    private final Long refreshTokenValidity;
    @Nullable
    private final List<String> resourceIds;
    @Nullable
    private final List<String> scopes;
    @Nullable
    private final String tokenSalt;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private CreateClientRequest(Builder builder) {
        this.accessTokenValidity = builder.accessTokenValidity;
        this.allowedProviders = builder.allowedProviders == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.allowedProviders);
        this.approvalsDeleted = builder.approvalsDeleted;
        this.authorities = builder.authorities == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.authorities);
        this.authorizedGrantTypes = builder.authorizedGrantTypes == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.authorizedGrantTypes);
        this.autoApproves = builder.autoApproves == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.autoApproves);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.createdWith = builder.createdWith;
        this.name = builder.name;
        this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.redirectUriPatterns);
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.resourceIds = builder.resourceIds == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.resourceIds);
        this.scopes = builder.scopes == null ? null : CreateClientRequest.createUnmodifiableList(true, builder.scopes);
        this.tokenSalt = builder.tokenSalt;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="access_token_validity")
    @Nullable
    public Long getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    @Override
    @JsonProperty(value="allowedproviders")
    @Nullable
    public List<String> getAllowedProviders() {
        return this.allowedProviders;
    }

    @Override
    @JsonProperty(value="approvals_deleted")
    @Nullable
    public Boolean getApprovalsDeleted() {
        return this.approvalsDeleted;
    }

    @Override
    @JsonProperty(value="authorities")
    @Nullable
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    @JsonProperty(value="authorized_grant_types")
    @Nullable
    public List<GrantType> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    @Override
    @JsonProperty(value="autoapprove")
    @Nullable
    public List<String> getAutoApproves() {
        return this.autoApproves;
    }

    @Override
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="client_secret")
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @JsonProperty(value="createdwith")
    @Nullable
    public String getCreatedWith() {
        return this.createdWith;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="redirect_uri")
    @Nullable
    public List<String> getRedirectUriPatterns() {
        return this.redirectUriPatterns;
    }

    @Override
    @JsonProperty(value="refresh_token_validity")
    @Nullable
    public Long getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    @Override
    @JsonProperty(value="resource_ids")
    @Nullable
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="token_salt")
    @Nullable
    public String getTokenSalt() {
        return this.tokenSalt;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateClientRequest && this.equalTo((CreateClientRequest)another);
    }

    private boolean equalTo(CreateClientRequest another) {
        return Objects.equals(this.accessTokenValidity, another.accessTokenValidity) && Objects.equals(this.allowedProviders, another.allowedProviders) && Objects.equals(this.approvalsDeleted, another.approvalsDeleted) && Objects.equals(this.authorities, another.authorities) && Objects.equals(this.authorizedGrantTypes, another.authorizedGrantTypes) && Objects.equals(this.autoApproves, another.autoApproves) && this.clientId.equals(another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && Objects.equals(this.createdWith, another.createdWith) && Objects.equals(this.name, another.name) && Objects.equals(this.redirectUriPatterns, another.redirectUriPatterns) && Objects.equals(this.refreshTokenValidity, another.refreshTokenValidity) && Objects.equals(this.resourceIds, another.resourceIds) && Objects.equals(this.scopes, another.scopes) && Objects.equals(this.tokenSalt, another.tokenSalt) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.accessTokenValidity);
        h += (h << 5) + Objects.hashCode(this.allowedProviders);
        h += (h << 5) + Objects.hashCode(this.approvalsDeleted);
        h += (h << 5) + Objects.hashCode(this.authorities);
        h += (h << 5) + Objects.hashCode(this.authorizedGrantTypes);
        h += (h << 5) + Objects.hashCode(this.autoApproves);
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientSecret);
        h += (h << 5) + Objects.hashCode(this.createdWith);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.redirectUriPatterns);
        h += (h << 5) + Objects.hashCode(this.refreshTokenValidity);
        h += (h << 5) + Objects.hashCode(this.resourceIds);
        h += (h << 5) + Objects.hashCode(this.scopes);
        h += (h << 5) + Objects.hashCode(this.tokenSalt);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "CreateClientRequest{accessTokenValidity=" + this.accessTokenValidity + ", allowedProviders=" + this.allowedProviders + ", approvalsDeleted=" + this.approvalsDeleted + ", authorities=" + this.authorities + ", authorizedGrantTypes=" + this.authorizedGrantTypes + ", autoApproves=" + this.autoApproves + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", createdWith=" + this.createdWith + ", name=" + this.name + ", redirectUriPatterns=" + this.redirectUriPatterns + ", refreshTokenValidity=" + this.refreshTokenValidity + ", resourceIds=" + this.resourceIds + ", scopes=" + this.scopes + ", tokenSalt=" + this.tokenSalt + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateClientRequest fromJson(Json json) {
        Builder builder = CreateClientRequest.builder();
        if (json.accessTokenValidity != null) {
            builder.accessTokenValidity(json.accessTokenValidity);
        }
        if (json.allowedProviders != null) {
            builder.addAllAllowedProviders(json.allowedProviders);
        }
        if (json.approvalsDeleted != null) {
            builder.approvalsDeleted(json.approvalsDeleted);
        }
        if (json.authorities != null) {
            builder.addAllAuthorities(json.authorities);
        }
        if (json.authorizedGrantTypes != null) {
            builder.addAllAuthorizedGrantTypes(json.authorizedGrantTypes);
        }
        if (json.autoApproves != null) {
            builder.addAllAutoApproves(json.autoApproves);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.clientSecret != null) {
            builder.clientSecret(json.clientSecret);
        }
        if (json.createdWith != null) {
            builder.createdWith(json.createdWith);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.redirectUriPatterns != null) {
            builder.addAllRedirectUriPatterns(json.redirectUriPatterns);
        }
        if (json.refreshTokenValidity != null) {
            builder.refreshTokenValidity(json.refreshTokenValidity);
        }
        if (json.resourceIds != null) {
            builder.addAllResourceIds(json.resourceIds);
        }
        if (json.scopes != null) {
            builder.addAllScopes(json.scopes);
        }
        if (json.tokenSalt != null) {
            builder.tokenSalt(json.tokenSalt);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    private static CreateClientRequest validate(CreateClientRequest instance) {
        instance.checkAuthorizedGrantTypes();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private Long accessTokenValidity;
        private List<String> allowedProviders = null;
        private Boolean approvalsDeleted;
        private List<String> authorities = null;
        private List<GrantType> authorizedGrantTypes = null;
        private List<String> autoApproves = null;
        private String clientId;
        private String clientSecret;
        private String createdWith;
        private String name;
        private List<String> redirectUriPatterns = null;
        private Long refreshTokenValidity;
        private List<String> resourceIds = null;
        private List<String> scopes = null;
        private String tokenSalt;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractCreateClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_CreateClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof AbstractCreateClient) {
                List<String> resourceIdsValue;
                List<String> allowedProvidersValue;
                List<String> autoApprovesValue;
                List<String> scopesValue;
                Boolean approvalsDeletedValue;
                String clientSecretValue;
                String nameValue;
                Long refreshTokenValidityValue;
                List<String> authoritiesValue;
                Long accessTokenValidityValue;
                List<String> redirectUriPatternsValue;
                String tokenSaltValue;
                instance = (AbstractCreateClient)object;
                List<GrantType> authorizedGrantTypesValue = ((AbstractCreateClient)instance).getAuthorizedGrantTypes();
                if (authorizedGrantTypesValue != null) {
                    this.addAllAuthorizedGrantTypes(authorizedGrantTypesValue);
                }
                if ((tokenSaltValue = ((AbstractCreateClient)instance).getTokenSalt()) != null) {
                    this.tokenSalt(tokenSaltValue);
                }
                this.clientId(((AbstractCreateClient)instance).getClientId());
                String createdWithValue = ((AbstractCreateClient)instance).getCreatedWith();
                if (createdWithValue != null) {
                    this.createdWith(createdWithValue);
                }
                if ((redirectUriPatternsValue = ((AbstractCreateClient)instance).getRedirectUriPatterns()) != null) {
                    this.addAllRedirectUriPatterns(redirectUriPatternsValue);
                }
                if ((accessTokenValidityValue = ((AbstractCreateClient)instance).getAccessTokenValidity()) != null) {
                    this.accessTokenValidity(accessTokenValidityValue);
                }
                if ((authoritiesValue = ((AbstractCreateClient)instance).getAuthorities()) != null) {
                    this.addAllAuthorities(authoritiesValue);
                }
                if ((refreshTokenValidityValue = ((AbstractCreateClient)instance).getRefreshTokenValidity()) != null) {
                    this.refreshTokenValidity(refreshTokenValidityValue);
                }
                if ((nameValue = ((AbstractCreateClient)instance).getName()) != null) {
                    this.name(nameValue);
                }
                if ((clientSecretValue = ((AbstractCreateClient)instance).getClientSecret()) != null) {
                    this.clientSecret(clientSecretValue);
                }
                if ((approvalsDeletedValue = ((AbstractCreateClient)instance).getApprovalsDeleted()) != null) {
                    this.approvalsDeleted(approvalsDeletedValue);
                }
                if ((scopesValue = ((AbstractCreateClient)instance).getScopes()) != null) {
                    this.addAllScopes(scopesValue);
                }
                if ((autoApprovesValue = ((AbstractCreateClient)instance).getAutoApproves()) != null) {
                    this.addAllAutoApproves(autoApprovesValue);
                }
                if ((allowedProvidersValue = ((AbstractCreateClient)instance).getAllowedProviders()) != null) {
                    this.addAllAllowedProviders(allowedProvidersValue);
                }
                if ((resourceIdsValue = ((AbstractCreateClient)instance).getResourceIds()) != null) {
                    this.addAllResourceIds(resourceIdsValue);
                }
            }
        }

        public final Builder accessTokenValidity(@Nullable Long accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public final Builder allowedProvider(String element) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            return this;
        }

        public final Builder allowedProviders(String ... elements) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder allowedProviders(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.allowedProviders = null;
                return this;
            }
            this.allowedProviders = new ArrayList<String>();
            return this.addAllAllowedProviders(elements);
        }

        public final Builder addAllAllowedProviders(Iterable<String> elements) {
            Objects.requireNonNull(elements, "allowedProviders element");
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
            this.approvalsDeleted = approvalsDeleted;
            return this;
        }

        public final Builder authority(String element) {
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            return this;
        }

        public final Builder authorities(String ... elements) {
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorities(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.authorities = null;
                return this;
            }
            this.authorities = new ArrayList<String>();
            return this.addAllAuthorities(elements);
        }

        public final Builder addAllAuthorities(Iterable<String> elements) {
            Objects.requireNonNull(elements, "authorities element");
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorizedGrantType(GrantType element) {
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            return this;
        }

        public final Builder authorizedGrantTypes(GrantType ... elements) {
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            for (GrantType element : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder authorizedGrantTypes(@Nullable Iterable<? extends GrantType> elements) {
            if (elements == null) {
                this.authorizedGrantTypes = null;
                return this;
            }
            this.authorizedGrantTypes = new ArrayList<GrantType>();
            return this.addAllAuthorizedGrantTypes(elements);
        }

        public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
            Objects.requireNonNull(elements, "authorizedGrantTypes element");
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            for (GrantType grantType : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(grantType, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder autoApprove(String element) {
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            return this;
        }

        public final Builder autoApproves(String ... elements) {
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder autoApproves(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.autoApproves = null;
                return this;
            }
            this.autoApproves = new ArrayList<String>();
            return this.addAllAutoApproves(elements);
        }

        public final Builder addAllAutoApproves(Iterable<String> elements) {
            Objects.requireNonNull(elements, "autoApproves element");
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final Builder createdWith(@Nullable String createdWith) {
            this.createdWith = createdWith;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder redirectUriPattern(String element) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            return this;
        }

        public final Builder redirectUriPatterns(String ... elements) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.redirectUriPatterns = null;
                return this;
            }
            this.redirectUriPatterns = new ArrayList<String>();
            return this.addAllRedirectUriPatterns(elements);
        }

        public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "redirectUriPatterns element");
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder refreshTokenValidity(@Nullable Long refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final Builder resourceId(String element) {
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            return this;
        }

        public final Builder resourceIds(String ... elements) {
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder resourceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.resourceIds = null;
                return this;
            }
            this.resourceIds = new ArrayList<String>();
            return this.addAllResourceIds(elements);
        }

        public final Builder addAllResourceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "resourceIds element");
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder scope(String element) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scopes(String ... elements) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder scopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.scopes = null;
                return this;
            }
            this.scopes = new ArrayList<String>();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "scopes element");
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder tokenSalt(@Nullable String tokenSalt) {
            this.tokenSalt = tokenSalt;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public CreateClientRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateClientRequest.validate(new CreateClientRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build CreateClientRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _CreateClientRequest {
        Long accessTokenValidity;
        List<String> allowedProviders = null;
        Boolean approvalsDeleted;
        List<String> authorities = null;
        List<GrantType> authorizedGrantTypes = null;
        List<String> autoApproves = null;
        String clientId;
        String clientSecret;
        String createdWith;
        String name;
        List<String> redirectUriPatterns = null;
        Long refreshTokenValidity;
        List<String> resourceIds = null;
        List<String> scopes = null;
        String tokenSalt;
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonProperty(value="access_token_validity")
        public void setAccessTokenValidity(@Nullable Long accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        @JsonProperty(value="allowedproviders")
        public void setAllowedProviders(@Nullable List<String> allowedProviders) {
            this.allowedProviders = allowedProviders;
        }

        @JsonProperty(value="approvals_deleted")
        public void setApprovalsDeleted(@Nullable Boolean approvalsDeleted) {
            this.approvalsDeleted = approvalsDeleted;
        }

        @JsonProperty(value="authorities")
        public void setAuthorities(@Nullable List<String> authorities) {
            this.authorities = authorities;
        }

        @JsonProperty(value="authorized_grant_types")
        public void setAuthorizedGrantTypes(@Nullable List<GrantType> authorizedGrantTypes) {
            this.authorizedGrantTypes = authorizedGrantTypes;
        }

        @JsonProperty(value="autoapprove")
        public void setAutoApproves(@Nullable List<String> autoApproves) {
            this.autoApproves = autoApproves;
        }

        @JsonProperty(value="client_id")
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="client_secret")
        public void setClientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @JsonProperty(value="createdwith")
        public void setCreatedWith(@Nullable String createdWith) {
            this.createdWith = createdWith;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="redirect_uri")
        public void setRedirectUriPatterns(@Nullable List<String> redirectUriPatterns) {
            this.redirectUriPatterns = redirectUriPatterns;
        }

        @JsonProperty(value="refresh_token_validity")
        public void setRefreshTokenValidity(@Nullable Long refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        @JsonProperty(value="resource_ids")
        public void setResourceIds(@Nullable List<String> resourceIds) {
            this.resourceIds = resourceIds;
        }

        @JsonProperty(value="scope")
        public void setScopes(@Nullable List<String> scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="token_salt")
        public void setTokenSalt(@Nullable String tokenSalt) {
            this.tokenSalt = tokenSalt;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public Long getAccessTokenValidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedProviders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getApprovalsDeleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAuthorities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<GrantType> getAuthorizedGrantTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAutoApproves() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientSecret() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedWith() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRedirectUriPatterns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getRefreshTokenValidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getResourceIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenSalt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

