/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders.AbstractAuthenticationConfiguration;
import org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration;
import org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration;
import org.cloudfoundry.uaa.identityproviders.AttributeMappings;
import org.cloudfoundry.uaa.identityproviders._OAuth2Configuration;
import org.immutables.value.Generated;

@Generated(from="_OAuth2Configuration", generator="Immutables")
public final class OAuth2Configuration
extends _OAuth2Configuration {
    @Nullable
    private final String checkTokenUrl;
    @Nullable
    private final Boolean clientAuthInBody;
    @Nullable
    private final String issuer;
    @Nullable
    private final String responseType;
    @Nullable
    private final Boolean addShadowUserOnLogin;
    private final String authUrl;
    @Nullable
    private final Boolean linkText;
    private final String relyingPartyId;
    @Nullable
    private final String relyingPartySecret;
    @Nullable
    private final List<String> scopes;
    @Nullable
    private final Boolean showLinkText;
    @Nullable
    private final Boolean skipSslVerification;
    @Nullable
    private final String tokenKey;
    @Nullable
    private final String tokenKeyUrl;
    private final String tokenUrl;
    @Nullable
    private final AttributeMappings attributeMappings;
    @Nullable
    private final List<String> externalGroupsWhitelist;
    @Nullable
    private final Boolean storeCustomAttributes;
    @Nullable
    private final List<String> emailDomains;
    @Nullable
    private final String providerDescription;

    private OAuth2Configuration(Builder builder) {
        this.checkTokenUrl = builder.checkTokenUrl;
        this.clientAuthInBody = builder.clientAuthInBody;
        this.issuer = builder.issuer;
        this.responseType = builder.responseType;
        this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
        this.authUrl = builder.authUrl;
        this.linkText = builder.linkText;
        this.relyingPartyId = builder.relyingPartyId;
        this.relyingPartySecret = builder.relyingPartySecret;
        this.scopes = builder.scopes == null ? null : OAuth2Configuration.createUnmodifiableList(true, builder.scopes);
        this.showLinkText = builder.showLinkText;
        this.skipSslVerification = builder.skipSslVerification;
        this.tokenKey = builder.tokenKey;
        this.tokenKeyUrl = builder.tokenKeyUrl;
        this.tokenUrl = builder.tokenUrl;
        this.attributeMappings = builder.attributeMappings;
        this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : OAuth2Configuration.createUnmodifiableList(true, builder.externalGroupsWhitelist);
        this.storeCustomAttributes = builder.storeCustomAttributes;
        this.emailDomains = builder.emailDomains == null ? null : OAuth2Configuration.createUnmodifiableList(true, builder.emailDomains);
        this.providerDescription = builder.providerDescription;
    }

    @Override
    @JsonProperty(value="checkTokenUrl")
    @Nullable
    public String getCheckTokenUrl() {
        return this.checkTokenUrl;
    }

    @Override
    @JsonProperty(value="clientAuthInBody")
    @Nullable
    public Boolean getClientAuthInBody() {
        return this.clientAuthInBody;
    }

    @Override
    @JsonProperty(value="issuer")
    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @JsonProperty(value="responseType")
    @Nullable
    public String getResponseType() {
        return this.responseType;
    }

    @Override
    @JsonProperty(value="addShadowUserOnLogin")
    @Nullable
    public Boolean getAddShadowUserOnLogin() {
        return this.addShadowUserOnLogin;
    }

    @Override
    @JsonProperty(value="authUrl")
    public String getAuthUrl() {
        return this.authUrl;
    }

    @Override
    @JsonProperty(value="linkText")
    @Nullable
    public Boolean getLinkText() {
        return this.linkText;
    }

    @Override
    @JsonProperty(value="relyingPartyId")
    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    @Override
    @JsonProperty(value="relyingPartySecret")
    @Nullable
    public String getRelyingPartySecret() {
        return this.relyingPartySecret;
    }

    @Override
    @JsonProperty(value="scopes")
    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="showLinkText")
    @Nullable
    public Boolean getShowLinkText() {
        return this.showLinkText;
    }

    @Override
    @JsonProperty(value="skipSslValidation")
    @Nullable
    public Boolean getSkipSslVerification() {
        return this.skipSslVerification;
    }

    @Override
    @JsonProperty(value="tokenKey")
    @Nullable
    public String getTokenKey() {
        return this.tokenKey;
    }

    @Override
    @JsonProperty(value="tokenKeyUrl")
    @Nullable
    public String getTokenKeyUrl() {
        return this.tokenKeyUrl;
    }

    @Override
    @JsonProperty(value="tokenUrl")
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    @JsonProperty(value="attributeMappings")
    @Nullable
    public AttributeMappings getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    @JsonProperty(value="externalGroupsWhitelist")
    @Nullable
    public List<String> getExternalGroupsWhitelist() {
        return this.externalGroupsWhitelist;
    }

    @Override
    @JsonProperty(value="storeCustomAttributes")
    @Nullable
    public Boolean getStoreCustomAttributes() {
        return this.storeCustomAttributes;
    }

    @Override
    @JsonProperty(value="emailDomain")
    @Nullable
    public List<String> getEmailDomains() {
        return this.emailDomains;
    }

    @Override
    @JsonProperty(value="providerDescription")
    @Nullable
    public String getProviderDescription() {
        return this.providerDescription;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OAuth2Configuration && this.equalTo((OAuth2Configuration)another);
    }

    private boolean equalTo(OAuth2Configuration another) {
        return Objects.equals(this.checkTokenUrl, another.checkTokenUrl) && Objects.equals(this.clientAuthInBody, another.clientAuthInBody) && Objects.equals(this.issuer, another.issuer) && Objects.equals(this.responseType, another.responseType) && Objects.equals(this.addShadowUserOnLogin, another.addShadowUserOnLogin) && this.authUrl.equals(another.authUrl) && Objects.equals(this.linkText, another.linkText) && this.relyingPartyId.equals(another.relyingPartyId) && Objects.equals(this.relyingPartySecret, another.relyingPartySecret) && Objects.equals(this.scopes, another.scopes) && Objects.equals(this.showLinkText, another.showLinkText) && Objects.equals(this.skipSslVerification, another.skipSslVerification) && Objects.equals(this.tokenKey, another.tokenKey) && Objects.equals(this.tokenKeyUrl, another.tokenKeyUrl) && this.tokenUrl.equals(another.tokenUrl) && Objects.equals(this.attributeMappings, another.attributeMappings) && Objects.equals(this.externalGroupsWhitelist, another.externalGroupsWhitelist) && Objects.equals(this.storeCustomAttributes, another.storeCustomAttributes) && Objects.equals(this.emailDomains, another.emailDomains) && Objects.equals(this.providerDescription, another.providerDescription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.checkTokenUrl);
        h += (h << 5) + Objects.hashCode(this.clientAuthInBody);
        h += (h << 5) + Objects.hashCode(this.issuer);
        h += (h << 5) + Objects.hashCode(this.responseType);
        h += (h << 5) + Objects.hashCode(this.addShadowUserOnLogin);
        h += (h << 5) + this.authUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.linkText);
        h += (h << 5) + this.relyingPartyId.hashCode();
        h += (h << 5) + Objects.hashCode(this.relyingPartySecret);
        h += (h << 5) + Objects.hashCode(this.scopes);
        h += (h << 5) + Objects.hashCode(this.showLinkText);
        h += (h << 5) + Objects.hashCode(this.skipSslVerification);
        h += (h << 5) + Objects.hashCode(this.tokenKey);
        h += (h << 5) + Objects.hashCode(this.tokenKeyUrl);
        h += (h << 5) + this.tokenUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.attributeMappings);
        h += (h << 5) + Objects.hashCode(this.externalGroupsWhitelist);
        h += (h << 5) + Objects.hashCode(this.storeCustomAttributes);
        h += (h << 5) + Objects.hashCode(this.emailDomains);
        h += (h << 5) + Objects.hashCode(this.providerDescription);
        return h;
    }

    public String toString() {
        return "OAuth2Configuration{checkTokenUrl=" + this.checkTokenUrl + ", clientAuthInBody=" + this.clientAuthInBody + ", issuer=" + this.issuer + ", responseType=" + this.responseType + ", addShadowUserOnLogin=" + this.addShadowUserOnLogin + ", authUrl=" + this.authUrl + ", linkText=" + this.linkText + ", relyingPartyId=" + this.relyingPartyId + ", relyingPartySecret=" + this.relyingPartySecret + ", scopes=" + this.scopes + ", showLinkText=" + this.showLinkText + ", skipSslVerification=" + this.skipSslVerification + ", tokenKey=" + this.tokenKey + ", tokenKeyUrl=" + this.tokenKeyUrl + ", tokenUrl=" + this.tokenUrl + ", attributeMappings=" + this.attributeMappings + ", externalGroupsWhitelist=" + this.externalGroupsWhitelist + ", storeCustomAttributes=" + this.storeCustomAttributes + ", emailDomains=" + this.emailDomains + ", providerDescription=" + this.providerDescription + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static OAuth2Configuration fromJson(Json json) {
        Builder builder = OAuth2Configuration.builder();
        if (json.checkTokenUrl != null) {
            builder.checkTokenUrl(json.checkTokenUrl);
        }
        if (json.clientAuthInBody != null) {
            builder.clientAuthInBody(json.clientAuthInBody);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        if (json.responseType != null) {
            builder.responseType(json.responseType);
        }
        if (json.addShadowUserOnLogin != null) {
            builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
        }
        if (json.authUrl != null) {
            builder.authUrl(json.authUrl);
        }
        if (json.linkText != null) {
            builder.linkText(json.linkText);
        }
        if (json.relyingPartyId != null) {
            builder.relyingPartyId(json.relyingPartyId);
        }
        if (json.relyingPartySecret != null) {
            builder.relyingPartySecret(json.relyingPartySecret);
        }
        if (json.scopes != null) {
            builder.addAllScopes(json.scopes);
        }
        if (json.showLinkText != null) {
            builder.showLinkText(json.showLinkText);
        }
        if (json.skipSslVerification != null) {
            builder.skipSslVerification(json.skipSslVerification);
        }
        if (json.tokenKey != null) {
            builder.tokenKey(json.tokenKey);
        }
        if (json.tokenKeyUrl != null) {
            builder.tokenKeyUrl(json.tokenKeyUrl);
        }
        if (json.tokenUrl != null) {
            builder.tokenUrl(json.tokenUrl);
        }
        if (json.attributeMappings != null) {
            builder.attributeMappings(json.attributeMappings);
        }
        if (json.externalGroupsWhitelist != null) {
            builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
        }
        if (json.storeCustomAttributes != null) {
            builder.storeCustomAttributes(json.storeCustomAttributes);
        }
        if (json.emailDomains != null) {
            builder.addAllEmailDomains(json.emailDomains);
        }
        if (json.providerDescription != null) {
            builder.providerDescription(json.providerDescription);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTH_URL = 1L;
        private static final long INIT_BIT_RELYING_PARTY_ID = 2L;
        private static final long INIT_BIT_TOKEN_URL = 4L;
        private long initBits = 7L;
        private String checkTokenUrl;
        private Boolean clientAuthInBody;
        private String issuer;
        private String responseType;
        private Boolean addShadowUserOnLogin;
        private String authUrl;
        private Boolean linkText;
        private String relyingPartyId;
        private String relyingPartySecret;
        private List<String> scopes = null;
        private Boolean showLinkText;
        private Boolean skipSslVerification;
        private String tokenKey;
        private String tokenKeyUrl;
        private String tokenUrl;
        private AttributeMappings attributeMappings;
        private List<String> externalGroupsWhitelist = null;
        private Boolean storeCustomAttributes;
        private List<String> emailDomains = null;
        private String providerDescription;

        private Builder() {
        }

        public final Builder from(OAuth2Configuration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_OAuth2Configuration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractIdentityProviderConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractAuthenticationConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractIdentityProviderConfiguration instance;
            if (object instanceof _OAuth2Configuration) {
                String checkTokenUrlValue;
                Boolean clientAuthInBodyValue;
                String issuerValue;
                instance = (_OAuth2Configuration)object;
                String responseTypeValue = ((_OAuth2Configuration)instance).getResponseType();
                if (responseTypeValue != null) {
                    this.responseType(responseTypeValue);
                }
                if ((issuerValue = ((_OAuth2Configuration)instance).getIssuer()) != null) {
                    this.issuer(issuerValue);
                }
                if ((clientAuthInBodyValue = ((_OAuth2Configuration)instance).getClientAuthInBody()) != null) {
                    this.clientAuthInBody(clientAuthInBodyValue);
                }
                if ((checkTokenUrlValue = ((_OAuth2Configuration)instance).getCheckTokenUrl()) != null) {
                    this.checkTokenUrl(checkTokenUrlValue);
                }
            }
            if (object instanceof AbstractIdentityProviderConfiguration) {
                String providerDescriptionValue;
                instance = (AbstractIdentityProviderConfiguration)object;
                List<String> emailDomainsValue = instance.getEmailDomains();
                if (emailDomainsValue != null) {
                    this.addAllEmailDomains(emailDomainsValue);
                }
                if ((providerDescriptionValue = instance.getProviderDescription()) != null) {
                    this.providerDescription(providerDescriptionValue);
                }
            }
            if (object instanceof AbstractExternalIdentityProviderConfiguration) {
                Boolean storeCustomAttributesValue;
                AttributeMappings attributeMappingsValue;
                instance = (AbstractExternalIdentityProviderConfiguration)object;
                List<String> externalGroupsWhitelistValue = ((AbstractExternalIdentityProviderConfiguration)instance).getExternalGroupsWhitelist();
                if (externalGroupsWhitelistValue != null) {
                    this.addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
                }
                if ((attributeMappingsValue = ((AbstractExternalIdentityProviderConfiguration)instance).getAttributeMappings()) != null) {
                    this.attributeMappings(attributeMappingsValue);
                }
                if ((storeCustomAttributesValue = ((AbstractExternalIdentityProviderConfiguration)instance).getStoreCustomAttributes()) != null) {
                    this.storeCustomAttributes(storeCustomAttributesValue);
                }
            }
            if (object instanceof AbstractAuthenticationConfiguration) {
                Boolean addShadowUserOnLoginValue;
                Boolean linkTextValue;
                Boolean skipSslVerificationValue;
                String relyingPartySecretValue;
                instance = (AbstractAuthenticationConfiguration)object;
                Boolean showLinkTextValue = ((AbstractAuthenticationConfiguration)instance).getShowLinkText();
                if (showLinkTextValue != null) {
                    this.showLinkText(showLinkTextValue);
                }
                this.authUrl(((AbstractAuthenticationConfiguration)instance).getAuthUrl());
                String tokenKeyValue = ((AbstractAuthenticationConfiguration)instance).getTokenKey();
                if (tokenKeyValue != null) {
                    this.tokenKey(tokenKeyValue);
                }
                if ((relyingPartySecretValue = ((AbstractAuthenticationConfiguration)instance).getRelyingPartySecret()) != null) {
                    this.relyingPartySecret(relyingPartySecretValue);
                }
                this.tokenUrl(((AbstractAuthenticationConfiguration)instance).getTokenUrl());
                String tokenKeyUrlValue = ((AbstractAuthenticationConfiguration)instance).getTokenKeyUrl();
                if (tokenKeyUrlValue != null) {
                    this.tokenKeyUrl(tokenKeyUrlValue);
                }
                if ((skipSslVerificationValue = ((AbstractAuthenticationConfiguration)instance).getSkipSslVerification()) != null) {
                    this.skipSslVerification(skipSslVerificationValue);
                }
                if ((linkTextValue = ((AbstractAuthenticationConfiguration)instance).getLinkText()) != null) {
                    this.linkText(linkTextValue);
                }
                this.relyingPartyId(((AbstractAuthenticationConfiguration)instance).getRelyingPartyId());
                List<String> scopesValue = ((AbstractAuthenticationConfiguration)instance).getScopes();
                if (scopesValue != null) {
                    this.addAllScopes(scopesValue);
                }
                if ((addShadowUserOnLoginValue = ((AbstractAuthenticationConfiguration)instance).getAddShadowUserOnLogin()) != null) {
                    this.addShadowUserOnLogin(addShadowUserOnLoginValue);
                }
            }
        }

        @JsonProperty(value="checkTokenUrl")
        public final Builder checkTokenUrl(@Nullable String checkTokenUrl) {
            this.checkTokenUrl = checkTokenUrl;
            return this;
        }

        @JsonProperty(value="clientAuthInBody")
        public final Builder clientAuthInBody(@Nullable Boolean clientAuthInBody) {
            this.clientAuthInBody = clientAuthInBody;
            return this;
        }

        @JsonProperty(value="issuer")
        public final Builder issuer(@Nullable String issuer) {
            this.issuer = issuer;
            return this;
        }

        @JsonProperty(value="responseType")
        public final Builder responseType(@Nullable String responseType) {
            this.responseType = responseType;
            return this;
        }

        @JsonProperty(value="addShadowUserOnLogin")
        public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
            this.addShadowUserOnLogin = addShadowUserOnLogin;
            return this;
        }

        @JsonProperty(value="authUrl")
        public final Builder authUrl(String authUrl) {
            this.authUrl = Objects.requireNonNull(authUrl, "authUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="linkText")
        public final Builder linkText(@Nullable Boolean linkText) {
            this.linkText = linkText;
            return this;
        }

        @JsonProperty(value="relyingPartyId")
        public final Builder relyingPartyId(String relyingPartyId) {
            this.relyingPartyId = Objects.requireNonNull(relyingPartyId, "relyingPartyId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="relyingPartySecret")
        public final Builder relyingPartySecret(@Nullable String relyingPartySecret) {
            this.relyingPartySecret = relyingPartySecret;
            return this;
        }

        public final Builder scope(String element) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scopes(String ... elements) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="scopes")
        public final Builder scopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.scopes = null;
                return this;
            }
            this.scopes = new ArrayList<String>();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "scopes element");
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="showLinkText")
        public final Builder showLinkText(@Nullable Boolean showLinkText) {
            this.showLinkText = showLinkText;
            return this;
        }

        @JsonProperty(value="skipSslValidation")
        public final Builder skipSslVerification(@Nullable Boolean skipSslVerification) {
            this.skipSslVerification = skipSslVerification;
            return this;
        }

        @JsonProperty(value="tokenKey")
        public final Builder tokenKey(@Nullable String tokenKey) {
            this.tokenKey = tokenKey;
            return this;
        }

        @JsonProperty(value="tokenKeyUrl")
        public final Builder tokenKeyUrl(@Nullable String tokenKeyUrl) {
            this.tokenKeyUrl = tokenKeyUrl;
            return this;
        }

        @JsonProperty(value="tokenUrl")
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = Objects.requireNonNull(tokenUrl, "tokenUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="attributeMappings")
        public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
            this.attributeMappings = attributeMappings;
            return this;
        }

        public final Builder externalGroupsWhitelist(String element) {
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            return this;
        }

        public final Builder externalGroupsWhitelist(String ... elements) {
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            }
            return this;
        }

        @JsonProperty(value="externalGroupsWhitelist")
        public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.externalGroupsWhitelist = null;
                return this;
            }
            this.externalGroupsWhitelist = new ArrayList<String>();
            return this.addAllExternalGroupsWhitelist(elements);
        }

        public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
            Objects.requireNonNull(elements, "externalGroupsWhitelist element");
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            }
            return this;
        }

        @JsonProperty(value="storeCustomAttributes")
        public final Builder storeCustomAttributes(@Nullable Boolean storeCustomAttributes) {
            this.storeCustomAttributes = storeCustomAttributes;
            return this;
        }

        public final Builder emailDomain(String element) {
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            return this;
        }

        public final Builder emailDomains(String ... elements) {
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            }
            return this;
        }

        @JsonProperty(value="emailDomain")
        public final Builder emailDomains(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.emailDomains = null;
                return this;
            }
            this.emailDomains = new ArrayList<String>();
            return this.addAllEmailDomains(elements);
        }

        public final Builder addAllEmailDomains(Iterable<String> elements) {
            Objects.requireNonNull(elements, "emailDomains element");
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            }
            return this;
        }

        @JsonProperty(value="providerDescription")
        public final Builder providerDescription(@Nullable String providerDescription) {
            this.providerDescription = providerDescription;
            return this;
        }

        public OAuth2Configuration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OAuth2Configuration(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authUrl");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relyingPartyId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tokenUrl");
            }
            return "Cannot build OAuth2Configuration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _OAuth2Configuration {
        String checkTokenUrl;
        Boolean clientAuthInBody;
        String issuer;
        String responseType;
        Boolean addShadowUserOnLogin;
        String authUrl;
        Boolean linkText;
        String relyingPartyId;
        String relyingPartySecret;
        List<String> scopes = null;
        Boolean showLinkText;
        Boolean skipSslVerification;
        String tokenKey;
        String tokenKeyUrl;
        String tokenUrl;
        AttributeMappings attributeMappings;
        List<String> externalGroupsWhitelist = null;
        Boolean storeCustomAttributes;
        List<String> emailDomains = null;
        String providerDescription;

        Json() {
        }

        @JsonProperty(value="checkTokenUrl")
        public void setCheckTokenUrl(@Nullable String checkTokenUrl) {
            this.checkTokenUrl = checkTokenUrl;
        }

        @JsonProperty(value="clientAuthInBody")
        public void setClientAuthInBody(@Nullable Boolean clientAuthInBody) {
            this.clientAuthInBody = clientAuthInBody;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(@Nullable String issuer) {
            this.issuer = issuer;
        }

        @JsonProperty(value="responseType")
        public void setResponseType(@Nullable String responseType) {
            this.responseType = responseType;
        }

        @JsonProperty(value="addShadowUserOnLogin")
        public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
            this.addShadowUserOnLogin = addShadowUserOnLogin;
        }

        @JsonProperty(value="authUrl")
        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @JsonProperty(value="linkText")
        public void setLinkText(@Nullable Boolean linkText) {
            this.linkText = linkText;
        }

        @JsonProperty(value="relyingPartyId")
        public void setRelyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
        }

        @JsonProperty(value="relyingPartySecret")
        public void setRelyingPartySecret(@Nullable String relyingPartySecret) {
            this.relyingPartySecret = relyingPartySecret;
        }

        @JsonProperty(value="scopes")
        public void setScopes(@Nullable List<String> scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="showLinkText")
        public void setShowLinkText(@Nullable Boolean showLinkText) {
            this.showLinkText = showLinkText;
        }

        @JsonProperty(value="skipSslValidation")
        public void setSkipSslVerification(@Nullable Boolean skipSslVerification) {
            this.skipSslVerification = skipSslVerification;
        }

        @JsonProperty(value="tokenKey")
        public void setTokenKey(@Nullable String tokenKey) {
            this.tokenKey = tokenKey;
        }

        @JsonProperty(value="tokenKeyUrl")
        public void setTokenKeyUrl(@Nullable String tokenKeyUrl) {
            this.tokenKeyUrl = tokenKeyUrl;
        }

        @JsonProperty(value="tokenUrl")
        public void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @JsonProperty(value="attributeMappings")
        public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
            this.attributeMappings = attributeMappings;
        }

        @JsonProperty(value="externalGroupsWhitelist")
        public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
            this.externalGroupsWhitelist = externalGroupsWhitelist;
        }

        @JsonProperty(value="storeCustomAttributes")
        public void setStoreCustomAttributes(@Nullable Boolean storeCustomAttributes) {
            this.storeCustomAttributes = storeCustomAttributes;
        }

        @JsonProperty(value="emailDomain")
        public void setEmailDomains(@Nullable List<String> emailDomains) {
            this.emailDomains = emailDomains;
        }

        @JsonProperty(value="providerDescription")
        public void setProviderDescription(@Nullable String providerDescription) {
            this.providerDescription = providerDescription;
        }

        @Override
        public String getCheckTokenUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getClientAuthInBody() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIssuer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResponseType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getAddShadowUserOnLogin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getLinkText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRelyingPartyId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRelyingPartySecret() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getShowLinkText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getSkipSslVerification() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenKeyUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttributeMappings getAttributeMappings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getExternalGroupsWhitelist() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getStoreCustomAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getEmailDomains() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProviderDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

