/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones.RefreshTokenFormat;
import org.cloudfoundry.uaa.identityzones._TokenPolicy;
import org.immutables.value.Generated;

@Generated(from="_TokenPolicy", generator="Immutables")
public final class TokenPolicy
extends _TokenPolicy {
    @Nullable
    private final Integer accessTokenValidity;
    @Nullable
    private final String activeKeyId;
    @Nullable
    private final Boolean jwtRevocable;
    @Nullable
    private final Map<String, Object> keys;
    @Nullable
    private final RefreshTokenFormat refreshTokenFormat;
    @Nullable
    private final Boolean refreshTokenUnique;
    @Nullable
    private final Integer refreshTokenValidity;

    private TokenPolicy(Builder builder) {
        this.accessTokenValidity = builder.accessTokenValidity;
        this.activeKeyId = builder.activeKeyId;
        this.jwtRevocable = builder.jwtRevocable;
        this.keys = builder.keys == null ? null : TokenPolicy.createUnmodifiableMap(false, false, builder.keys);
        this.refreshTokenFormat = builder.refreshTokenFormat;
        this.refreshTokenUnique = builder.refreshTokenUnique;
        this.refreshTokenValidity = builder.refreshTokenValidity;
    }

    @Override
    @JsonProperty(value="accessTokenValidity")
    @Nullable
    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    @Override
    @JsonProperty(value="activeKeyId")
    @Nullable
    public String getActiveKeyId() {
        return this.activeKeyId;
    }

    @Override
    @JsonProperty(value="jwtRevocable")
    @Nullable
    public Boolean getJwtRevocable() {
        return this.jwtRevocable;
    }

    @Override
    @JsonProperty(value="keys")
    @Nullable
    public Map<String, Object> getKeys() {
        return this.keys;
    }

    @Override
    @JsonProperty(value="refreshTokenFormat")
    @Nullable
    public RefreshTokenFormat getRefreshTokenFormat() {
        return this.refreshTokenFormat;
    }

    @Override
    @JsonProperty(value="refreshTokenUnique")
    @Nullable
    public Boolean getRefreshTokenUnique() {
        return this.refreshTokenUnique;
    }

    @Override
    @JsonProperty(value="refreshTokenValidity")
    @Nullable
    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TokenPolicy && this.equalTo((TokenPolicy)another);
    }

    private boolean equalTo(TokenPolicy another) {
        return Objects.equals(this.accessTokenValidity, another.accessTokenValidity) && Objects.equals(this.activeKeyId, another.activeKeyId) && Objects.equals(this.jwtRevocable, another.jwtRevocable) && Objects.equals(this.keys, another.keys) && Objects.equals((Object)this.refreshTokenFormat, (Object)another.refreshTokenFormat) && Objects.equals(this.refreshTokenUnique, another.refreshTokenUnique) && Objects.equals(this.refreshTokenValidity, another.refreshTokenValidity);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.accessTokenValidity);
        h += (h << 5) + Objects.hashCode(this.activeKeyId);
        h += (h << 5) + Objects.hashCode(this.jwtRevocable);
        h += (h << 5) + Objects.hashCode(this.keys);
        h += (h << 5) + Objects.hashCode((Object)this.refreshTokenFormat);
        h += (h << 5) + Objects.hashCode(this.refreshTokenUnique);
        h += (h << 5) + Objects.hashCode(this.refreshTokenValidity);
        return h;
    }

    public String toString() {
        return "TokenPolicy{accessTokenValidity=" + this.accessTokenValidity + ", activeKeyId=" + this.activeKeyId + ", jwtRevocable=" + this.jwtRevocable + ", keys=" + this.keys + ", refreshTokenFormat=" + (Object)((Object)this.refreshTokenFormat) + ", refreshTokenUnique=" + this.refreshTokenUnique + ", refreshTokenValidity=" + this.refreshTokenValidity + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static TokenPolicy fromJson(Json json) {
        Builder builder = TokenPolicy.builder();
        if (json.accessTokenValidity != null) {
            builder.accessTokenValidity(json.accessTokenValidity);
        }
        if (json.activeKeyId != null) {
            builder.activeKeyId(json.activeKeyId);
        }
        if (json.jwtRevocable != null) {
            builder.jwtRevocable(json.jwtRevocable);
        }
        if (json.keys != null) {
            builder.putAllKeys(json.keys);
        }
        if (json.refreshTokenFormat != null) {
            builder.refreshTokenFormat(json.refreshTokenFormat);
        }
        if (json.refreshTokenUnique != null) {
            builder.refreshTokenUnique(json.refreshTokenUnique);
        }
        if (json.refreshTokenValidity != null) {
            builder.refreshTokenValidity(json.refreshTokenValidity);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Integer accessTokenValidity;
        private String activeKeyId;
        private Boolean jwtRevocable;
        private Map<String, Object> keys = null;
        private RefreshTokenFormat refreshTokenFormat;
        private Boolean refreshTokenUnique;
        private Integer refreshTokenValidity;

        private Builder() {
        }

        public final Builder from(TokenPolicy instance) {
            return this.from((_TokenPolicy)instance);
        }

        final Builder from(_TokenPolicy instance) {
            Integer refreshTokenValidityValue;
            Boolean refreshTokenUniqueValue;
            RefreshTokenFormat refreshTokenFormatValue;
            Map<String, Object> keysValue;
            Boolean jwtRevocableValue;
            String activeKeyIdValue;
            Objects.requireNonNull(instance, "instance");
            Integer accessTokenValidityValue = instance.getAccessTokenValidity();
            if (accessTokenValidityValue != null) {
                this.accessTokenValidity(accessTokenValidityValue);
            }
            if ((activeKeyIdValue = instance.getActiveKeyId()) != null) {
                this.activeKeyId(activeKeyIdValue);
            }
            if ((jwtRevocableValue = instance.getJwtRevocable()) != null) {
                this.jwtRevocable(jwtRevocableValue);
            }
            if ((keysValue = instance.getKeys()) != null) {
                this.putAllKeys(keysValue);
            }
            if ((refreshTokenFormatValue = instance.getRefreshTokenFormat()) != null) {
                this.refreshTokenFormat(refreshTokenFormatValue);
            }
            if ((refreshTokenUniqueValue = instance.getRefreshTokenUnique()) != null) {
                this.refreshTokenUnique(refreshTokenUniqueValue);
            }
            if ((refreshTokenValidityValue = instance.getRefreshTokenValidity()) != null) {
                this.refreshTokenValidity(refreshTokenValidityValue);
            }
            return this;
        }

        @JsonProperty(value="accessTokenValidity")
        public final Builder accessTokenValidity(@Nullable Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        @JsonProperty(value="activeKeyId")
        public final Builder activeKeyId(@Nullable String activeKeyId) {
            this.activeKeyId = activeKeyId;
            return this;
        }

        @JsonProperty(value="jwtRevocable")
        public final Builder jwtRevocable(@Nullable Boolean jwtRevocable) {
            this.jwtRevocable = jwtRevocable;
            return this;
        }

        public final Builder key(String key, Object value) {
            if (this.keys == null) {
                this.keys = new LinkedHashMap<String, Object>();
            }
            this.keys.put(key, value);
            return this;
        }

        public final Builder key(Map.Entry<String, ? extends Object> entry) {
            if (this.keys == null) {
                this.keys = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.keys.put(k, v);
            return this;
        }

        @JsonProperty(value="keys")
        public final Builder keys(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.keys = null;
                return this;
            }
            this.keys = new LinkedHashMap<String, Object>();
            return this.putAllKeys(entries);
        }

        public final Builder putAllKeys(Map<String, ? extends Object> entries) {
            if (this.keys == null) {
                this.keys = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.keys.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="refreshTokenFormat")
        public final Builder refreshTokenFormat(@Nullable RefreshTokenFormat refreshTokenFormat) {
            this.refreshTokenFormat = refreshTokenFormat;
            return this;
        }

        @JsonProperty(value="refreshTokenUnique")
        public final Builder refreshTokenUnique(@Nullable Boolean refreshTokenUnique) {
            this.refreshTokenUnique = refreshTokenUnique;
            return this;
        }

        @JsonProperty(value="refreshTokenValidity")
        public final Builder refreshTokenValidity(@Nullable Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public TokenPolicy build() {
            return new TokenPolicy(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _TokenPolicy {
        Integer accessTokenValidity;
        String activeKeyId;
        Boolean jwtRevocable;
        Map<String, Object> keys = null;
        RefreshTokenFormat refreshTokenFormat;
        Boolean refreshTokenUnique;
        Integer refreshTokenValidity;

        Json() {
        }

        @JsonProperty(value="accessTokenValidity")
        public void setAccessTokenValidity(@Nullable Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        @JsonProperty(value="activeKeyId")
        public void setActiveKeyId(@Nullable String activeKeyId) {
            this.activeKeyId = activeKeyId;
        }

        @JsonProperty(value="jwtRevocable")
        public void setJwtRevocable(@Nullable Boolean jwtRevocable) {
            this.jwtRevocable = jwtRevocable;
        }

        @JsonProperty(value="keys")
        public void setKeys(@Nullable Map<String, Object> keys) {
            this.keys = keys;
        }

        @JsonProperty(value="refreshTokenFormat")
        public void setRefreshTokenFormat(@Nullable RefreshTokenFormat refreshTokenFormat) {
            this.refreshTokenFormat = refreshTokenFormat;
        }

        @JsonProperty(value="refreshTokenUnique")
        public void setRefreshTokenUnique(@Nullable Boolean refreshTokenUnique) {
            this.refreshTokenUnique = refreshTokenUnique;
        }

        @JsonProperty(value="refreshTokenValidity")
        public void setRefreshTokenValidity(@Nullable Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        @Override
        public Integer getAccessTokenValidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActiveKeyId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getJwtRevocable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RefreshTokenFormat getRefreshTokenFormat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getRefreshTokenUnique() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getRefreshTokenValidity() {
            throw new UnsupportedOperationException();
        }
    }
}

