/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.tokens.TokenFormat;
import org.cloudfoundry.uaa.tokens._GetTokenByPasswordRequest;
import org.immutables.value.Generated;

@Generated(from="_GetTokenByPasswordRequest", generator="Immutables")
public final class GetTokenByPasswordRequest
extends _GetTokenByPasswordRequest {
    private final String clientId;
    private final String clientSecret;
    private final String password;
    @Nullable
    private final TokenFormat tokenFormat;
    private final String username;

    private GetTokenByPasswordRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.password = builder.password;
        this.tokenFormat = builder.tokenFormat;
        this.username = builder.username;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    public TokenFormat getTokenFormat() {
        return this.tokenFormat;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetTokenByPasswordRequest && this.equalTo((GetTokenByPasswordRequest)another);
    }

    private boolean equalTo(GetTokenByPasswordRequest another) {
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && this.password.equals(another.password) && Objects.equals((Object)this.tokenFormat, (Object)another.tokenFormat) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.tokenFormat);
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "GetTokenByPasswordRequest{clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", password=" + this.password + ", tokenFormat=" + (Object)((Object)this.tokenFormat) + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private static final long INIT_BIT_PASSWORD = 4L;
        private static final long INIT_BIT_USERNAME = 8L;
        private long initBits = 15L;
        private String clientId;
        private String clientSecret;
        private String password;
        private TokenFormat tokenFormat;
        private String username;

        private Builder() {
        }

        public final Builder from(GetTokenByPasswordRequest instance) {
            return this.from((_GetTokenByPasswordRequest)instance);
        }

        final Builder from(_GetTokenByPasswordRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.getClientId());
            this.clientSecret(instance.getClientSecret());
            this.password(instance.getPassword());
            TokenFormat tokenFormatValue = instance.getTokenFormat();
            if (tokenFormatValue != null) {
                this.tokenFormat(tokenFormatValue);
            }
            this.username(instance.getUsername());
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
            this.tokenFormat = tokenFormat;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public GetTokenByPasswordRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetTokenByPasswordRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build GetTokenByPasswordRequest, some of required attributes are not set " + attributes;
        }
    }
}

