/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.routes._ListRouteApplicationsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListRouteApplicationsRequest", generator="Immutables")
public final class ListRouteApplicationsRequest
extends _ListRouteApplicationsRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final String applicationId;
    @Nullable
    private final Boolean diego;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> organizationIds;
    private final String routeId;
    @Nullable
    private final List<String> spaceIds;
    @Nullable
    private final List<String> stackIds;

    private ListRouteApplicationsRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.applicationId = builder.applicationId;
        this.diego = builder.diego;
        this.names = builder.names == null ? null : ListRouteApplicationsRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = builder.organizationIds == null ? null : ListRouteApplicationsRequest.createUnmodifiableList(true, builder.organizationIds);
        this.routeId = builder.routeId;
        this.spaceIds = builder.spaceIds == null ? null : ListRouteApplicationsRequest.createUnmodifiableList(true, builder.spaceIds);
        this.stackIds = builder.stackIds == null ? null : ListRouteApplicationsRequest.createUnmodifiableList(true, builder.stackIds);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public Boolean getDiego() {
        return this.diego;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    @Nullable
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    @Nullable
    public List<String> getStackIds() {
        return this.stackIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListRouteApplicationsRequest && this.equalTo((ListRouteApplicationsRequest)another);
    }

    private boolean equalTo(ListRouteApplicationsRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.applicationId, another.applicationId) && Objects.equals(this.diego, another.diego) && Objects.equals(this.names, another.names) && Objects.equals(this.organizationIds, another.organizationIds) && this.routeId.equals(another.routeId) && Objects.equals(this.spaceIds, another.spaceIds) && Objects.equals(this.stackIds, another.stackIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.applicationId);
        h += (h << 5) + Objects.hashCode(this.diego);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + this.routeId.hashCode();
        h += (h << 5) + Objects.hashCode(this.spaceIds);
        h += (h << 5) + Objects.hashCode(this.stackIds);
        return h;
    }

    public String toString() {
        return "ListRouteApplicationsRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationId=" + this.applicationId + ", diego=" + this.diego + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", routeId=" + this.routeId + ", spaceIds=" + this.spaceIds + ", stackIds=" + this.stackIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListRouteApplicationsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private long initBits = 1L;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String applicationId;
        private Boolean diego;
        private List<String> names = null;
        private List<String> organizationIds = null;
        private String routeId;
        private List<String> spaceIds = null;
        private List<String> stackIds = null;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListRouteApplicationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListRouteApplicationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListRouteApplicationsRequest) {
                String applicationIdValue;
                List<String> spaceIdsValue;
                Boolean diegoValue;
                List<String> organizationIdsValue;
                instance = (_ListRouteApplicationsRequest)object;
                List<String> namesValue = ((_ListRouteApplicationsRequest)instance).getNames();
                if (namesValue != null) {
                    this.addAllNames(namesValue);
                }
                this.routeId(((_ListRouteApplicationsRequest)instance).getRouteId());
                List<String> stackIdsValue = ((_ListRouteApplicationsRequest)instance).getStackIds();
                if (stackIdsValue != null) {
                    this.addAllStackIds(stackIdsValue);
                }
                if ((organizationIdsValue = ((_ListRouteApplicationsRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
                if ((diegoValue = ((_ListRouteApplicationsRequest)instance).getDiego()) != null) {
                    this.diego(diegoValue);
                }
                if ((spaceIdsValue = ((_ListRouteApplicationsRequest)instance).getSpaceIds()) != null) {
                    this.addAllSpaceIds(spaceIdsValue);
                }
                if ((applicationIdValue = ((_ListRouteApplicationsRequest)instance).getApplicationId()) != null) {
                    this.applicationId(applicationIdValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder applicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder diego(@Nullable Boolean diego) {
            this.diego = diego;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder spaceId(String element) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.spaceIds = null;
                return this;
            }
            this.spaceIds = new ArrayList<String>();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "spaceIds element");
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder stackId(String element) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList<String>();
            }
            this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
            return this;
        }

        public final Builder stackIds(String ... elements) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
            }
            return this;
        }

        public final Builder stackIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.stackIds = null;
                return this;
            }
            this.stackIds = new ArrayList<String>();
            return this.addAllStackIds(elements);
        }

        public final Builder addAllStackIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "stackIds element");
            if (this.stackIds == null) {
                this.stackIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
            }
            return this;
        }

        public ListRouteApplicationsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListRouteApplicationsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build ListRouteApplicationsRequest, some of required attributes are not set " + attributes;
        }
    }
}

