/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances._GatewayData;
import org.immutables.value.Generated;

@Generated(from="_GatewayData", generator="Immutables")
public final class GatewayData
extends _GatewayData {
    private final String name;
    @Nullable
    private final Map<String, String> options;
    private final String plan;

    private GatewayData(Builder builder) {
        this.name = builder.name;
        this.options = builder.options == null ? null : GatewayData.createUnmodifiableMap(false, false, builder.options);
        this.plan = builder.plan;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="options")
    @Nullable
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty(value="plan")
    public String getPlan() {
        return this.plan;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GatewayData && this.equalTo((GatewayData)another);
    }

    private boolean equalTo(GatewayData another) {
        return this.name.equals(another.name) && Objects.equals(this.options, another.options) && this.plan.equals(another.plan);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.options);
        h += (h << 5) + this.plan.hashCode();
        return h;
    }

    public String toString() {
        return "GatewayData{name=" + this.name + ", options=" + this.options + ", plan=" + this.plan + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GatewayData fromJson(Json json) {
        Builder builder = GatewayData.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.options != null) {
            builder.putAllOptions(json.options);
        }
        if (json.plan != null) {
            builder.plan(json.plan);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_GatewayData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PLAN = 2L;
        private long initBits = 3L;
        private String name;
        private Map<String, String> options = null;
        private String plan;

        private Builder() {
        }

        public final Builder from(GatewayData instance) {
            return this.from((_GatewayData)instance);
        }

        final Builder from(_GatewayData instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            Map<String, String> optionsValue = instance.getOptions();
            if (optionsValue != null) {
                this.putAllOptions(optionsValue);
            }
            this.plan(instance.getPlan());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder option(String key, String value) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            this.options.put(key, value);
            return this;
        }

        public final Builder option(Map.Entry<String, ? extends String> entry) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.options.put(k, v);
            return this;
        }

        @JsonProperty(value="options")
        public final Builder options(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.options = null;
                return this;
            }
            this.options = new LinkedHashMap<String, String>();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.options.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="plan")
        public final Builder plan(String plan) {
            this.plan = Objects.requireNonNull(plan, "plan");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public GatewayData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GatewayData(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("plan");
            }
            return "Cannot build GatewayData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GatewayData", generator="Immutables")
    static final class Json
    extends _GatewayData {
        String name;
        Map<String, String> options = null;
        String plan;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="options")
        public void setOptions(@Nullable Map<String, String> options) {
            this.options = options;
        }

        @JsonProperty(value="plan")
        public void setPlan(String plan) {
            this.plan = plan;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPlan() {
            throw new UnsupportedOperationException();
        }
    }
}

