/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.serviceinstances._ListServiceInstancesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServiceInstancesRequest", generator="Immutables")
public final class ListServiceInstancesRequest
extends _ListServiceInstancesRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final List<String> gatewayNames;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> organizationIds;
    @Nullable
    private final List<String> serviceBindingIds;
    @Nullable
    private final List<String> serviceKeyIds;
    @Nullable
    private final List<String> servicePlanIds;
    @Nullable
    private final List<String> spaceIds;

    private ListServiceInstancesRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.gatewayNames = builder.gatewayNames == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.gatewayNames);
        this.names = builder.names == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = builder.organizationIds == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.serviceBindingIds = builder.serviceBindingIds == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.serviceBindingIds);
        this.serviceKeyIds = builder.serviceKeyIds == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.serviceKeyIds);
        this.servicePlanIds = builder.servicePlanIds == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.servicePlanIds);
        this.spaceIds = builder.spaceIds == null ? null : ListServiceInstancesRequest.createUnmodifiableList(true, builder.spaceIds);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getGatewayNames() {
        return this.gatewayNames;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    @Nullable
    public List<String> getServiceBindingIds() {
        return this.serviceBindingIds;
    }

    @Override
    @Nullable
    public List<String> getServiceKeyIds() {
        return this.serviceKeyIds;
    }

    @Override
    @Nullable
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    @Override
    @Nullable
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceInstancesRequest && this.equalTo((ListServiceInstancesRequest)another);
    }

    private boolean equalTo(ListServiceInstancesRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.gatewayNames, another.gatewayNames) && Objects.equals(this.names, another.names) && Objects.equals(this.organizationIds, another.organizationIds) && Objects.equals(this.serviceBindingIds, another.serviceBindingIds) && Objects.equals(this.serviceKeyIds, another.serviceKeyIds) && Objects.equals(this.servicePlanIds, another.servicePlanIds) && Objects.equals(this.spaceIds, another.spaceIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.gatewayNames);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + Objects.hashCode(this.serviceBindingIds);
        h += (h << 5) + Objects.hashCode(this.serviceKeyIds);
        h += (h << 5) + Objects.hashCode(this.servicePlanIds);
        h += (h << 5) + Objects.hashCode(this.spaceIds);
        return h;
    }

    public String toString() {
        return "ListServiceInstancesRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", gatewayNames=" + this.gatewayNames + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", serviceBindingIds=" + this.serviceBindingIds + ", serviceKeyIds=" + this.serviceKeyIds + ", servicePlanIds=" + this.servicePlanIds + ", spaceIds=" + this.spaceIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceInstancesRequest", generator="Immutables")
    public static final class Builder {
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> gatewayNames = null;
        private List<String> names = null;
        private List<String> organizationIds = null;
        private List<String> serviceBindingIds = null;
        private List<String> serviceKeyIds = null;
        private List<String> servicePlanIds = null;
        private List<String> spaceIds = null;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListServiceInstancesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListServiceInstancesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceInstancesRequest) {
                List<String> serviceKeyIdsValue;
                List<String> spaceIdsValue;
                List<String> serviceBindingIdsValue;
                List<String> gatewayNamesValue;
                List<String> organizationIdsValue;
                List<String> servicePlanIdsValue;
                instance = (_ListServiceInstancesRequest)object;
                List<String> namesValue = ((_ListServiceInstancesRequest)instance).getNames();
                if (namesValue != null) {
                    this.addAllNames(namesValue);
                }
                if ((servicePlanIdsValue = ((_ListServiceInstancesRequest)instance).getServicePlanIds()) != null) {
                    this.addAllServicePlanIds(servicePlanIdsValue);
                }
                if ((organizationIdsValue = ((_ListServiceInstancesRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
                if ((gatewayNamesValue = ((_ListServiceInstancesRequest)instance).getGatewayNames()) != null) {
                    this.addAllGatewayNames(gatewayNamesValue);
                }
                if ((serviceBindingIdsValue = ((_ListServiceInstancesRequest)instance).getServiceBindingIds()) != null) {
                    this.addAllServiceBindingIds(serviceBindingIdsValue);
                }
                if ((spaceIdsValue = ((_ListServiceInstancesRequest)instance).getSpaceIds()) != null) {
                    this.addAllSpaceIds(spaceIdsValue);
                }
                if ((serviceKeyIdsValue = ((_ListServiceInstancesRequest)instance).getServiceKeyIds()) != null) {
                    this.addAllServiceKeyIds(serviceKeyIdsValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder gatewayName(String element) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList<String>();
            }
            this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
            return this;
        }

        public final Builder gatewayNames(String ... elements) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
            }
            return this;
        }

        public final Builder gatewayNames(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.gatewayNames = null;
                return this;
            }
            this.gatewayNames = new ArrayList<String>();
            return this.addAllGatewayNames(elements);
        }

        public final Builder addAllGatewayNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "gatewayNames element");
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
            }
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder serviceBindingId(String element) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList<String>();
            }
            this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
            return this;
        }

        public final Builder serviceBindingIds(String ... elements) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
            }
            return this;
        }

        public final Builder serviceBindingIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceBindingIds = null;
                return this;
            }
            this.serviceBindingIds = new ArrayList<String>();
            return this.addAllServiceBindingIds(elements);
        }

        public final Builder addAllServiceBindingIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceBindingIds element");
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
            }
            return this;
        }

        public final Builder serviceKeyId(String element) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList<String>();
            }
            this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
            return this;
        }

        public final Builder serviceKeyIds(String ... elements) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
            }
            return this;
        }

        public final Builder serviceKeyIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceKeyIds = null;
                return this;
            }
            this.serviceKeyIds = new ArrayList<String>();
            return this.addAllServiceKeyIds(elements);
        }

        public final Builder addAllServiceKeyIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceKeyIds element");
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
            }
            return this;
        }

        public final Builder servicePlanId(String element) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList<String>();
            }
            this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            return this;
        }

        public final Builder servicePlanIds(String ... elements) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            }
            return this;
        }

        public final Builder servicePlanIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.servicePlanIds = null;
                return this;
            }
            this.servicePlanIds = new ArrayList<String>();
            return this.addAllServicePlanIds(elements);
        }

        public final Builder addAllServicePlanIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "servicePlanIds element");
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.spaceIds = null;
                return this;
            }
            this.spaceIds = new ArrayList<String>();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "spaceIds element");
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public ListServiceInstancesRequest build() {
            return new ListServiceInstancesRequest(this);
        }
    }
}

