/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceplans._UpdateServicePlanRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateServicePlanRequest", generator="Immutables")
public final class UpdateServicePlanRequest
extends _UpdateServicePlanRequest {
    @Nullable
    private final Boolean publiclyVisible;
    private final String servicePlanId;

    private UpdateServicePlanRequest(Builder builder) {
        this.publiclyVisible = builder.publiclyVisible;
        this.servicePlanId = builder.servicePlanId;
    }

    @Override
    @JsonProperty(value="public")
    @Nullable
    public Boolean getPubliclyVisible() {
        return this.publiclyVisible;
    }

    @Override
    @JsonProperty(value="servicePlanId")
    @JsonIgnore
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServicePlanRequest && this.equalTo((UpdateServicePlanRequest)another);
    }

    private boolean equalTo(UpdateServicePlanRequest another) {
        return Objects.equals(this.publiclyVisible, another.publiclyVisible) && this.servicePlanId.equals(another.servicePlanId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.publiclyVisible);
        h += (h << 5) + this.servicePlanId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateServicePlanRequest{publiclyVisible=" + this.publiclyVisible + ", servicePlanId=" + this.servicePlanId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateServicePlanRequest fromJson(Json json) {
        Builder builder = UpdateServicePlanRequest.builder();
        if (json.publiclyVisible != null) {
            builder.publiclyVisible(json.publiclyVisible);
        }
        if (json.servicePlanId != null) {
            builder.servicePlanId(json.servicePlanId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_UpdateServicePlanRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_PLAN_ID = 1L;
        private long initBits = 1L;
        private Boolean publiclyVisible;
        private String servicePlanId;

        private Builder() {
        }

        public final Builder from(UpdateServicePlanRequest instance) {
            return this.from((_UpdateServicePlanRequest)instance);
        }

        final Builder from(_UpdateServicePlanRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean publiclyVisibleValue = instance.getPubliclyVisible();
            if (publiclyVisibleValue != null) {
                this.publiclyVisible(publiclyVisibleValue);
            }
            this.servicePlanId(instance.getServicePlanId());
            return this;
        }

        public final Builder publiclyVisible(@Nullable Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
            return this;
        }

        public final Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UpdateServicePlanRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServicePlanRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("servicePlanId");
            }
            return "Cannot build UpdateServicePlanRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateServicePlanRequest", generator="Immutables")
    static final class Json
    extends _UpdateServicePlanRequest {
        Boolean publiclyVisible;
        String servicePlanId;

        Json() {
        }

        @JsonProperty(value="public")
        public void setPubliclyVisible(@Nullable Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
        }

        @JsonProperty(value="servicePlanId")
        @JsonIgnore
        public void setServicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
        }

        @Override
        public Boolean getPubliclyVisible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServicePlanId() {
            throw new UnsupportedOperationException();
        }
    }
}

