/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.serviceplanvisibilities._ListServicePlanVisibilitiesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServicePlanVisibilitiesRequest", generator="Immutables")
public final class ListServicePlanVisibilitiesRequest
extends _ListServicePlanVisibilitiesRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final List<String> organizationIds;
    @Nullable
    private final List<String> servicePlanIds;

    private ListServicePlanVisibilitiesRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.organizationIds = builder.organizationIds == null ? null : ListServicePlanVisibilitiesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.servicePlanIds = builder.servicePlanIds == null ? null : ListServicePlanVisibilitiesRequest.createUnmodifiableList(true, builder.servicePlanIds);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    @Nullable
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServicePlanVisibilitiesRequest && this.equalTo((ListServicePlanVisibilitiesRequest)another);
    }

    private boolean equalTo(ListServicePlanVisibilitiesRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.organizationIds, another.organizationIds) && Objects.equals(this.servicePlanIds, another.servicePlanIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + Objects.hashCode(this.servicePlanIds);
        return h;
    }

    public String toString() {
        return "ListServicePlanVisibilitiesRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", organizationIds=" + this.organizationIds + ", servicePlanIds=" + this.servicePlanIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServicePlanVisibilitiesRequest", generator="Immutables")
    public static final class Builder {
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> organizationIds = null;
        private List<String> servicePlanIds = null;

        private Builder() {
        }

        public final Builder from(ListServicePlanVisibilitiesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListServicePlanVisibilitiesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListServicePlanVisibilitiesRequest) {
                List<String> organizationIdsValue;
                instance = (_ListServicePlanVisibilitiesRequest)object;
                List<String> servicePlanIdsValue = ((_ListServicePlanVisibilitiesRequest)instance).getServicePlanIds();
                if (servicePlanIdsValue != null) {
                    this.addAllServicePlanIds(servicePlanIdsValue);
                }
                if ((organizationIdsValue = ((_ListServicePlanVisibilitiesRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder servicePlanId(String element) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList<String>();
            }
            this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            return this;
        }

        public final Builder servicePlanIds(String ... elements) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            }
            return this;
        }

        public final Builder servicePlanIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.servicePlanIds = null;
                return this;
            }
            this.servicePlanIds = new ArrayList<String>();
            return this.addAllServicePlanIds(elements);
        }

        public final Builder addAllServicePlanIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "servicePlanIds element");
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
            }
            return this;
        }

        public ListServicePlanVisibilitiesRequest build() {
            return new ListServicePlanVisibilitiesRequest(this);
        }
    }
}

