/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.routes.Destination;
import org.cloudfoundry.client.v3.routes._ReplaceRouteDestinationsRequest;
import org.immutables.value.Generated;

@Generated(from="_ReplaceRouteDestinationsRequest", generator="Immutables")
public final class ReplaceRouteDestinationsRequest
extends _ReplaceRouteDestinationsRequest {
    private final List<Destination> destinations;
    private final String routeId;

    private ReplaceRouteDestinationsRequest(Builder builder) {
        this.destinations = ReplaceRouteDestinationsRequest.createUnmodifiableList(true, builder.destinations);
        this.routeId = builder.routeId;
    }

    @Override
    @JsonProperty(value="destinations")
    public List<Destination> getDestinations() {
        return this.destinations;
    }

    @Override
    @JsonProperty(value="routeId")
    @JsonIgnore
    public String getRouteId() {
        return this.routeId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReplaceRouteDestinationsRequest && this.equalTo((ReplaceRouteDestinationsRequest)another);
    }

    private boolean equalTo(ReplaceRouteDestinationsRequest another) {
        return this.destinations.equals(another.destinations) && this.routeId.equals(another.routeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destinations.hashCode();
        h += (h << 5) + this.routeId.hashCode();
        return h;
    }

    public String toString() {
        return "ReplaceRouteDestinationsRequest{destinations=" + this.destinations + ", routeId=" + this.routeId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ReplaceRouteDestinationsRequest fromJson(Json json) {
        Builder builder = ReplaceRouteDestinationsRequest.builder();
        if (json.destinations != null) {
            builder.addAllDestinations(json.destinations);
        }
        if (json.routeId != null) {
            builder.routeId(json.routeId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ReplaceRouteDestinationsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private long initBits = 1L;
        private List<Destination> destinations = new ArrayList<Destination>();
        private String routeId;

        private Builder() {
        }

        public final Builder from(ReplaceRouteDestinationsRequest instance) {
            return this.from((_ReplaceRouteDestinationsRequest)instance);
        }

        final Builder from(_ReplaceRouteDestinationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllDestinations(instance.getDestinations());
            this.routeId(instance.getRouteId());
            return this;
        }

        public final Builder destination(Destination element) {
            this.destinations.add(Objects.requireNonNull(element, "destinations element"));
            return this;
        }

        public final Builder destinations(Destination ... elements) {
            for (Destination element : elements) {
                this.destinations.add(Objects.requireNonNull(element, "destinations element"));
            }
            return this;
        }

        public final Builder destinations(Iterable<? extends Destination> elements) {
            this.destinations.clear();
            return this.addAllDestinations(elements);
        }

        public final Builder addAllDestinations(Iterable<? extends Destination> elements) {
            for (Destination destination : elements) {
                this.destinations.add(Objects.requireNonNull(destination, "destinations element"));
            }
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ReplaceRouteDestinationsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReplaceRouteDestinationsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build ReplaceRouteDestinationsRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ReplaceRouteDestinationsRequest", generator="Immutables")
    static final class Json
    extends _ReplaceRouteDestinationsRequest {
        List<Destination> destinations = Collections.emptyList();
        String routeId;

        Json() {
        }

        @JsonProperty(value="destinations")
        public void setDestinations(List<Destination> destinations) {
            this.destinations = destinations;
        }

        @JsonProperty(value="routeId")
        @JsonIgnore
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public List<Destination> getDestinations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteId() {
            throw new UnsupportedOperationException();
        }
    }
}

