/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.servicebrokers.Authentication;
import org.cloudfoundry.client.v3.servicebrokers.ServiceBrokerRelationships;
import org.cloudfoundry.client.v3.servicebrokers._CreateServiceBrokerRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateServiceBrokerRequest", generator="Immutables")
public final class CreateServiceBrokerRequest
extends _CreateServiceBrokerRequest {
    private final Authentication authentication;
    private final String name;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final ServiceBrokerRelationships relationships;
    private final String url;

    private CreateServiceBrokerRequest(Builder builder) {
        this.authentication = builder.authentication;
        this.name = builder.name;
        this.metadata = builder.metadata;
        this.relationships = builder.relationships;
        this.url = builder.url;
    }

    @Override
    @JsonProperty(value="authentication")
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public ServiceBrokerRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceBrokerRequest && this.equalTo((CreateServiceBrokerRequest)another);
    }

    private boolean equalTo(CreateServiceBrokerRequest another) {
        return this.authentication.equals(another.authentication) && this.name.equals(another.name) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.relationships, another.relationships) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authentication.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "CreateServiceBrokerRequest{authentication=" + this.authentication + ", name=" + this.name + ", metadata=" + this.metadata + ", relationships=" + this.relationships + ", url=" + this.url + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateServiceBrokerRequest fromJson(Json json) {
        Builder builder = CreateServiceBrokerRequest.builder();
        if (json.authentication != null) {
            builder.authentication(json.authentication);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateServiceBrokerRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_AUTHENTICATION = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_URL = 4L;
        private long initBits = 7L;
        private Authentication authentication;
        private String name;
        private Metadata metadata;
        private ServiceBrokerRelationships relationships;
        private String url;

        private Builder() {
        }

        public final Builder from(CreateServiceBrokerRequest instance) {
            return this.from((_CreateServiceBrokerRequest)instance);
        }

        final Builder from(_CreateServiceBrokerRequest instance) {
            ServiceBrokerRelationships relationshipsValue;
            Objects.requireNonNull(instance, "instance");
            this.authentication(instance.getAuthentication());
            this.name(instance.getName());
            Metadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                this.metadata(metadataValue);
            }
            if ((relationshipsValue = instance.getRelationships()) != null) {
                this.relationships(relationshipsValue);
            }
            this.url(instance.getUrl());
            return this;
        }

        public final Builder authentication(Authentication authentication) {
            this.authentication = Objects.requireNonNull(authentication, "authentication");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder relationships(@Nullable ServiceBrokerRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CreateServiceBrokerRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServiceBrokerRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authentication");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build CreateServiceBrokerRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateServiceBrokerRequest", generator="Immutables")
    static final class Json
    extends _CreateServiceBrokerRequest {
        Authentication authentication;
        String name;
        Metadata metadata;
        ServiceBrokerRelationships relationships;
        String url;

        Json() {
        }

        @JsonProperty(value="authentication")
        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable ServiceBrokerRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Authentication getAuthentication() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceBrokerRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

