/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Visibility {
    ADMIN("admin"),
    ORGANIZATION("organization"),
    PUBLIC("public"),
    SPACE("space");

    private final String value;

    private Visibility(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Visibility from(String s) {
        switch (s.toLowerCase()) {
            case "admin": {
                return ADMIN;
            }
            case "organization": {
                return ORGANIZATION;
            }
            case "public": {
                return PUBLIC;
            }
            case "space": {
                return SPACE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown visibility: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

