/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum LogType {
    ERR("ERR"),
    OUT("OUT");

    private final String value;

    private LogType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static LogType from(String s) {
        switch (s.toLowerCase()) {
            case "err": {
                return ERR;
            }
            case "out": {
                return OUT;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown log type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

