/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum LdapProfileFile {
    SEARCH_AND_BIND("ldap/ldap-search-and-bind.xml"),
    SEARCH_AND_COMPARE("ldap/ldap-search-and-compare.xml"),
    SIMPLE_BIND("ldap/ldap-simple-bind.xml");

    private final String value;

    private LdapProfileFile(String value) {
        this.value = value;
    }

    @JsonCreator
    public static LdapProfileFile from(String s) {
        switch (s.toLowerCase()) {
            case "ldap/ldap-search-and-bind.xml": {
                return SEARCH_AND_BIND;
            }
            case "ldap/ldap-search-and-compare.xml": {
                return SEARCH_AND_COMPARE;
            }
            case "ldap/ldap-simple-bind.xml": {
                return SIMPLE_BIND;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown ldap profile file: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

