package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * An application manifest that captures some of the details of how an application is deployed.  See <a href="https://docs.cloudfoundry.org/devguide/deploy-apps/manifest.html">the manifest
 * definition</a> for more details.
 */
@Generated(from = "_ManifestV3", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ManifestV3 extends org.cloudfoundry.operations.applications._ManifestV3 {
  private final List<ManifestV3Application> applications;
  private final Integer version;

  private ManifestV3(ManifestV3.Builder builder) {
    this.applications = createUnmodifiableList(true, builder.applications);
    this.version = builder.version != null
        ? builder.version
        : Objects.requireNonNull(super.getVersion(), "version");
  }

  /**
   * @return The value of the {@code applications} attribute
   */
  @Override
  public List<ManifestV3Application> getApplications() {
    return applications;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code ManifestV3} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ManifestV3
        && equalTo((ManifestV3) another);
  }

  private boolean equalTo(ManifestV3 another) {
    return applications.equals(another.applications)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code applications}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applications.hashCode();
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ManifestV3} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ManifestV3{"
        + "applications=" + applications
        + ", version=" + version
        + "}";
  }

  private static ManifestV3 validate(ManifestV3 instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ManifestV3 ManifestV3}.
   * <pre>
   * ManifestV3.builder()
   *    .application|addAllApplications(ManifestV3Application) // {@link ManifestV3#getApplications() applications} elements
   *    .version(Integer) // optional {@link ManifestV3#getVersion() version}
   *    .build();
   * </pre>
   * @return A new ManifestV3 builder
   */
  public static ManifestV3.Builder builder() {
    return new ManifestV3.Builder();
  }

  /**
   * Builds instances of type {@link ManifestV3 ManifestV3}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ManifestV3", generator = "Immutables")
  public static final class Builder {
    private List<ManifestV3Application> applications = new ArrayList<ManifestV3Application>();
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ManifestV3} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ManifestV3 instance) {
      return from((_ManifestV3) instance);
    }

    /**
     * Copy abstract value type {@code _ManifestV3} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ManifestV3 instance) {
      Objects.requireNonNull(instance, "instance");
      addAllApplications(instance.getApplications());
      version(instance.getVersion());
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3#getApplications() applications} list.
     * @param element A applications element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(ManifestV3Application element) {
      this.applications.add(Objects.requireNonNull(element, "applications element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3#getApplications() applications} list.
     * @param elements An array of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(ManifestV3Application... elements) {
      for (ManifestV3Application element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(Iterable<? extends ManifestV3Application> elements) {
      this.applications.clear();
      return addAllApplications(elements);
    }

    /**
     * Adds elements to {@link ManifestV3#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplications(Iterable<? extends ManifestV3Application> elements) {
      for (ManifestV3Application element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3#getVersion() version} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ManifestV3#getVersion() version}.</em>
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Builds a new {@link ManifestV3 ManifestV3}.
     * @return An immutable instance of ManifestV3
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ManifestV3 build() {
      return ManifestV3.validate(new ManifestV3(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
