package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * An application manifest that captures some of the details of how an application is deployed.  See <a href="https://docs.cloudfoundry.org/devguide/deploy-apps/manifest.html">the manifest
 * definition</a> for more details.
 */
@Generated(from = "_ManifestV3Application", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ManifestV3Application
    extends org.cloudfoundry.operations.applications._ManifestV3Application {
  private final @Nullable List<String> buildpacks;
  private final @Nullable String command;
  private final @Nullable Integer disk;
  private final @Nullable Docker docker;
  private final @Nullable List<String> domains;
  private final @Nullable Map<String, Object> environmentVariables;
  private final @Nullable String healthCheckHttpEndpoint;
  private final @Nullable ApplicationHealthCheck healthCheckType;
  private final @Nullable List<String> hosts;
  private final @Nullable Integer instances;
  private final @Nullable Integer memory;
  private final String name;
  private final @Nullable Boolean noHostname;
  private final @Nullable Boolean noRoute;
  private final @Nullable Path path;
  private final @Nullable Boolean randomRoute;
  private final @Nullable String routePath;
  private final @Nullable List<Route> routes;
  private final @Nullable String stack;
  private final @Nullable Integer timeout;
  private final @Nullable Map<String, String> annotations;
  private final @Nullable Boolean defaultRoute;
  private final @Nullable Map<String, String> labels;
  private final @Nullable List<ManifestV3Process> processes;
  private final @Nullable List<ManifestV3Service> services;
  private final @Nullable List<ManifestV3Sidecar> sidecars;

  private ManifestV3Application(ManifestV3Application.Builder builder) {
    this.buildpacks = builder.buildpacks == null ? null : createUnmodifiableList(true, builder.buildpacks);
    this.command = builder.command;
    this.disk = builder.disk;
    this.docker = builder.docker;
    this.domains = builder.domains == null ? null : createUnmodifiableList(true, builder.domains);
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
    this.healthCheckType = builder.healthCheckType;
    this.hosts = builder.hosts == null ? null : createUnmodifiableList(true, builder.hosts);
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.name = builder.name;
    this.noHostname = builder.noHostname;
    this.noRoute = builder.noRoute;
    this.path = builder.path;
    this.randomRoute = builder.randomRoute;
    this.routePath = builder.routePath;
    this.routes = builder.routes == null ? null : createUnmodifiableList(true, builder.routes);
    this.stack = builder.stack;
    this.timeout = builder.timeout;
    this.annotations = builder.annotations == null ? null : createUnmodifiableMap(false, false, builder.annotations);
    this.defaultRoute = builder.defaultRoute;
    this.labels = builder.labels == null ? null : createUnmodifiableMap(false, false, builder.labels);
    this.processes = builder.processes == null ? null : createUnmodifiableList(true, builder.processes);
    this.services = builder.services == null ? null : createUnmodifiableList(true, builder.services);
    this.sidecars = builder.sidecars == null ? null : createUnmodifiableList(true, builder.sidecars);
  }

  /**
   * The buildpacks used by the application
   */
  @Override
  public @Nullable List<String> getBuildpacks() {
    return buildpacks;
  }

  /**
   * The command used to execute the application
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The disk quota in megabytes
   */
  @Override
  public @Nullable Integer getDisk() {
    return disk;
  }

  /**
   * The docker information
   */
  @Override
  public @Nullable Docker getDocker() {
    return docker;
  }

  /**
   * The collection of domains bound to the application
   */
  @Override
  public @Nullable List<String> getDomains() {
    return domains;
  }

  /**
   * The environment variables to set on the application
   */
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The HTTP health check endpoint
   */
  @Override
  public @Nullable String getHealthCheckHttpEndpoint() {
    return healthCheckHttpEndpoint;
  }

  /**
   * The health check type
   */
  @Override
  public @Nullable ApplicationHealthCheck getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The collection of hosts bound to the application
   */
  @Override
  public @Nullable List<String> getHosts() {
    return hosts;
  }

  /**
   * The number of instances of the application
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory quota in megabytes
   */
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Map the the root domain to the app
   */
  @Override
  public @Nullable Boolean getNoHostname() {
    return noHostname;
  }

  /**
   * Prevent a route being created for the app
   */
  @Override
  public @Nullable Boolean getNoRoute() {
    return noRoute;
  }

  /**
   * The location of the application
   */
  @Override
  public @Nullable Path getPath() {
    return path;
  }

  /**
   * Generate a random route
   */
  @Override
  public @Nullable Boolean getRandomRoute() {
    return randomRoute;
  }

  /**
   * The route path for all applications
   */
  @Override
  public @Nullable String getRoutePath() {
    return routePath;
  }

  /**
   * The collection of routes bound to the application
   */
  @Override
  public @Nullable List<Route> getRoutes() {
    return routes;
  }

  /**
   * The stack used to run the application
   */
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * The number of seconds allowed for application start
   */
  @Override
  public @Nullable Integer getTimeout() {
    return timeout;
  }

  /**
   * The annotations configured for this application
   */
  @Override
  public @Nullable Map<String, String> getAnnotations() {
    return annotations;
  }

  /**
   * Generate a default route based on the application name
   */
  @Override
  public @Nullable Boolean getDefaultRoute() {
    return defaultRoute;
  }

  /**
   * The labels configured for this application
   */
  @Override
  public @Nullable Map<String, String> getLabels() {
    return labels;
  }

  /**
   * The collection of processes configured for this application
   */
  @Override
  public @Nullable List<ManifestV3Process> getProcesses() {
    return processes;
  }

  /**
   * The collection of services bound to the application
   */
  @Override
  public @Nullable List<ManifestV3Service> getServices() {
    return services;
  }

  /**
   * The collection of sidecars configured for this application
   */
  @Override
  public @Nullable List<ManifestV3Sidecar> getSidecars() {
    return sidecars;
  }

  /**
   * This instance is equal to all instances of {@code ManifestV3Application} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ManifestV3Application
        && equalTo((ManifestV3Application) another);
  }

  private boolean equalTo(ManifestV3Application another) {
    return Objects.equals(buildpacks, another.buildpacks)
        && Objects.equals(command, another.command)
        && Objects.equals(disk, another.disk)
        && Objects.equals(docker, another.docker)
        && Objects.equals(domains, another.domains)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(healthCheckHttpEndpoint, another.healthCheckHttpEndpoint)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(hosts, another.hosts)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && name.equals(another.name)
        && Objects.equals(noHostname, another.noHostname)
        && Objects.equals(noRoute, another.noRoute)
        && Objects.equals(path, another.path)
        && Objects.equals(randomRoute, another.randomRoute)
        && Objects.equals(routePath, another.routePath)
        && Objects.equals(routes, another.routes)
        && Objects.equals(stack, another.stack)
        && Objects.equals(timeout, another.timeout)
        && Objects.equals(annotations, another.annotations)
        && Objects.equals(defaultRoute, another.defaultRoute)
        && Objects.equals(labels, another.labels)
        && Objects.equals(processes, another.processes)
        && Objects.equals(services, another.services)
        && Objects.equals(sidecars, another.sidecars);
  }

  /**
   * Computes a hash code from attributes: {@code buildpacks}, {@code command}, {@code disk}, {@code docker}, {@code domains}, {@code environmentVariables}, {@code healthCheckHttpEndpoint}, {@code healthCheckType}, {@code hosts}, {@code instances}, {@code memory}, {@code name}, {@code noHostname}, {@code noRoute}, {@code path}, {@code randomRoute}, {@code routePath}, {@code routes}, {@code stack}, {@code timeout}, {@code annotations}, {@code defaultRoute}, {@code labels}, {@code processes}, {@code services}, {@code sidecars}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpacks);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(disk);
    h += (h << 5) + Objects.hashCode(docker);
    h += (h << 5) + Objects.hashCode(domains);
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(healthCheckHttpEndpoint);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(hosts);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(noHostname);
    h += (h << 5) + Objects.hashCode(noRoute);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(randomRoute);
    h += (h << 5) + Objects.hashCode(routePath);
    h += (h << 5) + Objects.hashCode(routes);
    h += (h << 5) + Objects.hashCode(stack);
    h += (h << 5) + Objects.hashCode(timeout);
    h += (h << 5) + Objects.hashCode(annotations);
    h += (h << 5) + Objects.hashCode(defaultRoute);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(processes);
    h += (h << 5) + Objects.hashCode(services);
    h += (h << 5) + Objects.hashCode(sidecars);
    return h;
  }

  /**
   * Prints the immutable value {@code ManifestV3Application} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ManifestV3Application{"
        + "buildpacks=" + buildpacks
        + ", command=" + command
        + ", disk=" + disk
        + ", docker=" + docker
        + ", domains=" + domains
        + ", environmentVariables=" + environmentVariables
        + ", healthCheckHttpEndpoint=" + healthCheckHttpEndpoint
        + ", healthCheckType=" + healthCheckType
        + ", hosts=" + hosts
        + ", instances=" + instances
        + ", memory=" + memory
        + ", name=" + name
        + ", noHostname=" + noHostname
        + ", noRoute=" + noRoute
        + ", path=" + path
        + ", randomRoute=" + randomRoute
        + ", routePath=" + routePath
        + ", routes=" + routes
        + ", stack=" + stack
        + ", timeout=" + timeout
        + ", annotations=" + annotations
        + ", defaultRoute=" + defaultRoute
        + ", labels=" + labels
        + ", processes=" + processes
        + ", services=" + services
        + ", sidecars=" + sidecars
        + "}";
  }

  private static ManifestV3Application validate(ManifestV3Application instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link ManifestV3Application ManifestV3Application}.
   * <pre>
   * ManifestV3Application.builder()
   *    .buildpacks(List&amp;lt;String&amp;gt; | null) // nullable {@link ManifestV3Application#getBuildpacks() buildpacks}
   *    .command(String | null) // nullable {@link ManifestV3Application#getCommand() command}
   *    .disk(Integer | null) // nullable {@link ManifestV3Application#getDisk() disk}
   *    .docker(org.cloudfoundry.operations.applications.Docker | null) // nullable {@link ManifestV3Application#getDocker() docker}
   *    .domains(List&amp;lt;String&amp;gt; | null) // nullable {@link ManifestV3Application#getDomains() domains}
   *    .environmentVariables(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link ManifestV3Application#getEnvironmentVariables() environmentVariables}
   *    .healthCheckHttpEndpoint(String | null) // nullable {@link ManifestV3Application#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint}
   *    .healthCheckType(org.cloudfoundry.operations.applications.ApplicationHealthCheck | null) // nullable {@link ManifestV3Application#getHealthCheckType() healthCheckType}
   *    .hosts(List&amp;lt;String&amp;gt; | null) // nullable {@link ManifestV3Application#getHosts() hosts}
   *    .instances(Integer | null) // nullable {@link ManifestV3Application#getInstances() instances}
   *    .memory(Integer | null) // nullable {@link ManifestV3Application#getMemory() memory}
   *    .name(String) // required {@link ManifestV3Application#getName() name}
   *    .noHostname(Boolean | null) // nullable {@link ManifestV3Application#getNoHostname() noHostname}
   *    .noRoute(Boolean | null) // nullable {@link ManifestV3Application#getNoRoute() noRoute}
   *    .path(java.nio.file.Path | null) // nullable {@link ManifestV3Application#getPath() path}
   *    .randomRoute(Boolean | null) // nullable {@link ManifestV3Application#getRandomRoute() randomRoute}
   *    .routePath(String | null) // nullable {@link ManifestV3Application#getRoutePath() routePath}
   *    .routes(List&amp;lt;Route&amp;gt; | null) // nullable {@link ManifestV3Application#getRoutes() routes}
   *    .stack(String | null) // nullable {@link ManifestV3Application#getStack() stack}
   *    .timeout(Integer | null) // nullable {@link ManifestV3Application#getTimeout() timeout}
   *    .annotations(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ManifestV3Application#getAnnotations() annotations}
   *    .defaultRoute(Boolean | null) // nullable {@link ManifestV3Application#getDefaultRoute() defaultRoute}
   *    .labels(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link ManifestV3Application#getLabels() labels}
   *    .processes(List&amp;lt;ManifestV3Process&amp;gt; | null) // nullable {@link ManifestV3Application#getProcesses() processes}
   *    .services(List&amp;lt;ManifestV3Service&amp;gt; | null) // nullable {@link ManifestV3Application#getServices() services}
   *    .sidecars(List&amp;lt;ManifestV3Sidecar&amp;gt; | null) // nullable {@link ManifestV3Application#getSidecars() sidecars}
   *    .build();
   * </pre>
   * @return A new ManifestV3Application builder
   */
  public static ManifestV3Application.Builder builder() {
    return new ManifestV3Application.Builder();
  }

  /**
   * Builds instances of type {@link ManifestV3Application ManifestV3Application}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ManifestV3Application", generator = "Immutables")
  public static final class Builder extends _ManifestV3Application.Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private List<String> buildpacks = null;
    private String command;
    private Integer disk;
    private Docker docker;
    private List<String> domains = null;
    private Map<String, Object> environmentVariables = null;
    private String healthCheckHttpEndpoint;
    private ApplicationHealthCheck healthCheckType;
    private List<String> hosts = null;
    private Integer instances;
    private Integer memory;
    private String name;
    private Boolean noHostname;
    private Boolean noRoute;
    private Path path;
    private Boolean randomRoute;
    private String routePath;
    private List<Route> routes = null;
    private String stack;
    private Integer timeout;
    private Map<String, String> annotations = null;
    private Boolean defaultRoute;
    private Map<String, String> labels = null;
    private List<ManifestV3Process> processes = null;
    private List<ManifestV3Service> services = null;
    private List<ManifestV3Sidecar> sidecars = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.operations.applications._ApplicationManifestCommon} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(org.cloudfoundry.operations.applications._ApplicationManifestCommon instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ManifestV3Application} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ManifestV3Application instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ManifestV3Application} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ManifestV3Application instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.operations.applications._ApplicationManifestCommon) {
        org.cloudfoundry.operations.applications._ApplicationManifestCommon instance = (org.cloudfoundry.operations.applications._ApplicationManifestCommon) object;
        ApplicationHealthCheck healthCheckTypeValue = instance.getHealthCheckType();
        if (healthCheckTypeValue != null) {
          healthCheckType(healthCheckTypeValue);
        }
        String stackValue = instance.getStack();
        if (stackValue != null) {
          stack(stackValue);
        }
        Boolean noHostnameValue = instance.getNoHostname();
        if (noHostnameValue != null) {
          noHostname(noHostnameValue);
        }
        Integer memoryValue = instance.getMemory();
        if (memoryValue != null) {
          memory(memoryValue);
        }
        Integer instancesValue = instance.getInstances();
        if (instancesValue != null) {
          instances(instancesValue);
        }
        List<String> hostsValue = instance.getHosts();
        if (hostsValue != null) {
          addAllHosts(hostsValue);
        }
        Boolean noRouteValue = instance.getNoRoute();
        if (noRouteValue != null) {
          noRoute(noRouteValue);
        }
        List<String> domainsValue = instance.getDomains();
        if (domainsValue != null) {
          addAllDomains(domainsValue);
        }
        Integer timeoutValue = instance.getTimeout();
        if (timeoutValue != null) {
          timeout(timeoutValue);
        }
        String commandValue = instance.getCommand();
        if (commandValue != null) {
          command(commandValue);
        }
        Docker dockerValue = instance.getDocker();
        if (dockerValue != null) {
          docker(dockerValue);
        }
        List<String> buildpacksValue = instance.getBuildpacks();
        if (buildpacksValue != null) {
          addAllBuildpacks(buildpacksValue);
        }
        Path pathValue = instance.getPath();
        if (pathValue != null) {
          path(pathValue);
        }
        List<Route> routesValue = instance.getRoutes();
        if (routesValue != null) {
          addAllRoutes(routesValue);
        }
        Boolean randomRouteValue = instance.getRandomRoute();
        if (randomRouteValue != null) {
          randomRoute(randomRouteValue);
        }
        Integer diskValue = instance.getDisk();
        if (diskValue != null) {
          disk(diskValue);
        }
        String routePathValue = instance.getRoutePath();
        if (routePathValue != null) {
          routePath(routePathValue);
        }
        Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
        if (environmentVariablesValue != null) {
          putAllEnvironmentVariables(environmentVariablesValue);
        }
        String healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint();
        if (healthCheckHttpEndpointValue != null) {
          healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
        }
        name(instance.getName());
      }
      if (object instanceof org.cloudfoundry.operations.applications._ManifestV3Application) {
        org.cloudfoundry.operations.applications._ManifestV3Application instance = (org.cloudfoundry.operations.applications._ManifestV3Application) object;
        List<ManifestV3Sidecar> sidecarsValue = instance.getSidecars();
        if (sidecarsValue != null) {
          addAllSidecars(sidecarsValue);
        }
        Map<String, String> annotationsValue = instance.getAnnotations();
        if (annotationsValue != null) {
          putAllAnnotations(annotationsValue);
        }
        List<ManifestV3Process> processesValue = instance.getProcesses();
        if (processesValue != null) {
          addAllProcesses(processesValue);
        }
        List<ManifestV3Service> servicesValue = instance.getServices();
        if (servicesValue != null) {
          addAllServices(servicesValue);
        }
        Boolean defaultRouteValue = instance.getDefaultRoute();
        if (defaultRouteValue != null) {
          defaultRoute(defaultRouteValue);
        }
        Map<String, String> labelsValue = instance.getLabels();
        if (labelsValue != null) {
          putAllLabels(labelsValue);
        }
      }
    }

    /**
     * Adds one element to {@link ManifestV3Application#getBuildpacks() buildpacks} list.
     * @param element A buildpacks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(String element) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getBuildpacks() buildpacks} list.
     * @param elements An array of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpacks(String... elements) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpacks(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.buildpacks = null;
        return this;
      }
      this.buildpacks = new ArrayList<String>();
      return addAllBuildpacks(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBuildpacks(Iterable<String> elements) {
      Objects.requireNonNull(elements, "buildpacks element");
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getDisk() disk} attribute.
     * @param disk The value for disk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disk(@Nullable Integer disk) {
      this.disk = disk;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getDocker() docker} attribute.
     * @param docker The value for docker (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder docker(@Nullable Docker docker) {
      this.docker = docker;
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Application#getDomains() domains} list.
     * @param element A domains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String element) {
      if (this.domains == null) {
        this.domains = new ArrayList<String>();
      }
      this.domains.add(Objects.requireNonNull(element, "domains element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getDomains() domains} list.
     * @param elements An array of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(String... elements) {
      if (this.domains == null) {
        this.domains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domains = null;
        return this;
      }
      this.domains = new ArrayList<String>();
      return addAllDomains(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domains element");
      if (this.domains == null) {
        this.domains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link ManifestV3Application#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ManifestV3Application#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ManifestV3Application#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ManifestV3Application#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint} attribute.
     * @param healthCheckHttpEndpoint The value for healthCheckHttpEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckType(@Nullable ApplicationHealthCheck healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Application#getHosts() hosts} list.
     * @param element A hosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getHosts() hosts} list.
     * @param elements An array of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(String... elements) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.hosts = null;
        return this;
      }
      this.hosts = new ArrayList<String>();
      return addAllHosts(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHosts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "hosts element");
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getNoHostname() noHostname} attribute.
     * @param noHostname The value for noHostname (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noHostname(@Nullable Boolean noHostname) {
      this.noHostname = noHostname;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getNoRoute() noRoute} attribute.
     * @param noRoute The value for noRoute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noRoute(@Nullable Boolean noRoute) {
      this.noRoute = noRoute;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable Path path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getRandomRoute() randomRoute} attribute.
     * @param randomRoute The value for randomRoute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder randomRoute(@Nullable Boolean randomRoute) {
      this.randomRoute = randomRoute;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getRoutePath() routePath} attribute.
     * @param routePath The value for routePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routePath(@Nullable String routePath) {
      this.routePath = routePath;
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Application#getRoutes() routes} list.
     * @param element A routes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder route(Route element) {
      if (this.routes == null) {
        this.routes = new ArrayList<Route>();
      }
      this.routes.add(Objects.requireNonNull(element, "routes element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getRoutes() routes} list.
     * @param elements An array of routes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routes(Route... elements) {
      if (this.routes == null) {
        this.routes = new ArrayList<Route>();
      }
      for (Route element : elements) {
        this.routes.add(Objects.requireNonNull(element, "routes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getRoutes() routes} list.
     * @param elements An iterable of routes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routes(@Nullable Iterable<? extends Route> elements) {
      if (elements == null) {
        this.routes = null;
        return this;
      }
      this.routes = new ArrayList<Route>();
      return addAllRoutes(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getRoutes() routes} list.
     * @param elements An iterable of routes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRoutes(Iterable<? extends Route> elements) {
      Objects.requireNonNull(elements, "routes element");
      if (this.routes == null) {
        this.routes = new ArrayList<Route>();
      }
      for (Route element : elements) {
        this.routes.add(Objects.requireNonNull(element, "routes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getTimeout() timeout} attribute.
     * @param timeout The value for timeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(@Nullable Integer timeout) {
      this.timeout = timeout;
      return this;
    }

    /**
     * Put one entry to the {@link ManifestV3Application#getAnnotations() annotations} map.
     * @param key The key in the annotations map
     * @param value The associated value in the annotations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder annotation(String key, String value) {
      if (this.annotations == null) {
        this.annotations = new LinkedHashMap<String, String>();
      }
      this.annotations.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ManifestV3Application#getAnnotations() annotations} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder annotation(Map.Entry<String, ? extends String> entry) {
      if (this.annotations == null) {
        this.annotations = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.annotations.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ManifestV3Application#getAnnotations() annotations} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the annotations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder annotations(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.annotations = null;
        return this;
      }
      this.annotations = new LinkedHashMap<String, String>();
      return putAllAnnotations(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ManifestV3Application#getAnnotations() annotations} map. Nulls are not permitted
     * @param entries The entries that will be added to the annotations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAnnotations(Map<String, ? extends String> entries) {
      if (this.annotations == null) {
        this.annotations = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.annotations.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Application#getDefaultRoute() defaultRoute} attribute.
     * @param defaultRoute The value for defaultRoute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultRoute(@Nullable Boolean defaultRoute) {
      this.defaultRoute = defaultRoute;
      return this;
    }

    /**
     * Put one entry to the {@link ManifestV3Application#getLabels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String key, String value) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      this.labels.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ManifestV3Application#getLabels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(Map.Entry<String, ? extends String> entry) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ManifestV3Application#getLabels() labels} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labels(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.labels = null;
        return this;
      }
      this.labels = new LinkedHashMap<String, String>();
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ManifestV3Application#getLabels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabels(Map<String, ? extends String> entries) {
      if (this.labels == null) {
        this.labels = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(k, v);
      }
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Application#getProcesses() processes} list.
     * @param element A processes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processe(ManifestV3Process element) {
      if (this.processes == null) {
        this.processes = new ArrayList<ManifestV3Process>();
      }
      this.processes.add(Objects.requireNonNull(element, "processes element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getProcesses() processes} list.
     * @param elements An array of processes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processes(ManifestV3Process... elements) {
      if (this.processes == null) {
        this.processes = new ArrayList<ManifestV3Process>();
      }
      for (ManifestV3Process element : elements) {
        this.processes.add(Objects.requireNonNull(element, "processes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getProcesses() processes} list.
     * @param elements An iterable of processes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processes(@Nullable Iterable<? extends ManifestV3Process> elements) {
      if (elements == null) {
        this.processes = null;
        return this;
      }
      this.processes = new ArrayList<ManifestV3Process>();
      return addAllProcesses(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getProcesses() processes} list.
     * @param elements An iterable of processes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcesses(Iterable<? extends ManifestV3Process> elements) {
      Objects.requireNonNull(elements, "processes element");
      if (this.processes == null) {
        this.processes = new ArrayList<ManifestV3Process>();
      }
      for (ManifestV3Process element : elements) {
        this.processes.add(Objects.requireNonNull(element, "processes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Application#getServices() services} list.
     * @param element A services element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(ManifestV3Service element) {
      if (this.services == null) {
        this.services = new ArrayList<ManifestV3Service>();
      }
      this.services.add(Objects.requireNonNull(element, "services element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getServices() services} list.
     * @param elements An array of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder services(ManifestV3Service... elements) {
      if (this.services == null) {
        this.services = new ArrayList<ManifestV3Service>();
      }
      for (ManifestV3Service element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder services(@Nullable Iterable<? extends ManifestV3Service> elements) {
      if (elements == null) {
        this.services = null;
        return this;
      }
      this.services = new ArrayList<ManifestV3Service>();
      return addAllServices(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServices(Iterable<? extends ManifestV3Service> elements) {
      Objects.requireNonNull(elements, "services element");
      if (this.services == null) {
        this.services = new ArrayList<ManifestV3Service>();
      }
      for (ManifestV3Service element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Application#getSidecars() sidecars} list.
     * @param element A sidecars element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sidecar(ManifestV3Sidecar element) {
      if (this.sidecars == null) {
        this.sidecars = new ArrayList<ManifestV3Sidecar>();
      }
      this.sidecars.add(Objects.requireNonNull(element, "sidecars element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Application#getSidecars() sidecars} list.
     * @param elements An array of sidecars elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sidecars(ManifestV3Sidecar... elements) {
      if (this.sidecars == null) {
        this.sidecars = new ArrayList<ManifestV3Sidecar>();
      }
      for (ManifestV3Sidecar element : elements) {
        this.sidecars.add(Objects.requireNonNull(element, "sidecars element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Application#getSidecars() sidecars} list.
     * @param elements An iterable of sidecars elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sidecars(@Nullable Iterable<? extends ManifestV3Sidecar> elements) {
      if (elements == null) {
        this.sidecars = null;
        return this;
      }
      this.sidecars = new ArrayList<ManifestV3Sidecar>();
      return addAllSidecars(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Application#getSidecars() sidecars} list.
     * @param elements An iterable of sidecars elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSidecars(Iterable<? extends ManifestV3Sidecar> elements) {
      Objects.requireNonNull(elements, "sidecars element");
      if (this.sidecars == null) {
        this.sidecars = new ArrayList<ManifestV3Sidecar>();
      }
      for (ManifestV3Sidecar element : elements) {
        this.sidecars.add(Objects.requireNonNull(element, "sidecars element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ManifestV3Application ManifestV3Application}.
     * @return An immutable instance of ManifestV3Application
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ManifestV3Application build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ManifestV3Application.validate(new ManifestV3Application(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ManifestV3Application, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
