package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ManifestV3Service}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ManifestV3Service.builder()}.
 */
@Generated(from = "_ManifestV3Service", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ManifestV3Service extends org.cloudfoundry.operations.applications._ManifestV3Service {
  private final @Nullable String bindingName;
  private final String name;
  private final @Nullable Object parameters;

  private ManifestV3Service(ManifestV3Service.Builder builder) {
    this.bindingName = builder.bindingName;
    this.name = builder.name;
    this.parameters = builder.parameters;
  }

  /**
   * @return The value of the {@code bindingName} attribute
   */
  @Override
  public @Nullable String getBindingName() {
    return bindingName;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public @Nullable Object getParameters() {
    return parameters;
  }

  /**
   * This instance is equal to all instances of {@code ManifestV3Service} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ManifestV3Service
        && equalTo((ManifestV3Service) another);
  }

  private boolean equalTo(ManifestV3Service another) {
    return Objects.equals(bindingName, another.bindingName)
        && name.equals(another.name)
        && Objects.equals(parameters, another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code bindingName}, {@code name}, {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(bindingName);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(parameters);
    return h;
  }

  /**
   * Prints the immutable value {@code ManifestV3Service} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ManifestV3Service{"
        + "bindingName=" + bindingName
        + ", name=" + name
        + ", parameters=" + parameters
        + "}";
  }

  /**
   * Creates a builder for {@link ManifestV3Service ManifestV3Service}.
   * <pre>
   * ManifestV3Service.builder()
   *    .bindingName(String | null) // nullable {@link ManifestV3Service#getBindingName() bindingName}
   *    .name(String) // required {@link ManifestV3Service#getName() name}
   *    .parameters(Object | null) // nullable {@link ManifestV3Service#getParameters() parameters}
   *    .build();
   * </pre>
   * @return A new ManifestV3Service builder
   */
  public static ManifestV3Service.Builder builder() {
    return new ManifestV3Service.Builder();
  }

  /**
   * Builds instances of type {@link ManifestV3Service ManifestV3Service}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ManifestV3Service", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String bindingName;
    private String name;
    private Object parameters;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ManifestV3Service} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ManifestV3Service instance) {
      return from((_ManifestV3Service) instance);
    }

    /**
     * Copy abstract value type {@code _ManifestV3Service} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ManifestV3Service instance) {
      Objects.requireNonNull(instance, "instance");
      String bindingNameValue = instance.getBindingName();
      if (bindingNameValue != null) {
        bindingName(bindingNameValue);
      }
      name(instance.getName());
      Object parametersValue = instance.getParameters();
      if (parametersValue != null) {
        parameters(parametersValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Service#getBindingName() bindingName} attribute.
     * @param bindingName The value for bindingName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindingName(@Nullable String bindingName) {
      this.bindingName = bindingName;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Service#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Service#getParameters() parameters} attribute.
     * @param parameters The value for parameters (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Object parameters) {
      this.parameters = parameters;
      return this;
    }

    /**
     * Builds a new {@link ManifestV3Service ManifestV3Service}.
     * @return An immutable instance of ManifestV3Service
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ManifestV3Service build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ManifestV3Service(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ManifestV3Service, some of required attributes are not set " + attributes;
    }
  }
}
