package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ManifestV3Sidecar}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ManifestV3Sidecar.builder()}.
 */
@Generated(from = "_ManifestV3Sidecar", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ManifestV3Sidecar extends org.cloudfoundry.operations.applications._ManifestV3Sidecar {
  private final @Nullable String command;
  private final @Nullable Integer memory;
  private final String name;
  private final @Nullable List<String> processTypes;

  private ManifestV3Sidecar(ManifestV3Sidecar.Builder builder) {
    this.command = builder.command;
    this.memory = builder.memory;
    this.name = builder.name;
    this.processTypes = builder.processTypes == null ? null : createUnmodifiableList(true, builder.processTypes);
  }

  /**
   * The command to launch this sidecar
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * Memory in MB that the sidecar will be allocated
   */
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The route URI
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * List of processes to associate sidecar with
   */
  @Override
  public @Nullable List<String> getProcessTypes() {
    return processTypes;
  }

  /**
   * This instance is equal to all instances of {@code ManifestV3Sidecar} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ManifestV3Sidecar
        && equalTo((ManifestV3Sidecar) another);
  }

  private boolean equalTo(ManifestV3Sidecar another) {
    return Objects.equals(command, another.command)
        && Objects.equals(memory, another.memory)
        && name.equals(another.name)
        && Objects.equals(processTypes, another.processTypes);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code memory}, {@code name}, {@code processTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(processTypes);
    return h;
  }

  /**
   * Prints the immutable value {@code ManifestV3Sidecar} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ManifestV3Sidecar{"
        + "command=" + command
        + ", memory=" + memory
        + ", name=" + name
        + ", processTypes=" + processTypes
        + "}";
  }

  /**
   * Creates a builder for {@link ManifestV3Sidecar ManifestV3Sidecar}.
   * <pre>
   * ManifestV3Sidecar.builder()
   *    .command(String | null) // nullable {@link ManifestV3Sidecar#getCommand() command}
   *    .memory(Integer | null) // nullable {@link ManifestV3Sidecar#getMemory() memory}
   *    .name(String) // required {@link ManifestV3Sidecar#getName() name}
   *    .processTypes(List&amp;lt;String&amp;gt; | null) // nullable {@link ManifestV3Sidecar#getProcessTypes() processTypes}
   *    .build();
   * </pre>
   * @return A new ManifestV3Sidecar builder
   */
  public static ManifestV3Sidecar.Builder builder() {
    return new ManifestV3Sidecar.Builder();
  }

  /**
   * Builds instances of type {@link ManifestV3Sidecar ManifestV3Sidecar}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ManifestV3Sidecar", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String command;
    private Integer memory;
    private String name;
    private List<String> processTypes = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ManifestV3Sidecar} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ManifestV3Sidecar instance) {
      return from((_ManifestV3Sidecar) instance);
    }

    /**
     * Copy abstract value type {@code _ManifestV3Sidecar} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ManifestV3Sidecar instance) {
      Objects.requireNonNull(instance, "instance");
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      Integer memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      name(instance.getName());
      List<String> processTypesValue = instance.getProcessTypes();
      if (processTypesValue != null) {
        addAllProcessTypes(processTypesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Sidecar#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Sidecar#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Sidecar#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ManifestV3Sidecar#getProcessTypes() processTypes} list.
     * @param element A processTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processType(String element) {
      if (this.processTypes == null) {
        this.processTypes = new ArrayList<String>();
      }
      this.processTypes.add(Objects.requireNonNull(element, "processTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link ManifestV3Sidecar#getProcessTypes() processTypes} list.
     * @param elements An array of processTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processTypes(String... elements) {
      if (this.processTypes == null) {
        this.processTypes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.processTypes.add(Objects.requireNonNull(element, "processTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ManifestV3Sidecar#getProcessTypes() processTypes} list.
     * @param elements An iterable of processTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processTypes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.processTypes = null;
        return this;
      }
      this.processTypes = new ArrayList<String>();
      return addAllProcessTypes(elements);
    }

    /**
     * Adds elements to {@link ManifestV3Sidecar#getProcessTypes() processTypes} list.
     * @param elements An iterable of processTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcessTypes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "processTypes element");
      if (this.processTypes == null) {
        this.processTypes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.processTypes.add(Objects.requireNonNull(element, "processTypes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ManifestV3Sidecar ManifestV3Sidecar}.
     * @return An immutable instance of ManifestV3Sidecar
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ManifestV3Sidecar build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ManifestV3Sidecar(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ManifestV3Sidecar, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
