/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONTS = GVTAttributedCharacterIterator.TextAttribute.GVT_FONTS;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    public static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    public static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final Integer ADJUST_SPACING = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
    public static final Integer ADJUST_ALL = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
    public static final GVTAttributedCharacterIterator.TextAttribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    @Override
    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    protected void printAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        int n = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n2 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n2 - n) + ", ");
            attributedCharacterIterator.setIndex(n2);
            n = n2;
        }
        System.out.println("");
    }

    public List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        List list = textNode.getTextRuns();
        if (list != null) {
            return list;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        list = this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray);
        textNode.setTextRuns(list);
        return textNode.getTextRuns();
    }

    public List computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        Object object;
        int[][] nArrayArray = new int[attributedCharacterIteratorArray.length][];
        int n = attributedCharacterIterator.getBeginIndex();
        for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
            object = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[i], this.fontRenderContext, n);
            attributedCharacterIteratorArray[i] = object;
            nArrayArray[i] = ((BidiAttributedCharacterIterator)object).getCharMap();
            attributedCharacterIteratorArray[i] = StrokingTextPainter.createModifiedACIForFontMatching(attributedCharacterIteratorArray[i]);
            n += attributedCharacterIteratorArray[i].getEndIndex() - attributedCharacterIteratorArray[i].getBeginIndex();
        }
        ArrayList arrayList = new ArrayList();
        Object object2 = null;
        int n2 = 0;
        Point2D point2D = textNode.getLocation();
        do {
            attributedCharacterIteratorArray[n2].first();
            object = this.getTextChunk(textNode, attributedCharacterIteratorArray[n2], nArrayArray[n2], arrayList, (TextChunk)object2);
            attributedCharacterIteratorArray[n2].first();
            if (object != null) {
                point2D = this.adjustChunkOffsets(point2D, arrayList, (TextChunk)object);
            }
            object2 = object;
        } while (object != null && ++n2 < attributedCharacterIteratorArray.length);
        return arrayList;
    }

    protected AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Object object;
        boolean bl;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        int n2 = attributedCharacterIterator.getBeginIndex();
        attributedCharacterIterator.first();
        Object object2 = attributedCharacterIterator.getAttribute(WRITING_MODE);
        boolean bl2 = bl = object2 == WRITING_MODE_TTB;
        while (attributedCharacterIterator.setIndex(n2) != '\uffff') {
            object = null;
            int n3 = n2;
            n = 0;
            while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
                Float f;
                Serializable serializable;
                TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
                if (n3 != n2) {
                    if (!bl ? (serializable = (Float)attributedCharacterIterator.getAttribute(XPOS)) != null && !serializable.isNaN() : (serializable = (Float)attributedCharacterIterator.getAttribute(YPOS)) != null && !serializable.isNaN()) break;
                    if (object == null && textPath != null || object != null && textPath == null) break;
                }
                object = textPath;
                if (attributedCharacterIterator.getAttribute(FLOW_PARAGRAPH) != null) {
                    n = attributedCharacterIterator.getRunLimit(FLOW_PARAGRAPH);
                    attributedCharacterIterator.setIndex(n);
                    break;
                }
                n = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
                if (n3 == n2 && (serializable = (TextNode.Anchor)attributedCharacterIterator.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START && !(bl ? (f = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f.isNaN() : (f = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f.isNaN())) {
                    int n4 = n3 + 1;
                    while (n4 < n) {
                        Float f2;
                        attributedCharacterIterator.setIndex(n4);
                        if (bl ? (f2 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f2.isNaN() : (f2 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f2.isNaN()) break;
                        arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n4 - 1, n4));
                        n2 = n4++;
                    }
                }
                n3 = n;
            }
            n3 = attributedCharacterIterator.getIndex();
            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n3));
            n2 = n3;
        }
        object = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            object[n] = (AttributedCharacterIterator)iterator.next();
            ++n;
        }
        return object;
    }

    protected static AttributedCharacterIterator createModifiedACIForFontMatching(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedString attributedString = null;
        int n = 0;
        int n2 = attributedCharacterIterator.getBeginIndex();
        boolean bl = true;
        int n3 = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_ID);
        while (bl) {
            int n4;
            GVTFont gVTFont;
            int n5;
            int n6 = n3;
            n3 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
            int n7 = n3 - n6;
            List list = (List)attributedCharacterIterator.getAttribute(GVT_FONTS);
            float f = 12.0f;
            Float f2 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            if (f2 != null) {
                f = f2.floatValue();
            }
            if (list.size() == 0) {
                list.add(FontFamilyResolver.defaultFont.deriveFont(f, attributedCharacterIterator));
            }
            boolean[] blArray = new boolean[n7];
            if (attributedString == null) {
                attributedString = new AttributedString(attributedCharacterIterator);
            }
            GVTFont gVTFont2 = null;
            int n8 = 0;
            int n9 = n6;
            for (n5 = 0; n5 < list.size(); ++n5) {
                int n10 = n9;
                boolean bl2 = false;
                attributedCharacterIterator.setIndex(n10);
                gVTFont = (GVTFont)list.get(n5);
                if (gVTFont2 == null) {
                    gVTFont2 = gVTFont;
                }
                while (n10 < n3) {
                    n4 = gVTFont.canDisplayUpTo(attributedCharacterIterator, n10, n3);
                    Object object = attributedCharacterIterator.getAttribute(ALT_GLYPH_HANDLER);
                    if (object != null) {
                        n4 = -1;
                    }
                    if (n4 == -1) {
                        n4 = n3;
                    }
                    if (n4 <= n10) {
                        if (!bl2) {
                            n9 = n10;
                            bl2 = true;
                        }
                        ++n10;
                        continue;
                    }
                    int n11 = -1;
                    for (int i = n10; i < n4; ++i) {
                        if (blArray[i - n6]) {
                            if (n11 != -1) {
                                attributedString.addAttribute(GVT_FONT, gVTFont, n11 - n2, i - n2);
                                n11 = -1;
                            }
                        } else if (n11 == -1) {
                            n11 = i;
                        }
                        blArray[i - n6] = true;
                        ++n8;
                    }
                    if (n11 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n11 - n2, n4 - n2);
                    }
                    n10 = n4 + 1;
                }
                if (n8 == n7) break;
            }
            n5 = -1;
            GVTFontFamily gVTFontFamily = null;
            gVTFont = gVTFont2;
            for (n4 = 0; n4 < n7; ++n4) {
                if (blArray[n4]) {
                    if (n5 == -1) continue;
                    attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n4 + n);
                    n5 = -1;
                    gVTFont = null;
                    gVTFontFamily = null;
                    continue;
                }
                char c = attributedCharacterIterator.setIndex(n6 + n4);
                GVTFontFamily gVTFontFamily2 = FontFamilyResolver.getFamilyThatCanDisplay(c);
                if (n5 == -1) {
                    n5 = n4;
                    gVTFontFamily = gVTFontFamily2;
                    if (gVTFontFamily == null) {
                        gVTFont = gVTFont2;
                        continue;
                    }
                    gVTFont = gVTFontFamily2.deriveFont(f, attributedCharacterIterator);
                    continue;
                }
                if (gVTFontFamily == gVTFontFamily2) continue;
                attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n4 + n);
                n5 = n4;
                gVTFontFamily = gVTFontFamily2;
                gVTFont = gVTFontFamily == null ? gVTFont2 : gVTFontFamily2.deriveFont(f, attributedCharacterIterator);
            }
            if (n5 != -1) {
                attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n7 + n);
            }
            n += n7;
            if (attributedCharacterIterator.setIndex(n3) == '\uffff') {
                bl = false;
            }
            n6 = n3;
        }
        if (attributedString != null) {
            return attributedString.getIterator();
        }
        return attributedCharacterIterator;
    }

    protected TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, int[] nArray, List list, TextChunk textChunk) {
        int n = 0;
        if (textChunk != null) {
            n = textChunk.end;
        }
        int n2 = n;
        int n3 = attributedCharacterIterator.getIndex();
        if (attributedCharacterIterator.current() == '\uffff') {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
        boolean bl = true;
        TextSpanLayout textSpanLayout = null;
        while (true) {
            int n4 = attributedCharacterIterator.getRunStart(extendedAtts);
            int n5 = attributedCharacterIterator.getRunLimit(extendedAtts);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n4, n5);
            int[] nArray2 = new int[n5 - n4];
            System.arraycopy(nArray, n4 - n3, nArray2, 0, nArray2.length);
            FontRenderContext fontRenderContext = this.fontRenderContext;
            RenderingHints renderingHints = textNode.getRenderingHints();
            if (renderingHints != null && renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                fontRenderContext = this.aaOffFontRenderContext;
            }
            textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterSpanIterator, nArray2, float_, fontRenderContext);
            list.add(new TextRun(textSpanLayout, attributedCharacterSpanIterator, bl));
            Point2D point2D = textSpanLayout.getAdvance2D();
            float_2.x += (float)point2D.getX();
            float_2.y += (float)point2D.getY();
            ++n2;
            if (attributedCharacterIterator.setIndex(n5) == '\uffff') break;
            bl = false;
        }
        return new TextChunk(n, n2, float_2);
    }

    protected Point2D adjustChunkOffsets(Point2D point2D, List list, TextChunk textChunk) {
        Point2D.Float float_;
        TextRun textRun = (TextRun)list.get(textChunk.begin);
        int n = textRun.getAnchorType();
        Float f = textRun.getLength();
        Integer n2 = textRun.getLengthAdjust();
        boolean bl = true;
        if (f == null || f.isNaN()) {
            bl = false;
        }
        int n3 = 0;
        for (int i = textChunk.begin; i < textChunk.end; ++i) {
            textRun = (TextRun)list.get(i);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            n3 += attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        if (n2 == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && n3 == 1) {
            bl = false;
        }
        float f2 = 1.0f;
        float f3 = 1.0f;
        textRun = (TextRun)list.get(textChunk.end - 1);
        TextSpanLayout textSpanLayout = textRun.getLayout();
        GVTGlyphMetrics gVTGlyphMetrics = textSpanLayout.getGlyphMetrics(textSpanLayout.getGlyphCount() - 1);
        GVTLineMetrics gVTLineMetrics = textSpanLayout.getLineMetrics();
        Rectangle2D rectangle2D = gVTGlyphMetrics.getBounds2D();
        float f4 = (gVTGlyphMetrics.getVerticalAdvance() - (gVTLineMetrics.getAscent() + gVTLineMetrics.getDescent())) / 2.0f;
        float f5 = (float)(rectangle2D.getWidth() + rectangle2D.getX());
        float f6 = (float)((double)(f4 + gVTLineMetrics.getAscent()) + (rectangle2D.getHeight() + rectangle2D.getY()));
        if (!bl) {
            float_ = new Point2D.Float((float)(textChunk.advance.getX() + (double)f5 - (double)gVTGlyphMetrics.getHorizontalAdvance()), (float)(textChunk.advance.getY() - (double)gVTGlyphMetrics.getVerticalAdvance() + (double)f6));
        } else {
            double d;
            Point2D point2D2 = textChunk.advance;
            if (textSpanLayout.isVertical()) {
                if (n2 == ADJUST_SPACING) {
                    f3 = (float)((double)(f.floatValue() - f6) / (point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance()));
                } else {
                    d = point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance() + (double)f6;
                    f3 = (float)((double)f.floatValue() / d);
                }
                float_ = new Point2D.Float(0.0f, f.floatValue());
            } else {
                if (n2 == ADJUST_SPACING) {
                    f2 = (float)((double)(f.floatValue() - f5) / (point2D2.getX() - (double)gVTGlyphMetrics.getHorizontalAdvance()));
                } else {
                    d = point2D2.getX() + (double)f5 - (double)gVTGlyphMetrics.getHorizontalAdvance();
                    f2 = (float)((double)f.floatValue() / d);
                }
                float_ = new Point2D.Float(f.floatValue(), 0.0f);
            }
            Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
            for (int i = textChunk.begin; i < textChunk.end; ++i) {
                textRun = (TextRun)list.get(i);
                textSpanLayout = textRun.getLayout();
                textSpanLayout.setScale(f2, f3, n2 == ADJUST_SPACING);
                Point2D point2D3 = textSpanLayout.getAdvance2D();
                float_2.x += (float)point2D3.getX();
                float_2.y += (float)point2D3.getY();
            }
            textChunk.advance = float_2;
        }
        float f7 = 0.0f;
        float f8 = 0.0f;
        switch (n) {
            case 1: {
                f7 = (float)(-((Point2D)float_).getX() / 2.0);
                f8 = (float)(-((Point2D)float_).getY() / 2.0);
                break;
            }
            case 2: {
                f7 = (float)(-((Point2D)float_).getX());
                f8 = (float)(-((Point2D)float_).getY());
                break;
            }
        }
        textRun = (TextRun)list.get(textChunk.begin);
        textSpanLayout = textRun.getLayout();
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        boolean bl2 = textSpanLayout.isVertical();
        Float f9 = (Float)attributedCharacterIterator.getAttribute(XPOS);
        Float f10 = (Float)attributedCharacterIterator.getAttribute(YPOS);
        TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
        float f11 = (float)point2D.getX();
        float f12 = (float)point2D.getY();
        float f13 = 0.0f;
        float f14 = 0.0f;
        if (f9 != null && !f9.isNaN()) {
            f13 = f11 = f9.floatValue();
        }
        if (f10 != null && !f10.isNaN()) {
            f14 = f12 = f10.floatValue();
        }
        if (bl2) {
            f12 += f8;
            f14 += f8;
            f13 = 0.0f;
        } else {
            f11 += f7;
            f13 += f7;
            f14 = 0.0f;
        }
        for (int i = textChunk.begin; i < textChunk.end; ++i) {
            Point2D point2D4;
            textRun = (TextRun)list.get(i);
            textSpanLayout = textRun.getLayout();
            attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
            if (bl2) {
                f9 = (Float)attributedCharacterIterator.getAttribute(XPOS);
                if (f9 != null && !f9.isNaN()) {
                    f11 = f9.floatValue();
                }
            } else {
                f10 = (Float)attributedCharacterIterator.getAttribute(YPOS);
                if (f10 != null && !f10.isNaN()) {
                    f12 = f10.floatValue();
                }
            }
            if (textPath == null) {
                textSpanLayout.setOffset(new Point2D.Float(f11, f12));
                point2D4 = textSpanLayout.getAdvance2D();
                f11 = (float)((double)f11 + point2D4.getX());
                f12 = (float)((double)f12 + point2D4.getY());
                continue;
            }
            textSpanLayout.setOffset(new Point2D.Float(f13, f14));
            point2D4 = textSpanLayout.getAdvance2D();
            f13 += (float)point2D4.getX();
            f14 += (float)point2D4.getY();
            point2D4 = textSpanLayout.getTextPathAdvance();
            f11 = (float)point2D4.getX();
            f12 = (float)point2D4.getY();
        }
        return new Point2D.Float(f11, f12);
    }

    protected void paintDecorations(List list, Graphics2D graphics2D, int n) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)list.get(i);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null && textPaintInfo.composite != null) {
                graphics2D.setComposite(textPaintInfo.composite);
            }
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            if (textPaintInfo != null) {
                switch (n) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n);
                rectangle2D = shape.getBounds2D();
                d = rectangle2D.getY();
                d2 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(rectangularShape);
                }
                if (stroke != null && paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(rectangularShape);
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d3 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d4 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d3, d, d4 - d3, d2);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangularShape);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    protected void paintTextRuns(List list, Graphics2D graphics2D) {
        for (int i = 0; i < list.size(); ++i) {
            TextRun textRun = (TextRun)list.get(i);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null && textPaintInfo.composite != null) {
                graphics2D.setComposite(textPaintInfo.composite);
            }
            textRun.getLayout().draw(graphics2D);
        }
    }

    @Override
    public Shape getOutline(TextNode textNode) {
        Object object;
        Object object2;
        GeneralPath generalPath = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        for (int i = 0; i < list.size(); ++i) {
            object2 = (TextRun)list.get(i);
            object = ((TextRun)object2).getLayout();
            GeneralPath generalPath2 = new GeneralPath(object.getOutline());
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            generalPath.setWindingRule(1);
            generalPath.append(generalPath2, false);
        }
        Shape shape = this.getDecorationOutline(list, 1);
        object2 = this.getDecorationOutline(list, 2);
        object = this.getDecorationOutline(list, 4);
        if (shape != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath(shape);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append(shape, false);
            }
        }
        if (object2 != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object2);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object2, false);
            }
        }
        if (object != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object, false);
            }
        }
        return generalPath;
    }

    @Override
    public Rectangle2D getBounds2D(TextNode textNode) {
        Object object;
        Object object2;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < list.size(); ++i) {
            object2 = (TextRun)list.get(i);
            object = ((TextRun)object2).getLayout();
            Rectangle2D rectangle2D2 = object.getBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        Shape shape = this.getDecorationStrokeOutline(list, 1);
        if (shape != null) {
            if (rectangle2D == null) {
                rectangle2D = shape.getBounds2D();
            } else {
                rectangle2D.add(shape.getBounds2D());
            }
        }
        if ((object2 = this.getDecorationStrokeOutline(list, 2)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object2.getBounds2D();
            } else {
                rectangle2D.add(object2.getBounds2D());
            }
        }
        if ((object = this.getDecorationStrokeOutline(list, 4)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object.getBounds2D();
            } else {
                rectangle2D.add(object.getBounds2D());
            }
        }
        return rectangle2D;
    }

    protected Shape getDecorationOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)list.get(i);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n);
                rectangle2D = shape.getBounds2D();
                d = rectangle2D.getY();
                d2 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangularShape);
                } else {
                    path2D.append(rectangularShape, false);
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d3 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d4 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d3, d, d4 - d3, d2);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangularShape);
            } else {
                path2D.append(rectangularShape, false);
            }
        }
        return path2D;
    }

    protected Shape getDecorationStrokeOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Shape shape = null;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D rectangle2D;
            Shape shape2;
            TextRun textRun = (TextRun)list.get(i);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape2 = textRun.getLayout().getDecorationOutline(n);
                rectangle2D = shape2.getBounds2D();
                d = rectangle2D.getY();
                d2 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && shape != null) {
                shape2 = null;
                if (stroke != null && paint2 != null) {
                    shape2 = stroke.createStrokedShape(shape);
                } else if (paint != null) {
                    shape2 = shape;
                }
                if (shape2 != null) {
                    if (path2D == null) {
                        path2D = new GeneralPath(shape2);
                    } else {
                        path2D.append(shape2, false);
                    }
                }
                shape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape2 = textRun.getLayout().getDecorationOutline(n);
                if (shape == null) {
                    rectangle2D = shape2.getBounds2D();
                    shape = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
                } else {
                    rectangle2D = shape2.getBounds2D();
                    double d3 = Math.min(((RectangularShape)shape).getX(), rectangle2D.getX());
                    double d4 = Math.max(((RectangularShape)shape).getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)shape).setRect(d3, d, d4 - d3, d2);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (shape != null) {
            Shape shape3 = null;
            if (stroke != null && paint2 != null) {
                shape3 = stroke.createStrokedShape(shape);
            } else if (paint != null) {
                shape3 = shape;
            }
            if (shape3 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(shape3);
                } else {
                    path2D.append(shape3, false);
                }
            }
        }
        return path2D;
    }

    @Override
    public Mark getMark(TextNode textNode, int n, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        if (n < attributedCharacterIterator.getBeginIndex() || n > attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        TextHit textHit = new TextHit(n, bl);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    protected Mark hitTest(double d, double d2, TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                TextRun textRun = (TextRun)list.get(i);
                TextSpanLayout textSpanLayout = textRun.getLayout();
                TextHit textHit = textSpanLayout.hitTestChar((float)d, (float)d2);
                Rectangle2D rectangle2D = textSpanLayout.getBounds2D();
                if (textHit == null || rectangle2D == null || !rectangle2D.contains(d, d2)) continue;
                return new BasicTextPainter.BasicMark(textNode, textHit);
            }
        }
        return null;
    }

    @Override
    public Mark selectFirst(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getBeginIndex(), false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    public Mark selectLast(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getEndIndex() - 1, false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    public int[] getSelected(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Iterator iterator = list.iterator();
        int n = -1;
        int n2 = -1;
        TextSpanLayout textSpanLayout = null;
        TextSpanLayout textSpanLayout2 = null;
        while (iterator.hasNext()) {
            TextRun textRun = (TextRun)iterator.next();
            TextSpanLayout textSpanLayout3 = textRun.getLayout();
            if (n == -1 && (n = textSpanLayout3.getGlyphIndex(nArray[0])) != -1) {
                textSpanLayout = textSpanLayout3;
            }
            if (n2 == -1 && (n2 = textSpanLayout3.getGlyphIndex(nArray[1])) != -1) {
                textSpanLayout2 = textSpanLayout3;
            }
            if (n == -1 || n2 == -1) continue;
            break;
        }
        if (textSpanLayout == null || textSpanLayout2 == null) {
            return null;
        }
        int n3 = textSpanLayout.getCharacterCount(n, n);
        int n4 = textSpanLayout2.getCharacterCount(n2, n2);
        if (n3 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n3 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n3 - 1);
            }
        }
        if (n4 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n4 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n4 - 1);
            }
        }
        return nArray;
    }

    @Override
    public Shape getHighlightShape(Mark mark, Mark mark2) {
        Object object;
        int n;
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n2 = basicMark2.getHit().getCharIndex();
        if (n2 > (n = basicMark.getHit().getCharIndex())) {
            object = basicMark2;
            basicMark2 = basicMark;
            basicMark = object;
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        object = this.getTextRuns(textNode, attributedCharacterIterator);
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < object.size(); ++i) {
            TextRun textRun = (TextRun)object.get(i);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Shape shape = textSpanLayout.getHighlightShape(n2, n);
            if (shape == null || shape.getBounds().isEmpty()) continue;
            generalPath.append(shape, false);
        }
        return generalPath;
    }

    static {
        extendedAtts.add(FLOW_PARAGRAPH);
        extendedAtts.add(TEXT_COMPOUND_ID);
        extendedAtts.add(GVT_FONT);
        singleton = new StrokingTextPainter();
    }

    public class TextRun {
        protected AttributedCharacterIterator aci;
        protected TextSpanLayout layout;
        protected int anchorType;
        protected boolean firstRunInChunk;
        protected Float length;
        protected Integer lengthAdjust;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl;
            this.anchorType = 0;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
            this.length = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
            this.lengthAdjust = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public Float getLength() {
            return this.length;
        }

        public Integer getLengthAdjust() {
            return this.lengthAdjust;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n, int n2, Point2D point2D) {
            this.begin = n;
            this.end = n2;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

