/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.maven2.AbstractCommonMojo;
import org.codehaus.cargo.maven2.configuration.Configuration;
import org.codehaus.cargo.maven2.configuration.Container;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.maven2.configuration.Deployer;
import org.codehaus.cargo.maven2.jetty.JettyArtifactResolver;
import org.codehaus.cargo.maven2.log.MavenLogger;
import org.codehaus.cargo.maven2.util.CargoProject;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractCargoMojo
extends AbstractCommonMojo {
    public static final String CONTEXT_KEY_CONTAINER = AbstractCargoMojo.class.getName() + "-Container";
    private FileHandler fileHandler = new DefaultFileHandler();
    private Configuration configuration;
    private Container container;
    private Deployer deployer;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List repositories;
    private ArtifactFactory artifactFactory;
    private CargoProject cargoProject;

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    protected Deployer getDeployerElement() {
        return this.deployer;
    }

    protected void setDeployerElement(Deployer deployerElement) {
        this.deployer = deployerElement;
    }

    protected Configuration getConfigurationElement() {
        return this.configuration;
    }

    protected void setConfigurationElement(Configuration configurationElement) {
        this.configuration = configurationElement;
    }

    protected Container getContainerElement() {
        return this.container;
    }

    protected void setContainerElement(Container containerElement) {
        this.container = containerElement;
    }

    protected void setCargoProject(CargoProject cargoProject) {
        this.cargoProject = cargoProject;
    }

    protected CargoProject getCargoProject() {
        return this.cargoProject;
    }

    public final void execute() throws MojoExecutionException {
        if (this.cargoProject == null) {
            this.cargoProject = new CargoProject(this.getProject(), this.getLog());
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException;

    protected org.codehaus.cargo.container.configuration.Configuration createConfiguration() throws MojoExecutionException {
        if (this.getConfigurationElement() == null) {
            Configuration configurationElement = new Configuration();
            if (this.getContainerElement().getType().isLocal()) {
                configurationElement.setType(ConfigurationType.STANDALONE);
                configurationElement.setHome(new File(this.getCargoProject().getBuildDirectory(), this.getContainerElement().getContainerId()).getPath());
            } else {
                configurationElement.setType(ConfigurationType.RUNTIME);
            }
            this.setConfigurationElement(configurationElement);
        }
        org.codehaus.cargo.container.configuration.Configuration configuration = this.getConfigurationElement().createConfiguration(this.getContainerElement().getContainerId(), this.getContainerElement().getType(), this.getCargoProject());
        return configuration;
    }

    protected org.codehaus.cargo.container.Container createContainer() throws MojoExecutionException {
        org.codehaus.cargo.container.Container container = null;
        Map context = this.getPluginContext();
        if (context != null) {
            container = (org.codehaus.cargo.container.Container)context.get(CONTEXT_KEY_CONTAINER);
        }
        if (container == null) {
            container = this.createNewContainer();
        }
        if (context != null) {
            context.put(CONTEXT_KEY_CONTAINER, container);
        }
        return container;
    }

    protected org.codehaus.cargo.container.Container createNewContainer() throws MojoExecutionException {
        if (this.getContainerElement() == null) {
            if (this.getCargoProject().getPackaging() != null && !this.getCargoProject().getPackaging().equalsIgnoreCase("war")) {
                throw new MojoExecutionException("For all packaging other than war you need to configure the container you wishes to use.");
            }
            Container containerElement = new Container();
            this.computeContainerId(containerElement);
            this.getLog().info((CharSequence)("No container defined, using a default [" + containerElement.getContainerId() + ", " + containerElement.getType().getType() + "] container"));
            this.setContainerElement(containerElement);
        }
        if (this.getContainerElement().getContainerId() == null) {
            this.computeContainerId(this.getContainerElement());
        }
        if (this.getContainerElement().getType() == ContainerType.EMBEDDED) {
            this.loadEmbeddedContainerDependencies();
        }
        org.codehaus.cargo.container.Container container = this.getContainerElement().createContainer(this.createConfiguration(), this.createLogger(), this.getCargoProject());
        return container;
    }

    private void computeContainerId(Container containerElement) {
        if (containerElement.getContainerId() == null) {
            containerElement.setContainerId("jetty6x");
            containerElement.setType(ContainerType.EMBEDDED);
        }
    }

    protected void loadEmbeddedContainerDependencies() throws MojoExecutionException {
        if (this.getContainerElement().getContainerId().startsWith("jetty")) {
            JettyArtifactResolver resolver = new JettyArtifactResolver(this.artifactResolver, this.localRepository, this.repositories, this.artifactFactory);
            ClassLoader classLoader = resolver.resolveDependencies(this.getContainerElement().getContainerId(), this.getCargoProject().getEmbeddedClassLoader());
            this.getCargoProject().setEmbeddedClassLoader(classLoader);
        }
    }

    protected org.codehaus.cargo.container.deployable.Deployable createAutoDeployDeployable(org.codehaus.cargo.container.Container container) throws MojoExecutionException {
        Deployable deployableElement = new Deployable();
        return deployableElement.createDeployable(container.getId(), this.getCargoProject());
    }

    protected boolean containsAutoDeployable(Deployable[] deployableElements) {
        boolean found = false;
        for (int i = 0; i < deployableElements.length; ++i) {
            Deployable deployableElement = deployableElements[i];
            if (!deployableElement.getGroupId().equals(this.getCargoProject().getGroupId()) || !deployableElement.getArtifactId().equals(this.getCargoProject().getArtifactId())) continue;
            found = true;
            break;
        }
        return found;
    }

    protected Logger createLogger() {
        MavenLogger logger;
        if (this.getContainerElement() != null && this.getContainerElement().getLog() != null) {
            this.getContainerElement().getLog().getParentFile().mkdirs();
            logger = new FileLogger(this.getContainerElement().getLog(), false);
        } else {
            logger = new MavenLogger(this.getLog());
        }
        if (this.getContainerElement() != null && this.getContainerElement().getLogLevel() != null) {
            logger.setLevel(this.getContainerElement().getLogLevel());
        }
        return logger;
    }
}

