/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.maven2.AbstractCommonMojo;
import org.codehaus.cargo.maven2.Merge;
import org.codehaus.cargo.maven2.MergeRoot;
import org.codehaus.cargo.maven2.WebXml;
import org.codehaus.cargo.maven2.io.xpp3.UberWarXpp3Reader;
import org.codehaus.cargo.module.merge.DocumentStreamAdapter;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.merge.strategy.ChooseByNameMergeStrategy;
import org.codehaus.cargo.module.merge.strategy.MergeStrategy;
import org.codehaus.cargo.module.merge.strategy.NodeMergeStrategy;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WarArchiveMerger;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.xml.sax.SAXException;

public class UberWarMojo
extends AbstractCommonMojo {
    private String outputDirectory;
    private String warName;
    private File descriptor;
    private String descriptorId;
    private List wars;
    private PlexusConfiguration settings;

    public void execute() throws MojoExecutionException {
        InputStreamReader r = null;
        if (this.descriptor != null) {
            try {
                r = new FileReader(this.descriptor);
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException("Could not find specified descriptor");
            }
        } else if (this.descriptorId != null) {
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/uberwar/" + this.descriptorId + ".xml");
            if (resourceAsStream == null) {
                throw new MojoExecutionException("Descriptor with ID '" + this.descriptorId + "' not found");
            }
            r = new InputStreamReader(resourceAsStream);
        } else {
            throw new MojoExecutionException("You must specify descriptor or descriptorId");
        }
        try {
            Iterator i;
            UberWarXpp3Reader reader = new UberWarXpp3Reader();
            MergeRoot root = reader.read(r);
            WarArchiveMerger wam = new WarArchiveMerger();
            List wars = root.getWars();
            if (wars.size() == 0) {
                this.addAllWars(wam);
            } else {
                i = wars.iterator();
                while (i.hasNext()) {
                    String id = (String)i.next();
                    this.addWar(wam, id);
                }
            }
            i = root.getMerges().iterator();
            while (i.hasNext()) {
                Merge merge = (Merge)i.next();
                this.doMerge(wam, merge);
            }
            WebXml merge = root.getWebXml();
            this.doWebXmlMerge(wam, merge);
            File warFile = new File(this.outputDirectory, this.warName + ".war");
            WarArchive output = (WarArchive)wam.performMerge();
            output.store(warFile);
            this.getProject().getArtifact().setFile(warFile);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Invalid XML descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException creating UBERWAR", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Xml format exception creating UBERWAR", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Parsing exception creating UBERWAR", (Exception)e);
        }
        catch (MergeException e) {
            throw new MojoExecutionException("Merging exception creating UBERWAR", (Exception)((Object)e));
        }
    }

    private void doWebXmlMerge(WarArchiveMerger wam, WebXml merge) throws MojoExecutionException {
        Xpp3Dom dom = (Xpp3Dom)merge.getContextParams();
        try {
            MergeStrategy ms = this.makeStrategy(dom.getChild(0));
            wam.getWebXmlMerger().setMergeContextParamsStrategy(ms);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception merging web.xml", e);
        }
    }

    private void doMerge(WarArchiveMerger wam, Merge merge) throws MojoExecutionException {
        try {
            String file = merge.getFile();
            String document = merge.getDocument();
            String clazz = merge.getClassname();
            MergeProcessor merger = (MergeProcessor)Class.forName(clazz).newInstance();
            if (document != null) {
                merger = new DocumentStreamAdapter(merger);
                wam.addMergeProcessor(document, merger);
            } else {
                wam.addMergeProcessor(file, merger);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem in file merge", e);
        }
    }

    protected MergeStrategy makeStrategy(Xpp3Dom config) throws MojoExecutionException {
        if (!config.getName().equals("strategy")) {
            throw new MojoExecutionException("You must specify a merge strategy");
        }
        String strategyName = config.getAttribute("name");
        if (strategyName.equalsIgnoreCase("Preserve")) {
            return MergeStrategy.PRESERVE;
        }
        if (strategyName.equalsIgnoreCase("Overwrite")) {
            return MergeStrategy.OVERWRITE;
        }
        if (strategyName.equalsIgnoreCase("ChooseByName")) {
            Xpp3Dom def = config.getChild("default").getChild(0);
            ChooseByNameMergeStrategy cbnms = new ChooseByNameMergeStrategy(this.makeStrategy(def));
            Xpp3Dom[] items = config.getChildren();
            for (int i = 0; i < items.length; ++i) {
                Xpp3Dom item = items[i];
                if (!item.getName().equals("choice")) continue;
                cbnms.addStrategyForName(item.getAttribute("name"), this.makeStrategy(item.getChild(0)));
            }
            return cbnms;
        }
        if (strategyName.equalsIgnoreCase("NodeMerge")) {
            String theXml = config.getChild(0).toString();
            try {
                return new NodeMergeStrategy((InputStream)new ByteArrayInputStream(theXml.getBytes()));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Problem generating Node Merge strategy");
            }
        }
        throw new MojoExecutionException("Must provide a known strategy type (don't understand " + strategyName + ")");
    }

    protected void addWar(WarArchiveMerger wam, String artifactIdent) throws MojoExecutionException, IOException {
        Iterator iter = this.getProject().getArtifacts().iterator();
        while (iter.hasNext()) {
            String name;
            String type;
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(type = artifact.getType()) || !(name = artifact.getGroupId() + ":" + artifact.getArtifactId()).equals(artifactIdent)) continue;
            try {
                wam.addMergeItem((Object)new DefaultWarArchive(artifact.getFile().getPath()));
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
            return;
        }
        throw new MojoExecutionException("Could not find a dependent WAR file matching " + artifactIdent);
    }

    protected void addAllWars(WarArchiveMerger wam) throws MojoExecutionException, IOException {
        Iterator iter = this.getProject().getArtifacts().iterator();
        while (iter.hasNext()) {
            String type;
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(type = artifact.getType())) continue;
            try {
                wam.addMergeItem((Object)new DefaultWarArchive(artifact.getFile().getPath()));
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
        }
    }
}

