/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.maven2.configuration.Dependency;
import org.codehaus.cargo.maven2.configuration.ZipUrlInstaller;
import org.codehaus.cargo.maven2.util.CargoProject;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;

public class Container {
    private String containerId;
    private String implementation;
    private Dependency[] dependencies;
    private String home;
    private String output;
    private ZipUrlInstaller zipUrlInstaller;
    private boolean append;
    private File log;
    private LogLevel logLevel;
    private String type = ContainerType.INSTALLED.getType();
    private Long timeout;
    private Map systemProperties;

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Dependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public ContainerType getType() {
        return ContainerType.toType((String)this.type);
    }

    public void setType(ContainerType type) {
        this.type = type.getType();
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getOutput() {
        return this.output;
    }

    public ZipUrlInstaller getZipUrlInstaller() {
        return this.zipUrlInstaller;
    }

    public boolean shouldAppend() {
        return this.append;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public File getLog() {
        return this.log;
    }

    public void setLogLevel(String levelAsString) {
        this.logLevel = LogLevel.toLevel((String)levelAsString);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public org.codehaus.cargo.container.Container createContainer(Configuration configuration, Logger logger, CargoProject project) throws MojoExecutionException {
        org.codehaus.cargo.container.Container container;
        DefaultContainerFactory factory = new DefaultContainerFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> containerClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerContainer(this.getContainerId(), this.getType(), containerClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom container implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        if ((container = factory.createContainer(this.getContainerId(), this.getType(), configuration)).getType().isLocal()) {
            this.setupTimeout((LocalContainer)container, project);
            if (container.getType() == ContainerType.EMBEDDED) {
                this.setupEmbeddedExtraClasspath((EmbeddedLocalContainer)container, project);
                this.setupEmbeddedSystemProperties((EmbeddedLocalContainer)container);
                ((EmbeddedLocalContainer)container).setClassLoader(project.getEmbeddedClassLoader());
                Thread.currentThread().setContextClassLoader(project.getEmbeddedClassLoader());
            } else if (container.getType() == ContainerType.INSTALLED) {
                this.setupHome((InstalledLocalContainer)container);
                this.setupOutput((InstalledLocalContainer)container, project);
                this.setupExtraClasspath((InstalledLocalContainer)container, project);
                this.setupSystemProperties((InstalledLocalContainer)container);
            }
        }
        this.setupLogger(container, logger);
        return container;
    }

    private void setupEmbeddedExtraClasspath(EmbeddedLocalContainer container, CargoProject project) throws MojoExecutionException {
        if (this.getDependencies() != null) {
            URL[] dependencyURLs = new URL[this.getDependencies().length];
            for (int i = 0; i < this.getDependencies().length; ++i) {
                File pathFile = new File(this.getDependencies()[i].getDependencyPath(project));
                try {
                    dependencyURLs[i] = pathFile.toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Invalid classpath location [" + pathFile.getPath() + "]");
                }
            }
            URLClassLoader urlClassloader = new URLClassLoader(dependencyURLs, project.getEmbeddedClassLoader());
            project.setEmbeddedClassLoader(urlClassloader);
        }
    }

    private void setupEmbeddedSystemProperties(EmbeddedLocalContainer container) {
        if (this.getSystemProperties() != null) {
            Iterator iter = this.getSystemProperties().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void setupOutput(InstalledLocalContainer container, CargoProject project) {
        if (this.getOutput() != null) {
            container.setOutput(this.getOutput());
        } else {
            project.getLog().debug((CharSequence)"No container log will be generated. Configure the plugin using the <output> element under <container> to generate container logs");
        }
    }

    private void setupTimeout(LocalContainer container, CargoProject project) {
        if (this.getTimeout() != null) {
            project.getLog().debug((CharSequence)("Setting container timeout to [" + this.getTimeout() + "]"));
            container.setTimeout(this.getTimeout().longValue());
        }
    }

    private void setupExtraClasspath(InstalledLocalContainer container, CargoProject project) throws MojoExecutionException {
        if (this.getDependencies() != null) {
            String[] classpaths = new String[this.getDependencies().length];
            for (int i = 0; i < this.getDependencies().length; ++i) {
                classpaths[i] = this.getDependencies()[i].getDependencyPath(project);
            }
            container.setExtraClasspath(classpaths);
        }
    }

    private void setupSystemProperties(InstalledLocalContainer container) throws MojoExecutionException {
        if (this.getSystemProperties() != null) {
            container.setSystemProperties(this.getSystemProperties());
        }
    }

    private void setupHome(InstalledLocalContainer container) {
        if (this.getHome() != null) {
            container.setHome(this.getHome());
        } else if (this.getZipUrlInstaller() != null) {
            ZipURLInstaller installer = this.getZipUrlInstaller().createInstaller();
            if (this.getLog() != null) {
                installer.setLogger(container.getLogger());
            }
            installer.install();
            container.setHome(installer.getHome());
        }
    }

    private void setupLogger(org.codehaus.cargo.container.Container container, Logger logger) {
        container.setLogger(logger);
        if (container instanceof LocalContainer) {
            ((LocalContainer)container).getConfiguration().setLogger(logger);
        } else {
            ((RemoteContainer)container).getConfiguration().setLogger(logger);
        }
    }
}

