/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildException;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.maven2.configuration.AbstractDependency;
import org.codehaus.cargo.maven2.util.CargoProject;

public class Deployable
extends AbstractDependency {
    private URL pingURL;
    private Long pingTimeout;
    private String implementation;
    private Map properties;

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public URL getPingURL() {
        return this.pingURL;
    }

    public Long getPingTimeout() {
        return this.pingTimeout;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public org.codehaus.cargo.container.deployable.Deployable createDeployable(String containerId, CargoProject project) throws MojoExecutionException {
        project.getLog().debug((CharSequence)("Initial deployable values: groupId = [" + this.getGroupId() + "], artifactId = [" + this.getArtifactId() + "], type = [" + this.getType() + "], location = [" + this.getLocation() + "]"));
        if (this.getGroupId() == null) {
            this.setGroupId(project.getGroupId());
        }
        if (this.getType() == null) {
            this.setType(project.getPackaging());
        }
        if (this.getArtifactId() == null) {
            this.setArtifactId(project.getArtifactId());
        }
        if (this.getLocation() == null) {
            this.setLocation(this.computeLocation(project));
        }
        project.getLog().debug((CharSequence)("Computed deployable values: groupId = [" + this.getGroupId() + "], artifactId = [" + this.getArtifactId() + "], type = [" + this.getType() + "], location = [" + this.getLocation() + "]"));
        DefaultDeployableFactory factory = new DefaultDeployableFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> deployableClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerDeployable(containerId, DeployableType.toType((String)this.getType()), deployableClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom deployable implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        org.codehaus.cargo.container.deployable.Deployable deployable = factory.createDeployable(containerId, this.getLocation(), DeployableType.toType((String)this.getType()));
        this.setPropertiesOnDeployable(deployable, project);
        return deployable;
    }

    protected void setPropertiesOnDeployable(org.codehaus.cargo.container.deployable.Deployable deployable, CargoProject project) {
        if (this.getProperties() != null) {
            Iterator props = this.getProperties().keySet().iterator();
            while (props.hasNext()) {
                String propertyName = (String)props.next();
                project.getLog().debug((CharSequence)("Setting deployable property [" + propertyName + "]:[" + this.getProperties().get(propertyName) + "] for [" + this.getLocation() + "]"));
                String propertyValue = (String)this.getProperties().get(propertyName);
                if (propertyValue == null) {
                    propertyValue = "";
                }
                this.callMethodForProperty(deployable, propertyName, propertyValue);
            }
        }
    }

    protected String computeLocation(CargoProject project) throws MojoExecutionException {
        String location;
        if (project.getGroupId().equals(this.getGroupId()) && project.getArtifactId().equals(this.getArtifactId()) && this.isTypeCompatible(project)) {
            location = new File(project.getBuildDirectory(), project.getFinalName() + "." + this.computeExtension(project.getPackaging())).getPath();
        } else {
            if (project.getGroupId().equals(this.getGroupId()) && project.getArtifactId().equals(this.getArtifactId())) {
                project.getLog().warn((CharSequence)("The defined deployable has the same groupId and artifactId as your project's main artifact but the type is different. You've defined a [" + this.getType() + "] type whereas the project's packaging is [" + project.getPackaging() + "]. This is possibly an error and as a consequence " + "the plugin will try to find this deployable in the project's dependencies."));
            }
            location = this.findArtifactLocation(project.getArtifacts(), project.getLog());
        }
        return location;
    }

    protected boolean isTypeCompatible(CargoProject project) {
        boolean isMatching = false;
        if (this.getType().equalsIgnoreCase(project.getPackaging()) || this.getType().equalsIgnoreCase("war") && project.getPackaging().equalsIgnoreCase("uberwar")) {
            isMatching = true;
        }
        return isMatching;
    }

    protected String computeExtension(String packaging) {
        String extension = packaging.equalsIgnoreCase("ejb") ? "jar" : (packaging.equalsIgnoreCase("uberwar") ? "war" : packaging);
        return extension;
    }

    private void callMethodForProperty(org.codehaus.cargo.container.deployable.Deployable deployable, String name, String value) {
        try {
            Method method = deployable.getClass().getMethod(this.getSetterMethodName(name), String.class);
            method.invoke((Object)deployable, value);
        }
        catch (Exception e) {
            throw new BuildException("Invalid property [" + name + "] for deployable type [" + deployable.getType() + "]", (Throwable)e);
        }
    }

    protected String getSetterMethodName(String propertyName) {
        return "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }
}

