/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.parsing.primitive.objects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveBigDecimal;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveBigInteger;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveBoolean;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveByte;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveChar;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveDouble;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveEnum;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveFloat;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveInteger;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveLong;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveObject;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveShort;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveObjectFactory {
    private static Map<Class<?>, PrimitiveObject> typeHandlers = new HashMap();

    public static Object getObject(Class<?> type, String value) {
        PrimitiveObject handler = PrimitiveObjectFactory.lookupHandler(type);
        if (handler == null) {
            handler = PrimitiveObjectFactory.getDefaultHandler();
        }
        handler.setType(type);
        if (type == String.class) {
            handler.setValue(value);
        } else {
            handler.setValue(PrimitiveObjectFactory.trimNumericValues(value));
        }
        return handler.getObject();
    }

    private static PrimitiveObject lookupHandler(Class<?> type) {
        if (type == null) {
            return null;
        }
        PrimitiveObject result = typeHandlers.get(type);
        if (result == null) {
            result = typeHandlers.get(type.getSuperclass());
        }
        return result;
    }

    private static String trimNumericValues(String value) {
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    private static PrimitiveObject getDefaultHandler() {
        return new PrimitiveObject();
    }

    static {
        typeHandlers.put(String.class, new PrimitiveString());
        typeHandlers.put(Enum.class, new PrimitiveEnum());
        typeHandlers.put(Integer.TYPE, new PrimitiveInteger());
        typeHandlers.put(Integer.class, new PrimitiveInteger());
        typeHandlers.put(Boolean.TYPE, new PrimitiveBoolean());
        typeHandlers.put(Boolean.class, new PrimitiveBoolean());
        typeHandlers.put(Double.TYPE, new PrimitiveDouble());
        typeHandlers.put(Double.class, new PrimitiveDouble());
        typeHandlers.put(Long.TYPE, new PrimitiveLong());
        typeHandlers.put(Long.class, new PrimitiveLong());
        typeHandlers.put(Character.TYPE, new PrimitiveChar());
        typeHandlers.put(Character.class, new PrimitiveChar());
        typeHandlers.put(Short.TYPE, new PrimitiveShort());
        typeHandlers.put(Short.class, new PrimitiveShort());
        typeHandlers.put(Float.TYPE, new PrimitiveFloat());
        typeHandlers.put(Float.class, new PrimitiveFloat());
        typeHandlers.put(Byte.TYPE, new PrimitiveByte());
        typeHandlers.put(Byte.class, new PrimitiveByte());
        typeHandlers.put(BigInteger.class, new PrimitiveBigInteger());
        typeHandlers.put(BigDecimal.class, new PrimitiveBigDecimal());
    }
}

