/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.control;

import java.net.URI;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.fabric3.binding.jms.common.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.common.CreateOption;
import org.fabric3.binding.jms.common.DestinationDefinition;
import org.fabric3.binding.jms.common.DestinationType;
import org.fabric3.binding.jms.common.JmsBindingMetadata;
import org.fabric3.binding.jms.model.JmsBindingDefinition;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.spi.binding.provider.BindingMatchResult;
import org.fabric3.spi.binding.provider.BindingProvider;
import org.fabric3.spi.binding.provider.BindingSelectionException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ActiveMQBindingProvider
implements BindingProvider {
    private static final BindingMatchResult NO_MATCH = new BindingMatchResult(false, JmsBindingDefinition.BINDING_QNAME);
    private static final QName OASIS_TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "transactedOneWay");
    private String connectionFactory;
    private String xaConnectionFactory;
    private boolean enabled = true;

    @Property
    public void setConnectionFactory(String name) {
        this.connectionFactory = name;
    }

    @Property
    public void setXaConnectionFactory(String name) {
        this.xaConnectionFactory = name;
    }

    @Property(required=false)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public QName getType() {
        return JmsBindingDefinition.BINDING_QNAME;
    }

    public BindingMatchResult canBind(LogicalReference source, LogicalService target) {
        if (!this.enabled) {
            return NO_MATCH;
        }
        return new BindingMatchResult(true, this.getType());
    }

    public void bind(LogicalReference source, LogicalService target) throws BindingSelectionException {
        String forwardQueue = target.getUri().toString();
        JmsBindingDefinition referenceDefinition = this.createBindingDefinition(forwardQueue, false);
        LogicalBinding referenceBinding = new LogicalBinding((BindingDefinition)referenceDefinition, (Bindable)source);
        referenceBinding.setAssigned(true);
        QName deployable = ((LogicalComponent)source.getParent()).getDeployable();
        source.addBinding(referenceBinding);
        boolean xa = this.isXA((LogicalAttachPoint)target, false);
        JmsBindingDefinition serviceDefinition = this.createBindingDefinition(forwardQueue, xa);
        LogicalBinding serviceBinding = new LogicalBinding((BindingDefinition)serviceDefinition, (Bindable)target, deployable);
        serviceBinding.setAssigned(true);
        target.addBinding(serviceBinding);
        if (target.getDefinition().getServiceContract().getCallbackContract() != null) {
            String callbackQueue = source.getUri().toString();
            boolean callbackXa = this.isXA((LogicalAttachPoint)target, true);
            JmsBindingDefinition callbackReferenceDefinition = this.createBindingDefinition(callbackQueue, callbackXa);
            LogicalBinding callbackReferenceBinding = new LogicalBinding((BindingDefinition)callbackReferenceDefinition, (Bindable)source);
            callbackReferenceBinding.setAssigned(true);
            source.addCallbackBinding(callbackReferenceBinding);
            JmsBindingDefinition callbackServiceDefinition = this.createBindingDefinition(callbackQueue, false);
            LogicalBinding callbackServiceBinding = new LogicalBinding((BindingDefinition)callbackServiceDefinition, (Bindable)target, deployable);
            callbackServiceBinding.setAssigned(true);
            target.addCallbackBinding(callbackServiceBinding);
            callbackReferenceDefinition.setGeneratedTargetUri(this.createCallbackUri(source));
            callbackServiceDefinition.setGeneratedTargetUri(this.createCallbackUri(source));
        }
    }

    private JmsBindingDefinition createBindingDefinition(String queueName, boolean xa) {
        ConnectionFactoryDefinition factoryDefinition;
        JmsBindingMetadata metadata = new JmsBindingMetadata();
        DestinationDefinition destinationDefinition = new DestinationDefinition();
        destinationDefinition.setType(DestinationType.QUEUE);
        destinationDefinition.setCreate(CreateOption.IF_NOT_EXIST);
        destinationDefinition.setName(queueName);
        metadata.setDestination(destinationDefinition);
        if (xa && this.xaConnectionFactory != null) {
            factoryDefinition = new ConnectionFactoryDefinition();
            factoryDefinition.setName(this.xaConnectionFactory);
            factoryDefinition.setCreate(CreateOption.NEVER);
            metadata.setConnectionFactory(factoryDefinition);
        } else if (xa) {
            factoryDefinition = new ConnectionFactoryDefinition();
            factoryDefinition.setName(ActiveMQXAConnectionFactory.class.getName());
            factoryDefinition.setCreate(CreateOption.ALWAYS);
            metadata.setConnectionFactory(factoryDefinition);
        } else if (this.connectionFactory != null) {
            factoryDefinition = new ConnectionFactoryDefinition();
            factoryDefinition.setName(this.connectionFactory);
            factoryDefinition.setCreate(CreateOption.NEVER);
            metadata.setConnectionFactory(factoryDefinition);
        } else {
            factoryDefinition = new ConnectionFactoryDefinition();
            factoryDefinition.setName(ActiveMQConnectionFactory.class.getName());
            factoryDefinition.setCreate(CreateOption.ALWAYS);
            metadata.setConnectionFactory(factoryDefinition);
        }
        JmsBindingDefinition definition = new JmsBindingDefinition(metadata);
        definition.setJmsMetadata(metadata);
        return definition;
    }

    public URI createCallbackUri(LogicalReference source) {
        LogicalComponent component = (LogicalComponent)source.getParent();
        String name = source.getDefinition().getServiceContract().getCallbackContract().getInterfaceName();
        return URI.create(component.getUri() + "#" + name);
    }

    private boolean isXA(LogicalAttachPoint attachPoint, boolean callback) {
        if (callback) {
            for (LogicalOperation operation : attachPoint.getCallbackOperations()) {
                if (!this.containsTransactionIntent(operation.getIntents())) continue;
                return true;
            }
        } else {
            for (LogicalOperation operation : attachPoint.getOperations()) {
                if (!this.containsTransactionIntent(operation.getIntents())) continue;
                return true;
            }
        }
        for (LogicalComponent parent = (LogicalComponent)attachPoint.getParent(); parent != null; parent = (LogicalComponent)parent.getParent()) {
            if (this.containsTransactionIntent(parent.getIntents())) {
                return true;
            }
            if (!this.containsTransactionIntent(parent.getDefinition().getImplementation().getIntents())) continue;
            return true;
        }
        return false;
    }

    private boolean containsTransactionIntent(Set<QName> intents) {
        return intents.contains(OASIS_TRANSACTED_ONEWAY);
    }
}

