/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.factory;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.fabric3.binding.activemq.factory.ConnectionFactoryConfiguration;
import org.fabric3.binding.activemq.factory.ConnectionFactoryType;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;
import org.fabric3.binding.jms.spi.runtime.factory.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.factory.FactoryRegistrationException;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class ConnectionFactoryParser {
    private List<ConnectionFactoryConfiguration> configurations = new ArrayList<ConnectionFactoryConfiguration>();
    private ConnectionFactoryManager manager;

    public ConnectionFactoryParser(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Property
    public void setConnectionFactories(XMLStreamReader reader) throws XMLStreamException, InvalidConfigurationException {
        reader.nextTag();
        ConnectionFactoryConfiguration configuration = null;
        block7: while (true) {
            switch (reader.next()) {
                case 1: {
                    if ("connection.factory".equals(reader.getName().getLocalPart())) {
                        String name;
                        configuration = new ConnectionFactoryConfiguration();
                        String typeString = reader.getAttributeValue(null, "type");
                        if (typeString != null) {
                            ConnectionFactoryType type = ConnectionFactoryType.valueOf(typeString.trim().toUpperCase());
                            configuration.setType(type);
                        }
                        if ((name = reader.getAttributeValue(null, "name")) == null) {
                            this.invalidConfiguration("Connection factory name not configured", reader, null);
                        }
                        configuration.setName(name);
                        String urlString = reader.getAttributeValue(null, "broker.url");
                        if (urlString == null) {
                            urlString = "vm://DefaultBroker";
                        }
                        try {
                            URI uri = new URI(urlString);
                            configuration.setBrokerUri(uri);
                        }
                        catch (URISyntaxException e) {
                            this.invalidConfiguration("Invalid broker URL", reader, e);
                        }
                        continue block7;
                    }
                    if (configuration == null) break;
                    String name = reader.getName().getLocalPart();
                    if ("factory.properties".equals(name)) {
                        this.parseFactoryProperties(configuration, reader);
                        break;
                    }
                    if ("pool.properties".equals(name)) {
                        this.parsePoolProperties(configuration, reader);
                        break;
                    }
                    this.invalidConfiguration("Unrecognized element " + name + " in system configuration", reader, null);
                    break;
                }
                case 2: {
                    if ("connection.factory".equals(reader.getName().getLocalPart())) {
                        this.configurations.add(configuration);
                        break;
                    }
                }
                case 8: {
                    return;
                }
            }
        }
    }

    @Init
    public void init() throws FactoryRegistrationException {
        for (ConnectionFactoryConfiguration configuration : this.configurations) {
            URI uri = configuration.getBrokerUri();
            String name = configuration.getName();
            switch (configuration.getType()) {
                case LOCAL: {
                    ActiveMQConnectionFactory defaultFactory = new ActiveMQConnectionFactory(uri);
                    defaultFactory.setProperties(configuration.getFactoryProperties());
                    this.manager.register(name, (ConnectionFactory)defaultFactory, configuration.getPoolProperties());
                    break;
                }
                case POOLED: {
                    throw new UnsupportedOperationException();
                }
                case XA: {
                    ActiveMQXAConnectionFactory xaFactory = new ActiveMQXAConnectionFactory(uri);
                    xaFactory.setProperties(configuration.getFactoryProperties());
                    this.manager.register(name, (ConnectionFactory)xaFactory, configuration.getPoolProperties());
                }
            }
        }
    }

    @Destroy
    public void destroy() {
        for (ConnectionFactoryConfiguration configuration : this.configurations) {
            this.manager.unregister(configuration.getName());
        }
    }

    private void parseFactoryProperties(ConnectionFactoryConfiguration configuration, XMLStreamReader reader) throws XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    configuration.setFactoryProperty(reader.getName().getLocalPart(), reader.getElementText());
                    break;
                }
                case 2: {
                    if (!"factory.properties".equals(reader.getName().getLocalPart())) break;
                    return;
                }
                case 8: {
                    return;
                }
            }
        }
    }

    private void parsePoolProperties(ConnectionFactoryConfiguration configuration, XMLStreamReader reader) throws XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    configuration.setPoolProperty(reader.getName().getLocalPart(), reader.getElementText());
                    break;
                }
                case 2: {
                    if (!"pool.properties".equals(reader.getName().getLocalPart())) break;
                    return;
                }
                case 8: {
                    return;
                }
            }
        }
    }

    private void invalidConfiguration(String message, XMLStreamReader reader, Exception e) throws InvalidConfigurationException {
        Location location = reader.getLocation();
        if (location == null) {
            if (e != null) {
                throw new InvalidConfigurationException(message, e);
            }
            throw new InvalidConfigurationException(message);
        }
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        if (e != null) {
            throw new InvalidConfigurationException(message + " [" + line + "," + col + "]", e);
        }
        throw new InvalidConfigurationException(message + " [" + line + "," + col + "]");
    }
}

