/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.factory;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.fabric3.binding.activemq.factory.ConnectionFactoryConfiguration;
import org.fabric3.binding.activemq.factory.ConnectionFactoryConfigurationParser;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.FactoryRegistrationException;
import org.fabric3.host.runtime.HostInfo;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ConnectionFactoryInstantiator {
    private ConnectionFactoryManager manager;
    private ConnectionFactoryConfigurationParser parser;
    private String brokerAddress;
    private List<ConnectionFactoryConfiguration> configurations = Collections.emptyList();

    public ConnectionFactoryInstantiator(@Reference ConnectionFactoryManager manager, @Reference HostInfo info) {
        this.manager = manager;
        this.parser = new ConnectionFactoryConfigurationParser();
        this.brokerAddress = "vm://" + info.getRuntimeName().replace(":", ".");
    }

    @Property(required=false)
    public void setConnectionFactories(XMLStreamReader reader) throws XMLStreamException, InvalidConfigurationException {
        this.configurations = this.parser.parse(this.brokerAddress, reader);
    }

    @Init
    public void init() throws FactoryRegistrationException {
        for (ConnectionFactoryConfiguration configuration : this.configurations) {
            URI uri = configuration.getBrokerUri();
            String name = configuration.getName();
            switch (configuration.getType()) {
                case LOCAL: {
                    ActiveMQConnectionFactory wrapped = new ActiveMQConnectionFactory(uri);
                    wrapped.setProperties(configuration.getFactoryProperties());
                    PooledConnectionFactory pooledFactory = new PooledConnectionFactory(wrapped);
                    this.manager.register(name, (ConnectionFactory)pooledFactory, configuration.getPoolProperties());
                    break;
                }
                case XA: {
                    ActiveMQXAConnectionFactory xaFactory = new ActiveMQXAConnectionFactory(uri);
                    xaFactory.setProperties(configuration.getFactoryProperties());
                    this.manager.register(name, (ConnectionFactory)xaFactory, configuration.getPoolProperties());
                }
            }
        }
    }

    @Destroy
    public void destroy() throws FactoryRegistrationException {
        for (ConnectionFactoryConfiguration configuration : this.configurations) {
            this.manager.unregister(configuration.getName());
        }
    }
}

