/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.broker;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import javax.management.MBeanServer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.binding.activemq.broker.BrokerConfiguration;
import org.fabric3.binding.activemq.broker.BrokerParser;
import org.fabric3.binding.activemq.broker.Fabric3ManagementContext;
import org.fabric3.binding.activemq.broker.PersistenceAdapterConfig;
import org.fabric3.binding.activemq.broker.TransportConnectorConfig;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.host.Port;
import org.fabric3.spi.host.PortAllocationException;
import org.fabric3.spi.host.PortAllocator;
import org.fabric3.spi.monitor.MonitorService;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class BrokerEngine {
    private static final int DEFAULT_PORT = 61616;
    private PortAllocator portAllocator;
    private HostInfo info;
    private String brokerName;
    private BrokerService broker;
    private File tempDir;
    private Port selectedPort;
    private int jmsPort = -1;
    private String bindAddress;
    private File dataDir;
    private BrokerConfiguration brokerConfiguration;
    private MonitorLevel monitorLevel = MonitorLevel.WARNING;
    private MonitorService monitorService;
    private MBeanServer mBeanServer;
    private boolean disabled;

    public BrokerEngine(@Reference PortAllocator portAllocator, @Reference HostInfo info) {
        this.portAllocator = portAllocator;
        this.tempDir = new File(info.getTempDir(), "activemq");
        File baseDataDir = info.getDataDir();
        this.dataDir = new File(baseDataDir, "activemq.data");
        this.info = info;
    }

    @Property(required=false)
    public void setMinPort(int minPort) {
        throw new IllegalArgumentException("Port ranges no longer supported via JMS configuration. Use the runtime port.range attribute");
    }

    @Property(required=false)
    public void setMaxPort(int maxPort) {
        throw new IllegalArgumentException("Port ranges no longer supported via JMS configuration. Use the runtime port.range attribute");
    }

    @Property(required=false)
    public void setJmsPort(int port) {
        this.jmsPort = port;
    }

    @Property(required=false)
    public void setMonitorLevel(String monitorLevel) {
        this.monitorLevel = MonitorLevel.valueOf((String)monitorLevel);
    }

    @Property(required=false)
    public void setDefaultBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Property(required=false)
    public void setBrokerConfig(XMLStreamReader reader) throws InvalidConfigurationException, XMLStreamException {
        BrokerParser parser = new BrokerParser();
        this.brokerConfiguration = parser.parse(reader);
    }

    @Property(required=false)
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Reference(required=false)
    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Init
    public void init() throws Exception {
        if (this.disabled) {
            return;
        }
        this.selectPort();
        if (this.bindAddress == null) {
            this.bindAddress = InetAddress.getLocalHost().getHostAddress();
        }
        this.brokerName = this.info.getRuntimeName().replace(":", ".");
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setTmpDataDirectory(this.tempDir);
        this.broker.setDataDirectory(this.dataDir.toString());
        if (this.brokerConfiguration == null) {
            this.broker.setBrokerName(this.brokerName);
            this.createManagementContext(this.brokerName);
            this.selectedPort.bind(Port.TYPE.TCP);
            TransportConnector connector = this.broker.addConnector("tcp://" + this.bindAddress + ":" + this.selectedPort.getNumber());
            String group = this.info.getDomain().getAuthority();
            connector.setDiscoveryUri(URI.create("multicast://default?group=" + group));
            this.broker.addNetworkConnector("multicast://default?group=" + group);
        } else {
            String name = this.brokerConfiguration.getName();
            if (name != null) {
                this.brokerName = name;
                this.broker.setBrokerName(name);
            } else {
                this.broker.setBrokerName(this.brokerName);
            }
            this.createManagementContext(this.brokerName);
            PersistenceAdapterConfig persistenceConfig = this.brokerConfiguration.getPersistenceAdapter();
            if (persistenceConfig != null && PersistenceAdapterConfig.Type.AMQ == persistenceConfig.getType()) {
                AMQPersistenceAdapter adapter = new AMQPersistenceAdapter();
                adapter.setIndexBinSize(persistenceConfig.getIndexBinSize());
                adapter.setCheckpointInterval(persistenceConfig.getCheckpointInterval().longValue());
                adapter.setCleanupInterval(persistenceConfig.getCleanupInterval().longValue());
                adapter.setIndexKeySize(persistenceConfig.getIndexKeySize());
                adapter.setIndexPageSize(persistenceConfig.getIndexPageSize());
                adapter.setSyncOnWrite(persistenceConfig.isSyncOnWrite());
                adapter.setDisableLocking(persistenceConfig.isDisableLocking());
                this.broker.setPersistenceAdapter((PersistenceAdapter)adapter);
            }
            for (URI uri : this.brokerConfiguration.getNetworkConnectorUris()) {
                this.broker.addNetworkConnector(uri);
            }
            for (TransportConnectorConfig config : this.brokerConfiguration.getTransportConnectorConfigs()) {
                URI uri = config.getUri();
                URI discoveryUri = config.getDiscoveryUri();
                TransportConnector connector = this.broker.addConnector(uri);
                connector.setDiscoveryUri(discoveryUri);
            }
        }
        this.broker.start();
    }

    private void createManagementContext(String brokerName) {
        Fabric3ManagementContext context = new Fabric3ManagementContext(brokerName, this.mBeanServer);
        this.broker.setManagementContext((ManagementContext)context);
    }

    @Destroy
    public void destroy() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private void selectPort() throws IOException, PortAllocationException {
        this.selectedPort = this.jmsPort == -1 ? (this.portAllocator.isPoolEnabled() ? this.portAllocator.allocate("JMS", "JMS") : this.portAllocator.reserve("JMS", "JMS", 61616)) : this.portAllocator.reserve("JMS", "JMS", this.jmsPort);
    }
}

