/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.factory;

import java.net.URI;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.fabric3.binding.activemq.factory.ConnectionFactoryConfiguration;
import org.fabric3.binding.activemq.factory.ConnectionFactoryTemplateRegistry;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryCreationException;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryType;
import org.fabric3.binding.jms.spi.runtime.ProviderConnectionFactoryCreator;
import org.fabric3.host.runtime.HostInfo;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class ActiveMQConnectionFactoryCreator
implements ProviderConnectionFactoryCreator {
    private ConnectionFactoryTemplateRegistry registry;
    private URI brokerUri;

    public ActiveMQConnectionFactoryCreator(@Reference ConnectionFactoryTemplateRegistry registry, @Reference HostInfo info) {
        this.registry = registry;
        String brokerName = info.getRuntimeName().replace(":", ".");
        this.brokerUri = URI.create("vm://" + brokerName);
    }

    public ConnectionFactory create(String templateName) throws ConnectionFactoryCreationException {
        ConnectionFactoryConfiguration configuration = this.registry.getTemplate(templateName);
        if (configuration == null) {
            throw new ConnectionFactoryCreationException("Connection factory template not defined for: " + templateName);
        }
        ConnectionFactoryType type = configuration.getType();
        switch (type) {
            case XA: {
                ActiveMQXAConnectionFactory xaFactory = new ActiveMQXAConnectionFactory(this.getUri(configuration));
                xaFactory.setProperties(configuration.getFactoryProperties());
                return xaFactory;
            }
        }
        ActiveMQConnectionFactory wrapped = new ActiveMQConnectionFactory(this.getUri(configuration));
        wrapped.setProperties(configuration.getFactoryProperties());
        return new PooledConnectionFactory(wrapped);
    }

    public void release(ConnectionFactory factory) {
        if (factory instanceof PooledConnectionFactory) {
            PooledConnectionFactory pooled = (PooledConnectionFactory)factory;
            pooled.stop();
        }
    }

    private URI getUri(ConnectionFactoryConfiguration configuration) {
        if (configuration.getBrokerUri() != null) {
            return configuration.getBrokerUri();
        }
        return this.brokerUri;
    }
}

