/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.activemq.factory;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.binding.activemq.factory.ConnectionFactoryConfiguration;
import org.fabric3.binding.activemq.factory.ConnectionFactoryConfigurationParser;
import org.fabric3.binding.activemq.factory.ConnectionFactoryTemplateRegistry;
import org.fabric3.binding.activemq.factory.InvalidConfigurationException;
import org.fabric3.binding.jms.spi.runtime.ConnectionFactoryType;
import org.fabric3.binding.jms.spi.runtime.FactoryRegistrationException;
import org.fabric3.host.runtime.HostInfo;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

@EagerInit
public class ConnectionFactoryTemplateRegistryImpl
implements ConnectionFactoryTemplateRegistry {
    private ConnectionFactoryConfigurationParser parser;
    private String brokerAddress;
    private URI brokerUri;
    private Map<String, ConnectionFactoryConfiguration> templates = new HashMap<String, ConnectionFactoryConfiguration>();

    public ConnectionFactoryTemplateRegistryImpl(@Reference HostInfo info) {
        this.parser = new ConnectionFactoryConfigurationParser();
        this.brokerAddress = "vm://" + info.getRuntimeName().replace(":", ".");
        this.brokerUri = URI.create(this.brokerAddress);
    }

    public ConnectionFactoryConfiguration getTemplate(String name) {
        return this.templates.get(name);
    }

    @Property(required=false)
    public void setConnectionFactoryTemplates(XMLStreamReader reader) throws XMLStreamException, InvalidConfigurationException {
        List<ConnectionFactoryConfiguration> list = this.parser.parse(this.brokerAddress, reader);
        for (ConnectionFactoryConfiguration configuration : list) {
            this.templates.put(configuration.getName(), configuration);
        }
    }

    @Init
    public void init() throws FactoryRegistrationException {
        ConnectionFactoryConfiguration template;
        if (!this.templates.containsKey("default")) {
            template = new ConnectionFactoryConfiguration();
            template.setName("default");
            template.setBrokerUri(this.brokerUri);
            template.setType(ConnectionFactoryType.LOCAL);
            this.templates.put(template.getName(), template);
        }
        if (!this.templates.containsKey("xaDefault")) {
            template = new ConnectionFactoryConfiguration();
            template.setName("xaDefault");
            template.setBrokerUri(this.brokerUri);
            template.setType(ConnectionFactoryType.XA);
            this.templates.put(template.getName(), template);
        }
    }
}

