/*
 * Copyright (C) 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.gmaven.runtime.v1_5.stubgen;

import org.codehaus.gmaven.runtime.support.stubgen.model.ClassDef;
import org.codehaus.gmaven.runtime.support.stubgen.render.Renderer;
import org.codehaus.gmaven.runtime.support.stubgen.render.RendererFactorySupport;
import org.codehaus.gmaven.runtime.support.stubgen.render.RendererSupport;

/**
 * Provides source defintion renderers for Groovy 1.5.
 *
 * @version $Id: RendererFactoryImpl.java 19 2009-07-16 09:40:33Z user57 $
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class RendererFactoryImpl
    extends RendererFactorySupport
{
    protected Renderer createRenderer(final ClassDef def) {
        assert def != null;

        return new RendererImpl(def);
    }

    //
    // RendererImpl
    //

    private class RendererImpl
        extends RendererSupport
    {
        public RendererImpl(final ClassDef def) {
            super(def);
        }
    }
}