/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.v1_7;

import groovy.lang.Binding;
import java.lang.reflect.Field;
import java.util.EventObject;
import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.ComponentSupport;
import org.codehaus.gmaven.feature.support.FeatureSupport;
import org.codehaus.gmaven.runtime.Console;
import org.codehaus.gmaven.runtime.support.util.NoExitSecurityManager;
import org.sonatype.gshell.io.StreamSet;

public class ConsoleFeature
extends FeatureSupport {
    public ConsoleFeature() {
        super(Console.KEY);
    }

    protected Component doCreate() throws Exception {
        return new ConsoleImpl();
    }

    private class ConsoleImpl
    extends ComponentSupport
    implements Console {
        private final Object lock;

        private ConsoleImpl() throws Exception {
            super((Feature)ConsoleFeature.this);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ClassLoader classLoader) throws Exception {
            assert (classLoader != null);
            StreamSet streams = StreamSet.system();
            SecurityManager sm = System.getSecurityManager();
            System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
            try {
                groovy.ui.Console console = new groovy.ui.Console(classLoader, new Binding()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void exit(EventObject event) {
                        try {
                            super.exit(event);
                        }
                        finally {
                            Object object = ConsoleImpl.this.lock;
                            synchronized (object) {
                                ConsoleImpl.this.lock.notifyAll();
                            }
                        }
                    }

                    public boolean isScriptRunning() {
                        try {
                            Field scriptRunningField = groovy.ui.Console.class.getDeclaredField("scriptRunning");
                            scriptRunningField.setAccessible(true);
                            return (Boolean)scriptRunningField.get((Object)this);
                        }
                        catch (NoSuchFieldException e) {
                            ConsoleImpl.this.log.error("Unable to get field scriptRunning.  Defaulted to false.");
                            return false;
                        }
                        catch (IllegalAccessException e) {
                            ConsoleImpl.this.log.error("Unable to get field scriptRunning.  Defaulted to false.");
                            return false;
                        }
                    }

                    public void setScriptRunning(boolean scriptRunning) {
                        try {
                            Field scriptRunningField = groovy.ui.Console.class.getDeclaredField("scriptRunning");
                            scriptRunningField.setAccessible(true);
                            scriptRunningField.set((Object)this, scriptRunning);
                        }
                        catch (NoSuchFieldException e) {
                            ConsoleImpl.this.log.error("Unable to set field scriptRunning.");
                        }
                        catch (IllegalAccessException e) {
                            ConsoleImpl.this.log.error("Unable to set field scriptRunning.");
                        }
                    }
                };
                console.run();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            finally {
                System.setSecurityManager(sm);
                StreamSet.system((StreamSet)streams);
            }
        }
    }
}

