/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.loader.artifact;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.codehaus.gmaven.feature.Provider;
import org.codehaus.gmaven.feature.ProviderLoader;
import org.codehaus.gmaven.runtime.loader.artifact.ArtifactHandler;
import org.codehaus.gmaven.runtime.loader.realm.RealmManager;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactProviderLoader
implements ProviderLoader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RealmManager realmManager;
    private ArtifactHandler handler;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArtifactHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ArtifactHandler handler) {
        this.handler = handler;
    }

    public Map load(String key) throws Exception {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (this.handler == null) {
            this.log.error("Artifact handler has not been configured; unable to load anything");
            return null;
        }
        Provider provider = this.loadProvider(key);
        HashMap<String, Provider> providers = new HashMap<String, Provider>();
        providers.put(provider.key(), provider);
        return providers;
    }

    private URL[] buildClassPath(Artifact query) throws Exception {
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        Artifact artifact = this.handler.createDependency(query);
        ArtifactResolutionResult result = this.handler.resolve(artifact, (ArtifactFilter)new ScopeArtifactFilter("runtime"));
        ArrayList<URL> classPath = new ArrayList<URL>();
        Iterator iter = result.getArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact element = (Artifact)iter.next();
            File file = element.getFile();
            URL url = file.toURI().toURL();
            classPath.add(url);
        }
        return classPath.toArray(new URL[classPath.size()]);
    }

    private Provider loadProvider(String key) throws Exception {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        this.log.debug("Loading providers: {}", (Object)key);
        Artifact query = this.handler.createQuery(key);
        URL[] classPath = this.buildClassPath(query);
        ClassLoader parent = this.getClass().getClassLoader();
        ClassRealm realm = this.realmManager.createProviderRealm(key, classPath, parent);
        Class type = realm.loadClass("org.codehaus.gmaven.runtime.v" + key.replace('.', '_').replace('-', '_') + ".ProviderImpl");
        return (Provider)type.newInstance();
    }

    static {
        $assertionsDisabled = !ArtifactProviderLoader.class.desiredAssertionStatus();
    }
}

