/*
 * Copyright (C) 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.gmaven.runtime.support.stubgen.model;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * Representation of Javadoc definition.
 *
 * @version $Id: JavaDocDef.java 18 2009-07-16 09:39:40Z user57 $
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class JavaDocDef
    extends Element
{
    private String comment;

    private final Set tags = new LinkedHashSet();

    public JavaDocDef() {}

    public JavaDocDef(final String comment) {
        setComment(comment);
    }
    
    public String getComment() {
        return comment;
    }

    public void setComment(final String comment) {
        this.comment = comment;
    }

    public void addTag(final TagDef tag) {
        assert tag != null;

        tags.add(tag);
    }

    public Set getTags() {
        return tags;
    }
}