/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.mojo.ExecuteMojo;
import org.codehaus.gmavenplus.util.NoExitSecurityManager;
import org.codehaus.gmavenplus.util.ReflectionUtils;

@Mojo(name="console", requiresDependencyResolution=ResolutionScope.TEST)
public class ConsoleMojo
extends AbstractToolsMojo {
    @Parameter(property="consoleScript")
    protected String consoleScript;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setupClassWrangler(this.project.getTestClasspathElements(), this.includeClasspath);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to add project test dependencies to classpath.", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Test dependencies weren't resolved.", (Exception)((Object)e));
        }
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        try {
            this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().debug((CharSequence)"Unable to log project test classpath");
        }
        if (!this.groovyVersionSupportsAction()) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support running a console. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping console startup."));
            return;
        }
        SecurityManager defaultSecurityManager = System.getSecurityManager();
        try {
            Class<?> consoleClass;
            if (!this.allowSystemExits) {
                this.getLog().warn((CharSequence)"JEP 411 deprecated Security Manager in Java 17 for removal. Therefore `allowSystemExits` is also deprecated for removal.");
                try {
                    System.setSecurityManager(new NoExitSecurityManager());
                }
                catch (UnsupportedOperationException e) {
                    this.getLog().warn((CharSequence)"Attempted to use Security Manager in a JVM where it's disabled by default. You might try `-Djava.security.manager=allow` to override this.");
                }
            }
            try {
                consoleClass = this.classWrangler.getClass("groovy.console.ui.Console");
            }
            catch (ClassNotFoundException e) {
                consoleClass = this.classWrangler.getClass("groovy.ui.Console");
            }
            Class<?> bindingClass = this.classWrangler.getClass("groovy.lang.Binding");
            Object console = this.setupConsole(consoleClass, bindingClass);
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(consoleClass, "run", new Class[0]), console, new Object[0]);
            this.bindAntBuilder(consoleClass, bindingClass, console);
            this.loadScript(consoleClass, console);
            this.waitForConsoleClose();
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to get a Groovy class from classpath (" + e.getMessage() + "). Do you have Groovy as a compile dependency in your project or the plugin?", (Exception)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof NoClassDefFoundError && "org/apache/ivy/core/report/ResolveReport".equals(e.getCause().getMessage())) {
                throw new MojoExecutionException("Groovy 1.7.6 and 1.7.7 have a dependency on Ivy to run the console. Either change your Groovy version or add Ivy as a project or plugin dependency.", (Exception)e);
            }
            throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
        }
        finally {
            if (!this.allowSystemExits) {
                try {
                    System.setSecurityManager(defaultSecurityManager);
                }
                catch (UnsupportedOperationException e) {
                    this.getLog().warn((CharSequence)"Attempted to use Security Manager in a JVM where it's disabled by default. You might try `-Djava.security.manager=allow` to override this.");
                }
            }
        }
    }

    protected void loadScript(Class<?> consoleClass, Object console) throws InvocationTargetException, IllegalAccessException {
        if (this.consoleScript != null) {
            Method loadScriptFile = ReflectionUtils.findMethod(consoleClass, "loadScriptFile", File.class);
            File consoleScriptFile = new File(this.consoleScript);
            if (consoleScriptFile.isFile()) {
                ReflectionUtils.invokeMethod(loadScriptFile, console, consoleScriptFile);
            } else if (this.project.getProperties().containsKey(this.consoleScript)) {
                consoleScriptFile = new File(this.project.getProperties().getProperty(this.consoleScript));
                if (consoleScriptFile.isFile()) {
                    ReflectionUtils.invokeMethod(loadScriptFile, console, consoleScriptFile);
                } else {
                    this.getLog().warn((CharSequence)("consoleScript ('" + this.consoleScript + "') doesn't exist in project properties or as a file."));
                }
            } else {
                this.getLog().warn((CharSequence)("consoleScript ('" + this.consoleScript + "') doesn't exist in project properties or as a file."));
            }
        }
    }

    protected Object setupConsole(Class<?> consoleClass, Class<?> bindingClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
        this.initializeProperties();
        Method setVariable = ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class);
        if (this.bindPropertiesToSeparateVariables) {
            for (Object k : this.properties.keySet()) {
                ReflectionUtils.invokeMethod(setVariable, binding, k, this.properties.get(k));
            }
        } else if (this.groovyOlderThan(ExecuteMojo.GROOVY_4_0_0_RC_1)) {
            ReflectionUtils.invokeMethod(setVariable, binding, "properties", this.properties);
        } else {
            throw new IllegalArgumentException("properties is a read-only property in Groovy " + ExecuteMojo.GROOVY_4_0_0_RC_1 + " and later.");
        }
        return ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(consoleClass, ClassLoader.class, bindingClass), this.classWrangler.getClassLoader(), binding);
    }

    protected void bindAntBuilder(Class<?> consoleClass, Class<?> bindingClass, Object console) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        if (this.properties.containsKey("ant")) {
            Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
            Object shell = ReflectionUtils.getField(ReflectionUtils.findField(consoleClass, "shell", groovyShellClass), console);
            Object binding = ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "getContext", new Class[0]), shell, new Object[0]);
            Object antBuilder = null;
            try {
                antBuilder = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(this.classWrangler.getClass("groovy.ant.AntBuilder"), new Class[0]), new Object[0]);
            }
            catch (ClassNotFoundException e1) {
                this.getLog().debug((CharSequence)"groovy.ant.AntBuilder not available, trying groovy.util.AntBuilder.");
                try {
                    antBuilder = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(this.classWrangler.getClass("groovy.util.AntBuilder"), new Class[0]), new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e2) {
                    this.logUnableToInitializeAntBuilder(e2);
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.logUnableToInitializeAntBuilder(e);
            }
            if (antBuilder != null) {
                if (this.bindPropertiesToSeparateVariables) {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "ant", antBuilder);
                } else {
                    this.properties.put("ant", antBuilder);
                }
            }
        }
    }

    protected void waitForConsoleClose() throws MojoFailureException {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[0]);
        Thread consoleThread = null;
        for (Thread thread : threadArray) {
            if (!"AWT-Shutdown".equals(thread.getName())) continue;
            consoleThread = thread;
            break;
        }
        if (consoleThread != null) {
            try {
                consoleThread.join();
            }
            catch (InterruptedException e) {
                throw new MojoFailureException("Mojo interrupted while waiting for Console thread to end.", (Throwable)e);
            }
        } else {
            throw new MojoFailureException("Unable to locate Console thread to wait on.");
        }
    }
}

