/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticTypeCheckingSupport {
    protected static final ClassNode Collection_TYPE = ClassHelper.makeWithoutCaching(Collection.class);
    protected static final ClassNode Deprecated_TYPE = ClassHelper.makeWithoutCaching(Deprecated.class);
    protected static final ClassNode Matcher_TYPE = ClassHelper.makeWithoutCaching(Matcher.class);
    protected static final ClassNode ArrayList_TYPE = ClassHelper.makeWithoutCaching(ArrayList.class);
    protected static final ExtensionMethodCache EXTENSION_METHOD_CACHE = new ExtensionMethodCache();
    protected static final Map<ClassNode, Integer> NUMBER_TYPES = Collections.unmodifiableMap(new HashMap<ClassNode, Integer>(){
        {
            this.put(ClassHelper.byte_TYPE, 0);
            this.put(ClassHelper.Byte_TYPE, 0);
            this.put(ClassHelper.short_TYPE, 1);
            this.put(ClassHelper.Short_TYPE, 1);
            this.put(ClassHelper.int_TYPE, 2);
            this.put(ClassHelper.Integer_TYPE, 2);
            this.put(ClassHelper.Long_TYPE, 3);
            this.put(ClassHelper.long_TYPE, 3);
            this.put(ClassHelper.float_TYPE, 4);
            this.put(ClassHelper.Float_TYPE, 4);
            this.put(ClassHelper.double_TYPE, 5);
            this.put(ClassHelper.Double_TYPE, 5);
        }
    });
    protected static final ClassNode GSTRING_STRING_CLASSNODE = WideningCategories.lowestUpperBound(ClassHelper.STRING_TYPE, ClassHelper.GSTRING_TYPE);
    protected static final ClassNode UNKNOWN_PARAMETER_TYPE = ClassHelper.make("<unknown parameter type>");
    protected static final Comparator<MethodNode> DGM_METHOD_NODE_COMPARATOR = new Comparator<MethodNode>(){

        @Override
        public int compare(MethodNode o1, MethodNode o2) {
            if (o1.getName().equals(o2.getName())) {
                Parameter[] o2ps;
                Parameter[] o1ps = o1.getParameters();
                if (o1ps.length == (o2ps = o2.getParameters()).length) {
                    boolean allEqual = true;
                    int i = 0;
                    while (i < o1ps.length && allEqual) {
                        allEqual = o1ps[i].getType().equals(o2ps[i].getType());
                        ++i;
                    }
                    if (allEqual) {
                        if (o1 instanceof ExtensionMethodNode && o2 instanceof ExtensionMethodNode) {
                            return this.compare(((ExtensionMethodNode)o1).getExtensionMethodNode(), ((ExtensionMethodNode)o2).getExtensionMethodNode());
                        }
                        return 0;
                    }
                } else {
                    return o1ps.length - o2ps.length;
                }
            }
            return 1;
        }
    };

    protected static boolean isArrayAccessExpression(Expression expression) {
        return expression instanceof BinaryExpression && StaticTypeCheckingSupport.isArrayOp(((BinaryExpression)expression).getOperation().getType());
    }

    public static boolean isWithCall(String name, Expression callArguments) {
        boolean isWithCall;
        boolean bl = isWithCall = "with".equals(name) && callArguments instanceof ArgumentListExpression;
        if (isWithCall) {
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            List<Expression> expressions = argList.getExpressions();
            isWithCall = expressions.size() == 1 && expressions.get(0) instanceof ClosureExpression;
        }
        return isWithCall;
    }

    protected static Variable findTargetVariable(VariableExpression ve) {
        Variable accessedVariable;
        Variable variable = accessedVariable = ve.getAccessedVariable() != null ? ve.getAccessedVariable() : ve;
        if (accessedVariable != ve && accessedVariable instanceof VariableExpression) {
            return StaticTypeCheckingSupport.findTargetVariable(accessedVariable);
        }
        return accessedVariable;
    }

    protected static Set<MethodNode> findDGMMethodsForClassNode(ClassNode clazz, String name) {
        TreeSet<MethodNode> accumulator = new TreeSet<MethodNode>(DGM_METHOD_NODE_COMPARATOR);
        StaticTypeCheckingSupport.findDGMMethodsForClassNode(clazz, name, accumulator);
        return accumulator;
    }

    protected static void findDGMMethodsForClassNode(ClassNode clazz, String name, TreeSet<MethodNode> accumulator) {
        ClassNode componentClass;
        List<MethodNode> fromDGM = EXTENSION_METHOD_CACHE.getExtensionMethods().get(clazz.getName());
        if (fromDGM != null) {
            for (AnnotatedNode node : fromDGM) {
                if (!node.getName().equals(name)) continue;
                accumulator.add((MethodNode)node);
            }
        }
        ClassNode[] classNodeArray = clazz.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotatedNode node;
            node = classNodeArray[n2];
            StaticTypeCheckingSupport.findDGMMethodsForClassNode((ClassNode)node, name, accumulator);
            ++n2;
        }
        if (clazz.isArray() && !(componentClass = clazz.getComponentType()).equals(ClassHelper.OBJECT_TYPE)) {
            if (componentClass.isInterface() || componentClass.getSuperClass() == null) {
                StaticTypeCheckingSupport.findDGMMethodsForClassNode(ClassHelper.OBJECT_TYPE.makeArray(), name, accumulator);
            } else {
                StaticTypeCheckingSupport.findDGMMethodsForClassNode(componentClass.getSuperClass().makeArray(), name, accumulator);
            }
        }
        if (clazz.getSuperClass() != null) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(clazz.getSuperClass(), name, accumulator);
        } else if (!clazz.equals(ClassHelper.OBJECT_TYPE)) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(ClassHelper.OBJECT_TYPE, name, accumulator);
        }
    }

    public static int allParametersAndArgumentsMatch(Parameter[] params, ClassNode[] args) {
        if (params == null) {
            params = Parameter.EMPTY_ARRAY;
        }
        int dist = 0;
        if (args.length < params.length) {
            return -1;
        }
        int i = 0;
        while (i < params.length) {
            ClassNode argType = args[i];
            ClassNode paramType = params[i].getType();
            if (!StaticTypeCheckingSupport.isAssignableTo(argType, paramType)) {
                return -1;
            }
            if (!paramType.equals(argType)) {
                dist += StaticTypeCheckingSupport.getDistance(argType, paramType);
            }
            ++i;
        }
        return dist;
    }

    static int allParametersAndArgumentsMatchWithDefaultParams(Parameter[] params, ClassNode[] args) {
        int dist = 0;
        ClassNode ptype = null;
        int i = 0;
        int j = 0;
        while (i < params.length) {
            ClassNode arg;
            Parameter param = params[i];
            ClassNode paramType = param.getType();
            ClassNode classNode = arg = j >= args.length ? null : args[j];
            if (arg == null || !StaticTypeCheckingSupport.isAssignableTo(arg, paramType)) {
                if (!(param.hasInitialExpression() || ptype != null && ptype.equals(paramType))) {
                    return -1;
                }
                ptype = null;
            } else {
                ++j;
                if (!paramType.equals(arg)) {
                    dist += StaticTypeCheckingSupport.getDistance(arg, paramType);
                }
                ptype = param.hasInitialExpression() ? arg : null;
            }
            ++i;
        }
        return dist;
    }

    static int excessArgumentsMatchesVargsParameter(Parameter[] params, ClassNode[] args) {
        int dist = 0;
        ClassNode vargsBase = params[params.length - 1].getType().getComponentType();
        int i = params.length;
        while (i < args.length) {
            if (!StaticTypeCheckingSupport.isAssignableTo(args[i], vargsBase)) {
                return -1;
            }
            if (!args[i].equals(vargsBase)) {
                dist += StaticTypeCheckingSupport.getDistance(args[i], vargsBase);
            }
            ++i;
        }
        return dist;
    }

    static int lastArgMatchesVarg(Parameter[] params, ClassNode ... args) {
        if (!StaticTypeCheckingSupport.isVargs(params)) {
            return -1;
        }
        ClassNode ptype = params[params.length - 1].getType().getComponentType();
        ClassNode arg = args[args.length - 1];
        if (ClassHelper.isNumberType(ptype) && ClassHelper.isNumberType(arg) && !ptype.equals(arg)) {
            return -1;
        }
        return StaticTypeCheckingSupport.isAssignableTo(arg, ptype) ? StaticTypeCheckingSupport.getDistance(arg, ptype) : -1;
    }

    static boolean isAssignableTo(ClassNode type, ClassNode toBeAssignedTo) {
        if (UNKNOWN_PARAMETER_TYPE == type) {
            return true;
        }
        if (type == toBeAssignedTo) {
            return true;
        }
        if (toBeAssignedTo.redirect() == ClassHelper.STRING_TYPE && type.redirect() == ClassHelper.GSTRING_TYPE) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(toBeAssignedTo)) {
            toBeAssignedTo = ClassHelper.getWrapper(toBeAssignedTo);
        }
        if (ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getWrapper(type);
        }
        if (ClassHelper.Double_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE);
        }
        if (ClassHelper.Float_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect();
        }
        if (ClassHelper.Long_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect() && ClassHelper.Float_TYPE != type.redirect();
        }
        if (ClassHelper.Integer_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect() && ClassHelper.Float_TYPE != type.redirect() && ClassHelper.Long_TYPE != type.redirect();
        }
        if (ClassHelper.Short_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect() && ClassHelper.Float_TYPE != type.redirect() && ClassHelper.Long_TYPE != type.redirect() && ClassHelper.Integer_TYPE != type.redirect();
        }
        if (ClassHelper.Byte_TYPE == toBeAssignedTo) {
            return type.redirect() == ClassHelper.Byte_TYPE;
        }
        if (type.isArray() && toBeAssignedTo.isArray()) {
            return StaticTypeCheckingSupport.isAssignableTo(type.getComponentType(), toBeAssignedTo.getComponentType());
        }
        if (type.isDerivedFrom(ClassHelper.GSTRING_TYPE) && ClassHelper.STRING_TYPE.equals(toBeAssignedTo)) {
            return true;
        }
        if (toBeAssignedTo.isDerivedFrom(ClassHelper.GSTRING_TYPE) && ClassHelper.STRING_TYPE.equals(type)) {
            return true;
        }
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, toBeAssignedTo)) {
            if (ClassHelper.OBJECT_TYPE.equals(toBeAssignedTo)) {
                return true;
            }
            if (toBeAssignedTo.isUsingGenerics()) {
                GenericsType gt = GenericsUtils.buildWildcardType(toBeAssignedTo);
                return gt.isCompatibleWith(type);
            }
            return true;
        }
        return false;
    }

    static boolean isVargs(Parameter[] params) {
        if (params.length == 0) {
            return false;
        }
        return params[params.length - 1].getType().isArray();
    }

    static boolean isCompareToBoolean(int op) {
        return op == 126 || op == 127 || op == 124 || op == 125;
    }

    static boolean isArrayOp(int op) {
        return op == 30;
    }

    static boolean isBoolIntrinsicOp(int op) {
        return op == 164 || op == 162 || op == 94 || op == 544;
    }

    static boolean isPowerOperator(int op) {
        return op == 206 || op == 216;
    }

    static String getOperationName(int op) {
        switch (op) {
            case 120: 
            case 123: {
                return "equals";
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return "compareTo";
            }
            case 341: 
            case 351: {
                return "and";
            }
            case 340: 
            case 350: {
                return "or";
            }
            case 342: 
            case 352: {
                return "xor";
            }
            case 200: 
            case 210: {
                return "plus";
            }
            case 201: 
            case 211: {
                return "minus";
            }
            case 202: 
            case 212: {
                return "multiply";
            }
            case 203: 
            case 213: {
                return "div";
            }
            case 204: 
            case 214: {
                return "intdiv";
            }
            case 205: 
            case 215: {
                return "mod";
            }
            case 206: 
            case 216: {
                return "power";
            }
            case 280: 
            case 285: {
                return "leftShift";
            }
            case 281: 
            case 286: {
                return "rightShift";
            }
            case 282: 
            case 287: {
                return "rightShiftUnsigned";
            }
            case 573: {
                return "isCase";
            }
        }
        return null;
    }

    static boolean isShiftOperation(String name) {
        return "leftShift".equals(name) || "rightShift".equals(name) || "rightShiftUnsigned".equals(name);
    }

    static boolean isOperationInGroup(int op) {
        switch (op) {
            case 200: 
            case 201: 
            case 202: 
            case 210: 
            case 211: 
            case 212: {
                return true;
            }
        }
        return false;
    }

    static boolean isBitOperator(int op) {
        switch (op) {
            case 340: 
            case 341: 
            case 342: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignment(int op) {
        switch (op) {
            case 100: 
            case 166: 
            case 168: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 285: 
            case 286: 
            case 287: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right) {
        return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(left, right, null);
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right, Expression rightExpression) {
        boolean rightExpressionIsNull;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        if (right == ClassHelper.VOID_TYPE || right == ClassHelper.void_WRAPPER_TYPE) {
            return left == ClassHelper.VOID_TYPE || left == ClassHelper.void_WRAPPER_TYPE;
        }
        if (ClassHelper.isNumberType(rightRedirect) || WideningCategories.isNumberCategory(rightRedirect)) {
            if (ClassHelper.BigDecimal_TYPE == leftRedirect) {
                return true;
            }
            if (ClassHelper.BigInteger_TYPE == leftRedirect) {
                return WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(rightRedirect));
            }
        }
        boolean bl = rightExpressionIsNull = rightExpression instanceof ConstantExpression && ((ConstantExpression)rightExpression).getValue() == null;
        if (rightExpressionIsNull && !ClassHelper.isPrimitiveType(left)) {
            return true;
        }
        if (StaticTypeCheckingSupport.isWildcardLeftHandSide(leftRedirect)) {
            return true;
        }
        if (leftRedirect == ClassHelper.char_TYPE && rightRedirect == ClassHelper.STRING_TYPE && rightExpression != null && rightExpression instanceof ConstantExpression) {
            String value = rightExpression.getText();
            return value.length() == 1;
        }
        if (leftRedirect == ClassHelper.Character_TYPE && (rightRedirect == ClassHelper.STRING_TYPE || rightExpressionIsNull)) {
            return rightExpressionIsNull || rightExpression instanceof ConstantExpression && rightExpression.getText().length() == 1;
        }
        if (leftRedirect.isDerivedFrom(ClassHelper.Enum_Type) && (rightRedirect == ClassHelper.GSTRING_TYPE || rightRedirect == ClassHelper.STRING_TYPE)) {
            return true;
        }
        if (rightRedirect.implementsInterface(ClassHelper.MAP_TYPE) || rightRedirect.implementsInterface(Collection_TYPE) || rightRedirect.equals(ClassHelper.MAP_TYPE) || rightRedirect.equals(Collection_TYPE) || rightRedirect.isArray()) {
            if (leftRedirect.isArray() && rightRedirect.isArray()) {
                return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect.getComponentType(), rightRedirect.getComponentType());
            }
            return !rightRedirect.isArray() || leftRedirect.isArray();
        }
        if (right.isDerivedFrom(left) || left.isInterface() && right.implementsInterface(left)) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(leftRedirect) && ClassHelper.isPrimitiveType(rightRedirect)) {
            return true;
        }
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            return true;
        }
        if (WideningCategories.isFloatingCategory(leftRedirect) && ClassHelper.BigDecimal_TYPE.equals(rightRedirect)) {
            return true;
        }
        return ClassHelper.GROOVY_OBJECT_TYPE.equals(leftRedirect) && StaticTypeCheckingSupport.isBeingCompiled(right);
    }

    public static boolean isWildcardLeftHandSide(ClassNode node) {
        return node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.STRING_TYPE) || node.equals(ClassHelper.boolean_TYPE) || node.equals(ClassHelper.Boolean_TYPE) || node.equals(ClassHelper.CLASS_Type);
    }

    public static boolean isBeingCompiled(ClassNode node) {
        return node.getCompileUnit() != null;
    }

    static boolean checkPossibleLooseOfPrecision(ClassNode left, ClassNode right, Expression rightExpr) {
        int rightIndex;
        if (left == right || left.equals(right)) {
            return false;
        }
        int leftIndex = NUMBER_TYPES.get(left);
        if (leftIndex >= (rightIndex = NUMBER_TYPES.get(right).intValue())) {
            return false;
        }
        if (rightExpr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)rightExpr).getValue();
            if (!(value instanceof Number)) {
                return true;
            }
            Number number = (Number)value;
            switch (leftIndex) {
                case 0: {
                    byte val = number.byteValue();
                    if (number instanceof Short) {
                        return !Short.valueOf(val).equals(number);
                    }
                    if (number instanceof Integer) {
                        return !Integer.valueOf(val).equals(number);
                    }
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 1: {
                    short val = number.shortValue();
                    if (number instanceof Integer) {
                        return !Integer.valueOf(val).equals(number);
                    }
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 2: {
                    int val = number.intValue();
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 3: {
                    long val = number.longValue();
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 4: {
                    float val = number.floatValue();
                    return !Double.valueOf(val).equals(number);
                }
            }
            return false;
        }
        return true;
    }

    static String toMethodParametersString(String methodName, ClassNode ... parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append("(");
        if (parameters != null) {
            int i = 0;
            int parametersLength = parameters.length;
            while (i < parametersLength) {
                ClassNode parameter = parameters[i];
                sb.append(StaticTypeCheckingSupport.prettyPrintType(parameter));
                if (i < parametersLength - 1) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    static String prettyPrintType(ClassNode type) {
        if (type.isArray()) {
            return String.valueOf(StaticTypeCheckingSupport.prettyPrintType(type.getComponentType())) + "[]";
        }
        return type.toString(false);
    }

    public static boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
        boolean result;
        boolean bl = result = type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface) || type == UNKNOWN_PARAMETER_TYPE;
        if (result) {
            return true;
        }
        if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
            WideningCategories.LowestUpperBoundClassNode cn = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
            result = StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, cn.getSuperClass());
            if (result) {
                ClassNode[] classNodeArray = cn.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode interfaceNode = classNodeArray[n2];
                    result = type.implementsInterface(interfaceNode);
                    if (!result) break;
                    ++n2;
                }
            }
            if (result) {
                return true;
            }
        } else if (superOrInterface instanceof UnionTypeClassNode) {
            UnionTypeClassNode union = (UnionTypeClassNode)superOrInterface;
            ClassNode[] classNodeArray = union.getDelegates();
            int n = classNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                ClassNode delegate = classNodeArray[n3];
                if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, delegate)) {
                    return true;
                }
                ++n3;
            }
        }
        if (type.isArray() && superOrInterface.isArray()) {
            return StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
        }
        return ClassHelper.GROOVY_OBJECT_TYPE.equals(superOrInterface) && !type.isInterface() && StaticTypeCheckingSupport.isBeingCompiled(type);
    }

    static int getPrimitiveDistance(ClassNode primA, ClassNode primB) {
        return Math.abs(NUMBER_TYPES.get(primA) - NUMBER_TYPES.get(primB));
    }

    static int getDistance(ClassNode receiver, ClassNode compare) {
        int dist = 0;
        ClassNode unwrapReceiver = ClassHelper.getUnwrapper(receiver);
        ClassNode unwrapCompare = ClassHelper.getUnwrapper(compare);
        if (ClassHelper.isPrimitiveType(unwrapReceiver) && ClassHelper.isPrimitiveType(unwrapCompare) && unwrapReceiver != unwrapCompare) {
            dist = StaticTypeCheckingSupport.getPrimitiveDistance(unwrapReceiver, unwrapCompare);
        }
        if (ClassHelper.isPrimitiveType(receiver) && !ClassHelper.isPrimitiveType(compare)) {
            dist = dist + 1 << 1;
        }
        if (unwrapCompare.equals(unwrapReceiver)) {
            return dist;
        }
        if (receiver.isArray() && !compare.isArray()) {
            dist += 256;
        }
        if (receiver == UNKNOWN_PARAMETER_TYPE) {
            return dist;
        }
        ClassNode ref = receiver;
        while (ref != null) {
            if (compare.equals(ref)) break;
            if (compare.isInterface() && ref.implementsInterface(compare)) {
                dist += StaticTypeCheckingSupport.getMaximumInterfaceDistance(ref, compare);
                break;
            }
            if ((ref = ref.getSuperClass()) == null) {
                dist += 2;
            }
            dist = dist + 1 << 1;
        }
        return dist;
    }

    private static int getMaximumInterfaceDistance(ClassNode c, ClassNode interfaceClass) {
        if (c == null) {
            return -1;
        }
        if (c.equals(interfaceClass)) {
            return 0;
        }
        ClassNode[] interfaces = c.getInterfaces();
        int max = -1;
        ClassNode[] classNodeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode anInterface = classNodeArray[n2];
            int sub = StaticTypeCheckingSupport.getMaximumInterfaceDistance(anInterface, interfaceClass);
            if (sub != -1) {
                ++sub;
            }
            max = Math.max(max, sub);
            ++n2;
        }
        int superClassMax = StaticTypeCheckingSupport.getMaximumInterfaceDistance(c.getSuperClass(), interfaceClass);
        return Math.max(max, superClassMax);
    }

    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(receiver, name, args, new LinkedList<MethodNode>());
    }

    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args, List<MethodNode> methods) {
        methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(receiver, name));
        List<MethodNode> chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods, args);
        Iterator<MethodNode> iterator = chosen.iterator();
        while (iterator.hasNext()) {
            Parameter[] parameters;
            ClassNode dgmOwnerType;
            ExtensionMethodNode emn = (ExtensionMethodNode)iterator.next();
            MethodNode dgmMethod = emn.getExtensionMethodNode();
            GenericsType[] methodGenericTypes = dgmMethod.getGenericsTypes();
            if (methodGenericTypes == null || methodGenericTypes.length <= 0 || !(dgmOwnerType = (parameters = dgmMethod.getParameters())[0].getOriginType()).isGenericsPlaceHolder() && (!dgmOwnerType.isArray() || !dgmOwnerType.getComponentType().isGenericsPlaceHolder())) continue;
            ClassNode receiverBase = receiver.isArray() ? receiver.getComponentType() : receiver;
            ClassNode receiverBaseRedirect = dgmOwnerType.isArray() ? dgmOwnerType.getComponentType() : dgmOwnerType;
            boolean mismatch = false;
            int i = 1;
            while (i < parameters.length && !mismatch) {
                int k = i - 1;
                ClassNode type = parameters[i].getOriginType();
                if (StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(type)) {
                    int j;
                    String receiverPlaceholder = receiverBaseRedirect.getGenericsTypes()[0].getName();
                    ClassNode parameterBaseType = args[k].isArray() ? args[k].getComponentType() : args[k];
                    ClassNode parameterBaseTypeRedirect = type.isArray() ? type.getComponentType() : type;
                    GenericsType[] paramRedirectGenericsTypes = parameterBaseTypeRedirect.getGenericsTypes();
                    Object[] paramGenericTypes = parameterBaseType.getGenericsTypes();
                    if (paramGenericTypes == null) {
                        paramGenericTypes = new GenericsType[paramRedirectGenericsTypes.length];
                        Arrays.fill(paramGenericTypes, new GenericsType(ClassHelper.OBJECT_TYPE));
                    } else {
                        j = 0;
                        while (j < paramGenericTypes.length) {
                            Object paramGenericType = paramGenericTypes[j];
                            if (((GenericsType)paramGenericType).isWildcard() || ((GenericsType)paramGenericType).isPlaceholder()) {
                                paramGenericTypes[j] = new GenericsType(ClassHelper.OBJECT_TYPE);
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    int genericsTypesLength = paramRedirectGenericsTypes.length;
                    while (j < genericsTypesLength && !mismatch) {
                        GenericsType gt = paramRedirectGenericsTypes[j];
                        if (gt.isPlaceholder()) {
                            LinkedList<GenericsType> fromMethodGenerics = new LinkedList<GenericsType>();
                            GenericsType[] genericsTypeArray = methodGenericTypes;
                            int n = methodGenericTypes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GenericsType methodGenericType = genericsTypeArray[n2];
                                if (methodGenericType.getName().equals(gt.getName())) {
                                    fromMethodGenerics.add(methodGenericType);
                                    break;
                                }
                                ++n2;
                            }
                            while (!fromMethodGenerics.isEmpty()) {
                                GenericsType test = (GenericsType)fromMethodGenerics.remove(0);
                                if (test.getName().equals(receiverPlaceholder)) {
                                    if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(args[k]), ClassHelper.getWrapper(receiverBase))) continue;
                                    mismatch = true;
                                    break;
                                }
                                if (test.getUpperBounds() == null) continue;
                                ClassNode[] classNodeArray = test.getUpperBounds();
                                int n3 = classNodeArray.length;
                                n = 0;
                                while (n < n3) {
                                    ClassNode classNode = classNodeArray[n];
                                    GenericsType[] genericsTypes = classNode.getGenericsTypes();
                                    if (genericsTypes != null) {
                                        GenericsType[] genericsTypeArray2 = genericsTypes;
                                        int n4 = genericsTypes.length;
                                        int n5 = 0;
                                        while (n5 < n4) {
                                            GenericsType genericsType = genericsTypeArray2[n5];
                                            if (genericsType.isPlaceholder()) {
                                                GenericsType[] genericsTypeArray3 = methodGenericTypes;
                                                int n6 = methodGenericTypes.length;
                                                int n7 = 0;
                                                while (n7 < n6) {
                                                    GenericsType methodGenericType = genericsTypeArray3[n7];
                                                    if (methodGenericType.getName().equals(genericsType.getName())) {
                                                        fromMethodGenerics.add(methodGenericType);
                                                        break;
                                                    }
                                                    ++n7;
                                                }
                                            }
                                            ++n5;
                                        }
                                    }
                                    ++n;
                                }
                            }
                        }
                        ++j;
                    }
                    if (mismatch) {
                        iterator.remove();
                    }
                }
                ++i;
            }
        }
        return chosen;
    }

    public static List<MethodNode> chooseBestMethod(ClassNode receiver, Collection<MethodNode> methods, ClassNode ... args) {
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<MethodNode> bestChoices = new LinkedList<MethodNode>();
        int bestDist = Integer.MAX_VALUE;
        Collection<MethodNode> choicesLeft = StaticTypeCheckingSupport.removeCovariants(methods);
        for (MethodNode m : choicesLeft) {
            ClassNode declaringClass = m.getDeclaringClass();
            ClassNode actualReceiver = receiver != null ? receiver : declaringClass;
            Parameter[] params = StaticTypeCheckingSupport.parameterizeArguments(actualReceiver, m);
            if (params.length == args.length) {
                int dist;
                int lastArgMatch;
                int allPMatch = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(params, args);
                boolean firstParamMatches = true;
                if (args.length > 0) {
                    Parameter[] firstParams = new Parameter[params.length - 1];
                    System.arraycopy(params, 0, firstParams, 0, firstParams.length);
                    firstParamMatches = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(firstParams, args) >= 0;
                }
                int n = lastArgMatch = StaticTypeCheckingSupport.isVargs(params) && firstParamMatches ? StaticTypeCheckingSupport.lastArgMatchesVarg(params, args) : -1;
                if (lastArgMatch >= 0) {
                    lastArgMatch += 256 - params.length;
                }
                int n2 = dist = allPMatch >= 0 ? Math.max(allPMatch, lastArgMatch) : lastArgMatch;
                if (dist >= 0 && !actualReceiver.equals(declaringClass)) {
                    dist += StaticTypeCheckingSupport.getDistance(actualReceiver, declaringClass);
                }
                if (dist >= 0 && dist < bestDist) {
                    bestChoices.clear();
                    bestChoices.add(m);
                    bestDist = dist;
                    continue;
                }
                if (dist < 0 || dist != bestDist) continue;
                bestChoices.add(m);
                continue;
            }
            if (!StaticTypeCheckingSupport.isVargs(params)) continue;
            boolean firstParamMatches = true;
            if (args.length > 0) {
                Parameter[] firstParams = new Parameter[params.length - 1];
                System.arraycopy(params, 0, firstParams, 0, firstParams.length);
                boolean bl = firstParamMatches = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(firstParams, args) >= 0;
            }
            if (!firstParamMatches) continue;
            if (params.length == args.length + 1) {
                if (bestDist <= 1) continue;
                bestChoices.clear();
                bestChoices.add(m);
                bestDist = 1;
                continue;
            }
            int dist = StaticTypeCheckingSupport.excessArgumentsMatchesVargsParameter(params, args);
            if (dist >= 0 && !actualReceiver.equals(declaringClass)) {
                dist += StaticTypeCheckingSupport.getDistance(actualReceiver, declaringClass);
            }
            if (params.length >= args.length || (dist += 256 - params.length) < 0) continue;
            if (dist >= 0 && dist < bestDist) {
                bestChoices.clear();
                bestChoices.add(m);
                bestDist = dist;
                continue;
            }
            if (dist < 0 || dist != bestDist) continue;
            bestChoices.add(m);
        }
        return bestChoices;
    }

    private static Collection<MethodNode> removeCovariants(Collection<MethodNode> collection) {
        if (collection.size() <= 1) {
            return collection;
        }
        LinkedList<MethodNode> toBeRemoved = new LinkedList<MethodNode>();
        LinkedList<MethodNode> list = new LinkedList<MethodNode>(new HashSet<MethodNode>(collection));
        int i = 0;
        while (i < list.size() - 1) {
            MethodNode one = (MethodNode)list.get(i);
            if (!toBeRemoved.contains(one)) {
                int j = i + 1;
                while (j < list.size()) {
                    Parameter[] twoPars;
                    Parameter[] onePars;
                    MethodNode two = (MethodNode)list.get(j);
                    if (!toBeRemoved.contains(two) && one.getName().equals(two.getName()) && one.getDeclaringClass() == two.getDeclaringClass() && (onePars = one.getParameters()).length == (twoPars = two.getParameters()).length) {
                        boolean sameTypes = true;
                        int k = 0;
                        while (k < onePars.length) {
                            Parameter onePar = onePars[k];
                            Parameter twoPar = twoPars[k];
                            if (!onePar.getType().equals(twoPar.getType())) {
                                sameTypes = false;
                                break;
                            }
                            ++k;
                        }
                        if (sameTypes) {
                            ClassNode twoRT;
                            ClassNode oneRT = one.getReturnType();
                            if (oneRT.isDerivedFrom(twoRT = two.getReturnType()) || oneRT.implementsInterface(twoRT)) {
                                toBeRemoved.add(two);
                            } else if (twoRT.isDerivedFrom(oneRT) || twoRT.implementsInterface(oneRT)) {
                                toBeRemoved.add(one);
                            }
                        } else if (one.isSynthetic() && !two.isSynthetic()) {
                            toBeRemoved.add(one);
                        } else if (two.isSynthetic() && !one.isSynthetic()) {
                            toBeRemoved.add(two);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (toBeRemoved.isEmpty()) {
            return list;
        }
        LinkedList<MethodNode> result = new LinkedList<MethodNode>(list);
        result.removeAll(toBeRemoved);
        return result;
    }

    public static Parameter[] parameterizeArguments(ClassNode receiver, MethodNode m) {
        MethodNode mn = m;
        ClassNode actualReceiver = receiver;
        ArrayList redirectTypes = new ArrayList();
        if (actualReceiver.redirect().getGenericsTypes() != null) {
            Collections.addAll(redirectTypes, actualReceiver.redirect().getGenericsTypes());
        }
        if (redirectTypes.isEmpty()) {
            return m.getParameters();
        }
        GenericsType[] redirectReceiverTypes = redirectTypes.toArray(new GenericsType[redirectTypes.size()]);
        Parameter[] methodParameters = mn.getParameters();
        Parameter[] params = new Parameter[methodParameters.length];
        GenericsType[] receiverParameterizedTypes = actualReceiver.getGenericsTypes();
        if (receiverParameterizedTypes == null) {
            receiverParameterizedTypes = redirectReceiverTypes;
        }
        int i = 0;
        while (i < methodParameters.length) {
            Parameter methodParameter = methodParameters[i];
            ClassNode paramType = methodParameter.getType();
            if (paramType.isUsingGenerics()) {
                GenericsType[] alignmentTypes = paramType.getGenericsTypes();
                GenericsType[] genericsTypes = GenericsUtils.alignGenericTypes(redirectReceiverTypes, receiverParameterizedTypes, alignmentTypes);
                if (genericsTypes.length == 1) {
                    ClassNode parameterizedCN;
                    if (paramType.equals(ClassHelper.OBJECT_TYPE)) {
                        parameterizedCN = genericsTypes[0].getType();
                    } else {
                        parameterizedCN = paramType.getPlainNodeReference();
                        parameterizedCN.setGenericsTypes(genericsTypes);
                    }
                    params[i] = new Parameter(parameterizedCN, methodParameter.getName());
                } else {
                    params[i] = methodParameter;
                }
            } else {
                params[i] = methodParameter;
            }
            ++i;
        }
        return params;
    }

    static boolean isUsingGenericsOrIsArrayUsingGenerics(ClassNode cn) {
        return cn.isUsingGenerics() || cn.isArray() && cn.getComponentType().isUsingGenerics();
    }

    public static boolean isGStringOrGStringStringLUB(ClassNode node) {
        return ClassHelper.GSTRING_TYPE.equals(node) || GSTRING_STRING_CLASSNODE.equals(node);
    }

    public static boolean isParameterizedWithGStringOrGStringString(ClassNode node) {
        GenericsType[] genericsTypes;
        if (node.isArray()) {
            return StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(node.getComponentType());
        }
        if (node.isUsingGenerics() && (genericsTypes = node.getGenericsTypes()) != null) {
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (StaticTypeCheckingSupport.isGStringOrGStringStringLUB(genericsType.getType())) {
                    return true;
                }
                ++n2;
            }
        }
        return node.getSuperClass() != null && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(node.getUnresolvedSuperClass());
    }

    public static boolean isParameterizedWithString(ClassNode node) {
        GenericsType[] genericsTypes;
        if (node.isArray()) {
            return StaticTypeCheckingSupport.isParameterizedWithString(node.getComponentType());
        }
        if (node.isUsingGenerics() && (genericsTypes = node.getGenericsTypes()) != null) {
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (ClassHelper.STRING_TYPE.equals(genericsType.getType())) {
                    return true;
                }
                ++n2;
            }
        }
        return node.getSuperClass() != null && StaticTypeCheckingSupport.isParameterizedWithString(node.getUnresolvedSuperClass());
    }

    public static boolean missesGenericsTypes(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingSupport.missesGenericsTypes(cn.getComponentType());
        }
        if (cn.redirect().isUsingGenerics() && !cn.isUsingGenerics()) {
            return true;
        }
        if (cn.isUsingGenerics()) {
            if (cn.getGenericsTypes() == null) {
                return true;
            }
            GenericsType[] genericsTypeArray = cn.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (genericsType.isPlaceholder()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Object evaluateExpression(Expression expr) {
        String className = "Expression$" + UUID.randomUUID().toString().replace('-', '$');
        ClassNode node = new ClassNode(className, 1, ClassHelper.OBJECT_TYPE);
        ReturnStatement code = new ReturnStatement(expr);
        node.addMethod(new MethodNode("eval", 9, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code));
        CompilationUnit cu = new CompilationUnit();
        cu.addClassNode(node);
        cu.compile();
        List classes = cu.getClasses();
        Class aClass = cu.getClassLoader().defineClass(className, ((GroovyClass)classes.get(0)).getBytes());
        try {
            return aClass.getMethod("eval", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new GroovyBugError(e);
        }
        catch (InvocationTargetException e) {
            throw new GroovyBugError(e);
        }
        catch (NoSuchMethodException e) {
            throw new GroovyBugError(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionMethodCache {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private List<ExtensionModule> modules = Collections.emptyList();
        private Map<String, List<MethodNode>> cachedMethods = null;

        private ExtensionMethodCache() {
        }

        /*
         * Unable to fully structure code
         */
        public Map<String, List<MethodNode>> getExtensionMethods() {
            this.lock.readLock().lock();
            registry = GroovySystem.getMetaClassRegistry();
            if (registry instanceof MetaClassRegistryImpl) {
                impl = (MetaClassRegistryImpl)registry;
                moduleRegistry = impl.getModuleRegistry();
                if (!this.modules.equals(moduleRegistry.getModules())) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    try {
                        if (this.modules.equals(moduleRegistry.getModules())) ** GOTO lbl28
                        this.modules = moduleRegistry.getModules();
                        this.cachedMethods = ExtensionMethodCache.getDGMMethods(registry);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                        this.lock.readLock().lock();
                    }
                } else if (this.cachedMethods == null) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    try {
                        this.cachedMethods = ExtensionMethodCache.getDGMMethods(registry);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                        this.lock.readLock().lock();
                    }
                }
            }
            try {
                var3_4 = Collections.unmodifiableMap(this.cachedMethods);
                return var3_4;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private static Map<String, List<MethodNode>> getDGMMethods(MetaClassRegistry registry) {
            LinkedHashSet<Class<ObjectArrayStaticTypesHelper>> instanceExtClasses = new LinkedHashSet<Class<ObjectArrayStaticTypesHelper>>();
            LinkedHashSet<Class<DefaultGroovyStaticMethods>> staticExtClasses = new LinkedHashSet<Class<DefaultGroovyStaticMethods>>();
            if (registry instanceof MetaClassRegistryImpl) {
                MetaClassRegistryImpl impl = (MetaClassRegistryImpl)registry;
                List<ExtensionModule> modules = impl.getModuleRegistry().getModules();
                for (ExtensionModule module : modules) {
                    if (!(module instanceof MetaInfExtensionModule)) continue;
                    MetaInfExtensionModule extensionModule = (MetaInfExtensionModule)module;
                    instanceExtClasses.addAll(extensionModule.getInstanceMethodsExtensionClasses());
                    staticExtClasses.addAll(extensionModule.getStaticMethodsExtensionClasses());
                }
            }
            HashMap<String, List<MethodNode>> methods = new HashMap<String, List<MethodNode>>();
            Collections.addAll(instanceExtClasses, DefaultGroovyMethods.DGM_LIKE_CLASSES);
            Collections.addAll(instanceExtClasses, DefaultGroovyMethods.additionals);
            staticExtClasses.add(DefaultGroovyStaticMethods.class);
            instanceExtClasses.add(ObjectArrayStaticTypesHelper.class);
            ArrayList<Class> allClasses = new ArrayList<Class>(instanceExtClasses.size() + staticExtClasses.size());
            allClasses.addAll(instanceExtClasses);
            allClasses.addAll(staticExtClasses);
            for (Class dgmLikeClass : allClasses) {
                ClassNode cn = ClassHelper.makeWithoutCaching(dgmLikeClass, true);
                for (MethodNode metaMethod : cn.getMethods()) {
                    Parameter[] types = metaMethod.getParameters();
                    if (!metaMethod.isStatic() || !metaMethod.isPublic() || types.length <= 0 || !metaMethod.getAnnotations(Deprecated_TYPE).isEmpty()) continue;
                    Parameter[] parameters = new Parameter[types.length - 1];
                    System.arraycopy(types, 1, parameters, 0, parameters.length);
                    ExtensionMethodNode node = new ExtensionMethodNode(metaMethod, metaMethod.getName(), metaMethod.getModifiers(), metaMethod.getReturnType(), parameters, ClassNode.EMPTY_ARRAY, null, staticExtClasses.contains(dgmLikeClass));
                    node.setGenericsTypes(metaMethod.getGenericsTypes());
                    ClassNode declaringClass = types[0].getType();
                    String declaringClassName = declaringClass.getName();
                    node.setDeclaringClass(declaringClass);
                    LinkedList<ExtensionMethodNode> nodes = (LinkedList<ExtensionMethodNode>)methods.get(declaringClassName);
                    if (nodes == null) {
                        nodes = new LinkedList<ExtensionMethodNode>();
                        methods.put(declaringClassName, nodes);
                    }
                    nodes.add(node);
                }
            }
            return methods;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectArrayStaticTypesHelper {
        private ObjectArrayStaticTypesHelper() {
        }

        public static <T> T getAt(T[] arr, int index) {
            return null;
        }

        public static <T, U extends T> void putAt(T[] arr, int index, U object) {
        }
    }
}

