/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.ImmutableException;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTAnnotationNode
extends AnnotationNode {
    private static final char[] jlString = "Ljava/lang/String;".toCharArray();
    private static final char[] baseInt = "I".toCharArray();
    private boolean membersInitialized = false;
    private AnnotationBinding annotationBinding;
    private JDTResolver resolver;

    public JDTAnnotationNode(AnnotationBinding annotationBinding, JDTResolver resolver) {
        super(new JDTClassNode(annotationBinding.getAnnotationType(), resolver));
        this.annotationBinding = annotationBinding;
        this.resolver = resolver;
    }

    @Override
    public void addMember(String name, Expression value) {
        throw new ImmutableException();
    }

    @Override
    public ClassNode getClassNode() {
        return super.getClassNode();
    }

    @Override
    public Expression getMember(String name) {
        this.ensureMembersInitialized();
        return super.getMember(name);
    }

    @Override
    public Map<String, Expression> getMembers() {
        this.ensureMembersInitialized();
        return super.getMembers();
    }

    @Override
    public boolean hasClassRetention() {
        return (this.annotationBinding.getAnnotationType().tagBits & 0x200000000000L) == 0x200000000000L;
    }

    @Override
    public boolean hasRuntimeRetention() {
        return (this.annotationBinding.getAnnotationType().tagBits & 0x300000000000L) == 0x300000000000L;
    }

    @Override
    public boolean hasSourceRetention() {
        return (this.annotationBinding.getAnnotationType().tagBits & 0x100000000000L) == 0x100000000000L;
    }

    @Override
    public boolean isBuiltIn() {
        return super.isBuiltIn();
    }

    @Override
    public boolean isTargetAllowed(int target) {
        return super.isTargetAllowed(target);
    }

    @Override
    public void setMember(String name, Expression value) {
        throw new ImmutableException();
    }

    private void ensureMembersInitialized() {
        ElementValuePair[] evpairs;
        if (this.membersInitialized) {
            return;
        }
        this.membersInitialized = true;
        ElementValuePair[] elementValuePairArray = evpairs = this.annotationBinding.getElementValuePairs();
        int n = evpairs.length;
        int n2 = 0;
        while (n2 < n) {
            ElementValuePair evpair = elementValuePairArray[n2];
            char[] name = evpair.getName();
            MethodBinding mb = evpair.binding;
            Expression valueExpression = null;
            if (mb == null) {
                if (evpair.value instanceof StringConstant) {
                    String v = ((StringConstant)evpair.value).stringValue();
                    valueExpression = new ConstantExpression(v);
                } else {
                    valueExpression = ConstantExpression.NULL;
                }
            } else {
                valueExpression = this.createExpressionFor(mb.returnType, evpair.value);
            }
            super.addMember(new String(name), valueExpression);
            ++n2;
        }
    }

    private Expression createExpressionFor(TypeBinding b, Object value) {
        if (b.isArrayType()) {
            ListExpression listExpression = new ListExpression();
            if (value.getClass().isArray()) {
                Object[] values;
                Object[] objectArray = values = (Object[])value;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    listExpression.addExpression(this.createExpressionFor(((ArrayBinding)b).leafComponentType, v));
                    ++n2;
                }
            } else {
                listExpression.addExpression(this.createExpressionFor(((ArrayBinding)b).leafComponentType, value));
            }
            return listExpression;
        }
        if (b.isEnum()) {
            ClassExpression classExpression = new ClassExpression(this.resolver.convertToClassNode(b));
            PropertyExpression valueExpression = new PropertyExpression((Expression)classExpression, new String(((FieldBinding)value).name));
            return valueExpression;
        }
        if (CharOperation.equals(b.signature(), jlString)) {
            String v = ((StringConstant)value).stringValue();
            return new ConstantExpression(v);
        }
        if (b.isBaseType()) {
            char[] sig = b.signature();
            if (CharOperation.equals(sig, baseInt)) {
                return new ConstantExpression(((IntConstant)value).intValue());
            }
            throw new GroovyEclipseBug("NYI for signature " + new String(sig));
        }
        if (b.isClass()) {
            ClassExpression classExpression = new ClassExpression(this.resolver.convertToClassNode((TypeBinding)value));
            return classExpression;
        }
        throw new GroovyEclipseBug("Problem in JDTAnnotatioNode.createExpressionFor(binding=" + b + " value=" + value + ")");
    }

    public JDTResolver getResolver() {
        return this.resolver;
    }
}

