/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import groovy.transform.CompileStatic;
import groovy.transform.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.MethodReferenceExpressionWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.sc.AbstractFunctionalInterfaceWriter;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.ArrayTypeUtils;
import org.codehaus.groovy.syntax.RuntimeParserException;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class StaticTypesMethodReferenceExpressionWriter
extends MethodReferenceExpressionWriter
implements AbstractFunctionalInterfaceWriter {
    private static final String METHODREF_EXPR_INSTANCE = "__METHODREF_EXPR_INSTANCE";
    private static final ClassNode GENERATED_TYPE = ClassHelper.make(Generated.class);
    private static final ClassNode COMPILE_STATIC_TYPE = ClassHelper.make(CompileStatic.class);

    public StaticTypesMethodReferenceExpressionWriter(WriterController controller) {
        super(controller);
    }

    @Override
    public void writeMethodReferenceExpression(MethodReferenceExpression methodReferenceExpression) {
        MethodNode methodRefMethod;
        ClassNode functionalInterfaceType = this.getFunctionalInterfaceType(methodReferenceExpression);
        if (functionalInterfaceType == null || !ClassHelper.isFunctionalInterface(functionalInterfaceType)) {
            super.writeMethodReferenceExpression(methodReferenceExpression);
            return;
        }
        ClassNode redirect = functionalInterfaceType.redirect();
        MethodNode abstractMethodNode = ClassHelper.findSAM(redirect);
        String abstractMethodDesc = this.createMethodDescriptor(abstractMethodNode);
        ClassNode classNode = this.controller.getClassNode();
        Expression typeOrTargetRef = methodReferenceExpression.getExpression();
        boolean isClassExpression = typeOrTargetRef instanceof ClassExpression;
        ClassNode typeOrTargetRefType = isClassExpression ? typeOrTargetRef.getType() : this.controller.getTypeChooser().resolveType(typeOrTargetRef, classNode);
        ClassNode[] methodReferenceParamTypes = (ClassNode[])methodReferenceExpression.getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
        Parameter[] parametersWithExactType = this.createParametersWithExactType(abstractMethodNode, methodReferenceParamTypes);
        String methodRefName = methodReferenceExpression.getMethodName().getText();
        boolean isConstructorReference = StaticTypesMethodReferenceExpressionWriter.isConstructorReference(methodRefName);
        if (isConstructorReference) {
            methodRefName = this.genSyntheticMethodNameForConstructorReference();
            methodRefMethod = this.addSyntheticMethodForConstructorReference(methodRefName, typeOrTargetRefType, parametersWithExactType);
        } else {
            methodRefMethod = this.findMethodRefMethod(methodRefName, parametersWithExactType, typeOrTargetRef, typeOrTargetRefType);
        }
        this.validate(methodReferenceExpression, typeOrTargetRef, typeOrTargetRefType, methodRefName, parametersWithExactType, methodRefMethod);
        if (StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(methodRefMethod)) {
            ExtensionMethodNode extensionMethodNode = (ExtensionMethodNode)methodRefMethod;
            methodRefMethod = extensionMethodNode.getExtensionMethodNode();
            if (extensionMethodNode.isStaticExtension()) {
                methodRefMethod = this.addSyntheticMethodForDGSM(methodRefMethod);
            }
            typeOrTargetRefType = methodRefMethod.getDeclaringClass();
            ClassExpression classExpression = GeneralUtils.classX(typeOrTargetRefType);
            ((AnnotatedNode)classExpression).setSourcePosition(typeOrTargetRef);
            typeOrTargetRef = classExpression;
        }
        methodRefMethod.putNodeMetaData("__ORIGINAL_PARAMETERS_WITH_EXACT_TYPE", parametersWithExactType);
        if (!isClassExpression) {
            if (isConstructorReference) {
                this.addFatalError("Constructor reference must be className::new", methodReferenceExpression);
            } else if (methodRefMethod.isStatic()) {
                ClassExpression classExpression = GeneralUtils.classX(typeOrTargetRefType);
                classExpression.setSourcePosition(typeOrTargetRef);
                typeOrTargetRef = classExpression;
                isClassExpression = true;
            } else {
                typeOrTargetRef.visit(this.controller.getAcg());
            }
        }
        this.controller.getMethodVisitor().visitInvokeDynamicInsn(abstractMethodNode.getName(), this.createAbstractMethodDesc(functionalInterfaceType, typeOrTargetRef), this.createBootstrapMethod(classNode.isInterface(), false), this.createBootstrapMethodArguments(abstractMethodDesc, methodRefMethod.isStatic() || isConstructorReference ? 6 : 5, isConstructorReference ? this.controller.getClassNode() : typeOrTargetRefType, methodRefMethod, false));
        if (isClassExpression) {
            this.controller.getOperandStack().push(redirect);
        } else {
            this.controller.getOperandStack().replace(redirect, 1);
        }
    }

    private void validate(MethodReferenceExpression methodReferenceExpression, Expression typeOrTargetRef, ClassNode typeOrTargetRefType, String methodRefName, Parameter[] parametersWithExactType, MethodNode methodRefMethod) {
        ClassNode firstParameterType;
        if (methodRefMethod == null) {
            this.addFatalError("Failed to find the expected method[" + methodRefName + "(" + Arrays.stream(parametersWithExactType).map(e -> e.getType().getText()).collect(Collectors.joining(",")) + ")] in the type[" + typeOrTargetRefType.getText() + "]", methodReferenceExpression);
        } else if (parametersWithExactType.length > 0 && StaticTypesMethodReferenceExpressionWriter.isTypeReferingInstanceMethod(typeOrTargetRef, methodRefMethod) && !StaticTypeCheckingSupport.isAssignableTo(firstParameterType = parametersWithExactType[0].getType(), typeOrTargetRefType)) {
            throw new RuntimeParserException("Invalid receiver type: " + firstParameterType.getText() + " is not compatible with " + typeOrTargetRefType.getText(), typeOrTargetRef);
        }
    }

    private MethodNode addSyntheticMethodForDGSM(MethodNode mn) {
        Parameter[] parameters = StaticTypesMethodReferenceExpressionWriter.removeFirstParameter(mn.getParameters());
        ArgumentListExpression args = GeneralUtils.args(parameters);
        args.getExpressions().add(0, ConstantExpression.NULL);
        MethodNode syntheticMethodNode = this.controller.getClassNode().addSyntheticMethod("dgsm$$" + mn.getParameters()[0].getType().getName().replace(".", "$") + "$$" + mn.getName(), 4122, mn.getReturnType(), parameters, ClassNode.EMPTY_ARRAY, GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.callX((Expression)GeneralUtils.classX(mn.getDeclaringClass()), mn.getName(), (Expression)args))));
        syntheticMethodNode.addAnnotation(new AnnotationNode(GENERATED_TYPE));
        syntheticMethodNode.addAnnotation(new AnnotationNode(COMPILE_STATIC_TYPE));
        return syntheticMethodNode;
    }

    private MethodNode addSyntheticMethodForConstructorReference(String syntheticMethodName, ClassNode returnType, Parameter[] parametersWithExactType) {
        ArgumentListExpression ctorArgs = GeneralUtils.args(parametersWithExactType);
        MethodNode syntheticMethodNode = this.controller.getClassNode().addSyntheticMethod(syntheticMethodName, 4122, returnType, parametersWithExactType, ClassNode.EMPTY_ARRAY, GeneralUtils.block(GeneralUtils.returnS(returnType.isArray() ? new ArrayExpression(ClassHelper.make(ArrayTypeUtils.elementType(returnType.getTypeClass())), null, ctorArgs.getExpressions()) : GeneralUtils.ctorX(returnType, ctorArgs))));
        syntheticMethodNode.addAnnotation(new AnnotationNode(GENERATED_TYPE));
        syntheticMethodNode.addAnnotation(new AnnotationNode(COMPILE_STATIC_TYPE));
        return syntheticMethodNode;
    }

    private String genSyntheticMethodNameForConstructorReference() {
        return this.controller.getContext().getNextConstructorReferenceSyntheticMethodName(this.controller.getMethodNode());
    }

    private String createAbstractMethodDesc(ClassNode functionalInterfaceType, Expression methodRef) {
        ArrayList<Parameter> methodReferenceSharedVariableList = new ArrayList<Parameter>();
        if (!(methodRef instanceof ClassExpression)) {
            this.prependParameter(methodReferenceSharedVariableList, METHODREF_EXPR_INSTANCE, this.controller.getTypeChooser().resolveType(methodRef, this.controller.getClassNode()));
        }
        return BytecodeHelper.getMethodDescriptor(functionalInterfaceType.redirect(), methodReferenceSharedVariableList.toArray(Parameter.EMPTY_ARRAY));
    }

    private Parameter[] createParametersWithExactType(MethodNode abstractMethodNode, ClassNode[] inferredParameterTypes) {
        Parameter[] originalParameters = abstractMethodNode.getParameters();
        Parameter[] parameters = GeneralUtils.cloneParams(originalParameters);
        int i = 0;
        int n = parameters.length;
        while (i < n) {
            Parameter parameter = parameters[i];
            ClassNode parameterType = parameter.getType();
            ClassNode inferredType = inferredParameterTypes[i];
            if (inferredType != null) {
                ClassNode type = this.convertParameterType(parameterType, inferredType);
                parameter.setType(type);
                parameter.setOriginType(type);
            }
            ++i;
        }
        return parameters;
    }

    private MethodNode findMethodRefMethod(String methodName, Parameter[] samParameters, Expression typeOrTargetRef, ClassNode typeOrTargetRefType) {
        List<MethodNode> methods = this.findVisibleMethods(methodName, typeOrTargetRefType);
        return StaticTypesMethodReferenceExpressionWriter.chooseMethodRefMethodCandidate(typeOrTargetRef, methods.stream().filter(method -> {
            Parameter[] parameters = method.getParameters();
            if (StaticTypesMethodReferenceExpressionWriter.isTypeReferingInstanceMethod(typeOrTargetRef, method)) {
                ClassNode firstParamType = method.getDeclaringClass();
                int n = parameters.length;
                Parameter[] plusOne = new Parameter[n + 1];
                plusOne[0] = new Parameter(firstParamType, "");
                System.arraycopy(parameters, 0, plusOne, 1, n);
                parameters = plusOne;
            }
            return ParameterUtils.parametersCompatible(samParameters, parameters);
        }).collect(Collectors.toList()));
    }

    private List<MethodNode> findVisibleMethods(String name, ClassNode type) {
        List<MethodNode> methods = type.getMethods(name);
        methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(this.controller.getSourceUnit().getClassLoader(), type, name));
        methods = StaticTypeCheckingSupport.filterMethodsByVisibility(methods, this.controller.getClassNode());
        return methods;
    }

    private void addFatalError(String msg, ASTNode node) {
        this.controller.getSourceUnit().addFatalError(msg, node);
        throw new MultipleCompilationErrorsException(this.controller.getSourceUnit().getErrorCollector());
    }

    private static boolean isConstructorReference(String methodRefName) {
        return "new".equals(methodRefName);
    }

    private static boolean isExtensionMethod(MethodNode methodRefMethod) {
        return methodRefMethod instanceof ExtensionMethodNode;
    }

    private static boolean isTypeReferingInstanceMethod(Expression typeOrTargetRef, MethodNode mn) {
        return typeOrTargetRef instanceof ClassExpression && (mn != null && !mn.isStatic() || StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(mn) && !((ExtensionMethodNode)mn).isStaticExtension());
    }

    private static Parameter[] removeFirstParameter(Parameter[] parameters) {
        return Arrays.copyOfRange(parameters, 1, parameters.length);
    }

    private static MethodNode chooseMethodRefMethodCandidate(Expression methodRef, List<MethodNode> candidates) {
        if (1 == candidates.size()) {
            return candidates.get(0);
        }
        return candidates.stream().map(e -> Tuple.tuple(e, StaticTypesMethodReferenceExpressionWriter.matchingScore(e, methodRef))).min((t1, t2) -> Integer.compare((Integer)t2.getV2(), (Integer)t1.getV2())).map(Tuple2::getV1).orElse(null);
    }

    private static Integer matchingScore(MethodNode mn, Expression typeOrTargetRef) {
        ClassNode typeOrTargetRefType = typeOrTargetRef.getType();
        int score = 9;
        ClassNode cn = mn.getDeclaringClass();
        while (cn != null && !cn.equals(typeOrTargetRefType)) {
            --score;
            cn = cn.getSuperClass();
        }
        if (score < 0) {
            score = 0;
        }
        score *= 10;
        if (typeOrTargetRef instanceof ClassExpression == mn.isStatic()) {
            score += 9;
        }
        if (StaticTypesMethodReferenceExpressionWriter.isExtensionMethod(mn)) {
            score += 100;
        }
        return score;
    }
}

