/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.finish;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.AutomatedInstallScriptFilter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    protected JButton autoButton;
    private UninstallDataWriter uninstallDataWriter;
    private UninstallData uninstallData;
    private final Log log;

    public FinishPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, UninstallDataWriter uninstallDataWriter, UninstallData uninstallData, Log log) {
        super(panel, parent, installData, (LayoutManager2)new GridBagLayout(), resources);
        this.uninstallData = uninstallData;
        this.uninstallDataWriter = uninstallDataWriter;
        this.log = log;
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.getI18nStringForClass("done"));
        this.parent.setQuitButtonIcon("done");
        Insets inset = new Insets(10, 20, 2, 2);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 10, inset, 0, 0);
        if (this.installData.isInstallSuccess()) {
            JLabel jLabel = LabelFactory.create((String)this.getI18nStringForClass("success"), (Icon)((Icon)this.parent.getIcons().get((Object)"preferences")), (int)10);
            jLabel.setName(GuiId.FINISH_PANEL_LABEL.id);
            this.add(jLabel, constraints);
            ++constraints.gridy;
            if (this.uninstallDataWriter.isUninstallRequired()) {
                String path = this.translatePath(this.installData.getInfo().getUninstallerPath());
                this.add(LabelFactory.create((String)this.getI18nStringForClass("uninst.info"), (Icon)((Icon)this.parent.getIcons().get((Object)"preferences")), (int)10), constraints);
                ++constraints.gridy;
                this.add(LabelFactory.create((String)path, (Icon)((Icon)this.parent.getIcons().get((Object)"empty")), (int)10), constraints);
                ++constraints.gridy;
            }
            this.autoButton = ButtonFactory.createButton((String)this.getI18nStringForClass("auto"), (Icon)((Icon)this.parent.getIcons().get((Object)"edit")), (Color)this.installData.buttonsHColor);
            this.autoButton.setName(GuiId.FINISH_PANEL_AUTO_BUTTON.id);
            this.autoButton.setToolTipText(this.getI18nStringForClass("auto.tip"));
            this.autoButton.addActionListener(this);
            this.add(this.autoButton, constraints);
            ++constraints.gridy;
        } else {
            this.add(LabelFactory.create((String)this.getI18nStringForClass("fail"), (Icon)((Icon)this.parent.getIcons().get((Object)"stop")), (int)10), constraints);
        }
        this.getLayoutHelper().completeLayout();
        this.log.informUser();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setName(GuiId.FINISH_PANEL_FILE_CHOOSER.id);
        fileChooser.setCurrentDirectory(new File(this.installData.getInstallPath()));
        fileChooser.setSelectedFile(new File(this.installData.getInstallPath(), "auto-install.xml"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter((FileFilter)new AutomatedInstallScriptFilter(this.installData.getMessages()));
        try {
            if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
                File file = fileChooser.getSelectedFile();
                this.parent.writeInstallationRecord(file, this.uninstallData);
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog((Component)((Object)this), err.toString(), this.getString("installer.error"), 0);
        }
    }

    protected String translatePath(String destination) {
        destination = this.installData.getVariables().replace(destination);
        return destination.replace('/', File.separatorChar);
    }
}

