/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class LineNumberFilter
extends XMLFilterImpl {
    private Queue<Integer> lnQueue;
    private Locator locator;

    public LineNumberFilter(XMLReader xmlReader) {
        super(xmlReader);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.lnQueue = new LinkedList<Integer>();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        this.lnQueue.add(this.locator.getLineNumber());
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    private Element getFirstFoundElement(Node elt) {
        while (elt != null && elt.getNodeType() != 1) {
            elt = elt.getNextSibling();
        }
        return (Element)elt;
    }

    private Element getNextSibling(Node elt) {
        return this.getFirstFoundElement(elt.getNextSibling());
    }

    private Element getFirstChild(Node elt) {
        return this.getFirstFoundElement(elt.getFirstChild());
    }

    private boolean hasChildElements(Node elt) {
        return this.getFirstChild(elt) != null;
    }

    private void applyLN(Element elt) {
        elt.setUserData("ln", this.lnQueue.poll(), null);
    }

    public void applyLN(DOMResult result) {
        Element elt = this.getFirstChild(result.getNode());
        boolean end = false;
        Stack<Element> stack = new Stack<Element>();
        while (!end) {
            if (this.hasChildElements(elt)) {
                stack.push(elt);
                this.applyLN(elt);
                elt = this.getFirstChild(elt);
                continue;
            }
            this.applyLN(elt);
            Element sibling = this.getNextSibling(elt);
            if (sibling != null) {
                elt = sibling;
                continue;
            }
            do {
                if (stack.isEmpty()) {
                    end = true;
                    continue;
                }
                elt = (Element)stack.pop();
                elt = this.getNextSibling(elt);
            } while (!end && elt == null);
        }
    }
}

