/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.adaptator.impl.XMLWriter;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.compiler.IPackager;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerHelper;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compiler.Property;
import com.izforge.izpack.event.CompilerListener;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerConfig
extends Thread {
    public static final String VERSION = "1.0";
    public static final String STANDARD = "standard";
    public static final String WEB = "web";
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String IZ_TEST_FILE = "ShellLink.dll";
    private static final String IZ_TEST_SUBDIR = "bin" + File.separator + "native" + File.separator + "izpack";
    private String filename;
    private String installText;
    protected String basedir;
    private Compiler compiler;
    protected List<CompilerListener> compilerListeners = new ArrayList<CompilerListener>();
    private HashMap<String, List<URL>> packsLangUrlMap = new HashMap();

    public static void setIzpackHome(String izHome) {
        Compiler.setIzpackHome(izHome);
    }

    public CompilerConfig(String filename, String basedir, String kind, String output) throws CompilerException {
        this(filename, basedir, kind, output, null);
    }

    public CompilerConfig(String filename, String basedir, String kind, String output, PackagerListener listener) throws CompilerException {
        this(filename, basedir, kind, output, "default", listener);
    }

    public CompilerConfig(String filename, String base, String kind, String output, String compr_format, PackagerListener listener) throws CompilerException {
        this(filename, base, kind, output, compr_format, listener, null);
    }

    public CompilerConfig(String basedir, String kind, String output, PackagerListener listener, String installText) throws CompilerException {
        this(null, basedir, kind, output, "default", listener, installText);
    }

    public CompilerConfig(String filename, String basedir, String kind, String output, String compr_format, PackagerListener listener, String installText) throws CompilerException {
        this(filename, basedir, kind, output, compr_format, -1, listener, installText);
    }

    public CompilerConfig(String filename, String basedir, String kind, String output, String compr_format, int compr_level, PackagerListener listener, String installText) throws CompilerException {
        this.filename = filename;
        this.installText = installText;
        this.basedir = basedir;
        this.compiler = new Compiler(basedir, kind, output, compr_format, compr_level);
        this.compiler.setPackagerListener(listener);
    }

    public boolean addProperty(String name, String value) {
        return this.compiler.addProperty(name, value);
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public PackagerListener getPackagerListener() {
        return this.compiler.getPackagerListener();
    }

    public void compile() {
        this.start();
    }

    @Override
    public void run() {
        try {
            this.executeCompiler();
        }
        catch (CompilerException ce) {
            System.out.println(ce.getMessage() + "\n");
        }
        catch (Exception e) {
            if (Debug.stackTracing()) {
                e.printStackTrace();
            }
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public void executeCompiler() throws Exception {
        File base = new File(this.basedir).getAbsoluteFile();
        if (!base.canRead() || !base.isDirectory()) {
            throw new CompilerException("Invalid base directory: " + base);
        }
        this.compiler.setProperty("basedir", base.toString());
        IXMLElement data = this.getXMLTree();
        this.loadPackagingInformation(data);
        this.addCustomListeners(data);
        this.substituteProperties(data);
        this.addVariables(data);
        this.addDynamicVariables(data);
        this.addConditions(data);
        this.addInfo(data);
        this.addGUIPrefs(data);
        this.addLangpacks(data);
        this.addResources(data);
        this.addNativeLibraries(data);
        this.addJars(data);
        this.addPanels(data);
        this.addPacks(data);
        this.addInstallerRequirement(data);
        this.mergePacksLangFiles();
        this.compiler.createInstaller();
    }

    private void addInstallerRequirement(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addInstallerRequirement", 1, data);
        IXMLElement root = data.getFirstChildNamed("installerrequirements");
        ArrayList<InstallerRequirement> installerrequirements = new ArrayList<InstallerRequirement>();
        if (root != null) {
            Vector<IXMLElement> installerrequirementsels = root.getChildrenNamed("installerrequirement");
            for (IXMLElement installerrequirement : installerrequirementsels) {
                InstallerRequirement basicInstallerCondition = new InstallerRequirement();
                String condition = installerrequirement.getAttribute("condition");
                basicInstallerCondition.setCondition(condition);
                String message = installerrequirement.getAttribute("message");
                basicInstallerCondition.setMessage(message);
                installerrequirements.add(basicInstallerCondition);
            }
        }
        this.compiler.addInstallerRequirement(installerrequirements);
        this.notifyCompilerListener("addInstallerRequirement", 2, data);
    }

    private void loadPackagingInformation(IXMLElement data) throws CompilerException {
        IXMLElement options;
        this.notifyCompilerListener("loadPackager", 1, data);
        IXMLElement root = data.getFirstChildNamed("packaging");
        String packagerclassname = "com.izforge.izpack.compiler.Packager";
        String unpackerclassname = "com.izforge.izpack.installer.Unpacker";
        IXMLElement packager = null;
        if (root != null) {
            IXMLElement unpacker;
            packager = root.getFirstChildNamed("packager");
            if (packager != null) {
                packagerclassname = this.requireAttribute(packager, "class");
            }
            if ((unpacker = root.getFirstChildNamed("unpacker")) != null) {
                unpackerclassname = this.requireAttribute(unpacker, "class");
            }
        }
        this.compiler.initPackager(packagerclassname);
        if (packager != null && (options = packager.getFirstChildNamed("options")) != null) {
            this.compiler.getPackager().addConfigurationInformation(options);
        }
        this.compiler.addProperty("UNPACKER_CLASS", unpackerclassname);
        this.notifyCompilerListener("loadPackager", 2, data);
    }

    public boolean wasSuccessful() {
        return this.compiler.wasSuccessful();
    }

    protected void addGUIPrefs(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addGUIPrefs", 1, data);
        IXMLElement gp = data.getFirstChildNamed("guiprefs");
        GUIPrefs prefs = new GUIPrefs();
        if (gp != null) {
            prefs.resizable = this.requireYesNoAttribute(gp, "resizable");
            prefs.width = this.requireIntAttribute(gp, "width");
            prefs.height = this.requireIntAttribute(gp, "height");
            for (IXMLElement laf : gp.getChildrenNamed("laf")) {
                String lafName = this.requireAttribute(laf, "name");
                this.requireChildNamed(laf, "os");
                for (IXMLElement os : laf.getChildrenNamed("os")) {
                    String osName = this.requireAttribute(os, "family");
                    prefs.lookAndFeelMapping.put(osName, lafName);
                }
                Iterator<IXMLElement> pit = laf.getChildrenNamed("param").iterator();
                TreeMap<String, String> params = new TreeMap<String, String>();
                while (pit.hasNext()) {
                    IXMLElement param = pit.next();
                    String name = this.requireAttribute(param, "name");
                    String value = this.requireAttribute(param, "value");
                    params.put(name, value);
                }
                prefs.lookAndFeelParams.put(lafName, params);
            }
            for (IXMLElement curentModifier : gp.getChildrenNamed("modifier")) {
                String key = this.requireAttribute(curentModifier, "key");
                String value = this.requireAttribute(curentModifier, "value");
                prefs.modifier.put(key, value);
            }
            HashMap<String, String> lafMap = new HashMap<String, String>();
            lafMap.put("liquid", "liquidlnf.jar");
            lafMap.put("kunststoff", "kunststoff.jar");
            lafMap.put("metouia", "metouia.jar");
            lafMap.put("looks", "looks.jar");
            lafMap.put("substance", "substance.jar");
            Iterator<String> kit = prefs.lookAndFeelMapping.keySet().iterator();
            while (kit.hasNext()) {
                String lafName = prefs.lookAndFeelMapping.get(kit.next());
                if ("nimbus".equals(lafName)) continue;
                String lafJarName = (String)lafMap.get(lafName);
                if (lafJarName == null) {
                    this.parseError(gp, "Unrecognized Look and Feel: " + lafName);
                }
                URL lafJarURL = this.findIzPackResource("lib/" + lafJarName, "Look and Feel Jar file", gp);
                this.compiler.addJarContent(lafJarURL);
            }
        }
        this.compiler.setGUIPrefs(prefs);
        this.notifyCompilerListener("addGUIPrefs", 2, data);
    }

    protected void addJars(IXMLElement data) throws Exception {
        this.notifyCompilerListener("addJars", 1, data);
        for (IXMLElement el : data.getChildrenNamed("jar")) {
            String src = this.requireAttribute(el, "src");
            URL url = this.findProjectResource(src, "Jar file", el);
            this.compiler.addJarContent(url);
            String stage = el.getAttribute("stage");
            if (stage == null || !"both".equalsIgnoreCase(stage) && !"uninstall".equalsIgnoreCase(stage)) continue;
            CustomData ca = new CustomData(null, this.getContainedFilePaths(url), null, 3);
            this.compiler.addCustomJar(ca, url);
        }
        this.notifyCompilerListener("addJars", 2, data);
    }

    protected void addNativeLibraries(IXMLElement data) throws Exception {
        IXMLElement root;
        IXMLElement uninstallInfo;
        boolean needAddOns = false;
        this.notifyCompilerListener("addNativeLibraries", 1, data);
        for (IXMLElement el : data.getChildrenNamed("native")) {
            String type = this.requireAttribute(el, "type");
            String name = this.requireAttribute(el, "name");
            String path = el.getAttribute("src");
            if (path == null) {
                path = "bin/native/" + type + "/" + name;
            }
            URL url = this.findIzPackResource(path, "Native Library", el);
            this.compiler.addNativeLibrary(name, url);
            String stage = el.getAttribute("stage");
            List<OsConstraint> constraints = OsConstraint.getOsList(el);
            if (stage == null || !"both".equalsIgnoreCase(stage) && !"uninstall".equalsIgnoreCase(stage)) continue;
            ArrayList<String> al = new ArrayList<String>();
            al.add(name);
            CustomData cad = new CustomData(null, al, constraints, 2);
            this.compiler.addNativeUninstallerLibrary(cad);
            needAddOns = true;
        }
        if (needAddOns && this.validateYesNoAttribute(uninstallInfo = (root = this.requireChildNamed(data, "info")).getFirstChildNamed("uninstaller"), "write", YES)) {
            URL url = this.findIzPackResource("lib/uninstaller-ext.jar", "Uninstaller extensions", root);
            this.compiler.addResource("IzPack.uninstaller-ext", url);
        }
        this.notifyCompilerListener("addNativeLibraries", 2, data);
    }

    protected void addPacks(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addPacks", 1, data);
        this.addPacksSingle(data);
        this.compiler.checkDependencies();
        this.compiler.checkExcludes();
        this.notifyCompilerListener("addPacks", 2, data);
    }

    private void addPacksSingle(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addPacksSingle", 1, data);
        IXMLElement root = this.requireChildNamed(data, "packs");
        Vector<IXMLElement> packElements = root.getChildrenNamed("pack");
        Vector<IXMLElement> refPackElements = root.getChildrenNamed("refpack");
        Vector<IXMLElement> refPackSets = root.getChildrenNamed("refpackset");
        if (packElements.isEmpty() && refPackElements.isEmpty() && refPackSets.isEmpty()) {
            this.parseError(root, "<packs> requires a <pack>, <refpack> or <refpackset>");
        }
        File baseDir = new File(this.basedir);
        for (IXMLElement el : packElements) {
            Map additionals;
            List<OsConstraint> osList;
            String src;
            String name = this.requireAttribute(el, "name");
            String id = el.getAttribute("id");
            String packImgId = el.getAttribute("packImgId");
            boolean loose = "true".equalsIgnoreCase(el.getAttribute("loose", "false"));
            String description = this.requireChildNamed(el, "description").getContent();
            boolean required = this.requireYesNoAttribute(el, "required");
            String group = el.getAttribute("group");
            String installGroups = el.getAttribute("installGroups");
            String excludeGroup = el.getAttribute("excludeGroup");
            boolean uninstall = "yes".equalsIgnoreCase(el.getAttribute("uninstall", "yes"));
            String parent = el.getAttribute("parent");
            boolean hidden = "true".equalsIgnoreCase(el.getAttribute("hidden", "false"));
            String conditionid = el.getAttribute("condition");
            if (required && excludeGroup != null) {
                this.parseError(el, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo pack = new PackInfo(name, id, description, required, loose, excludeGroup, uninstall);
            pack.setOsConstraints(OsConstraint.getOsList(el));
            pack.setParent(parent);
            pack.setCondition(conditionid);
            pack.setHidden(hidden);
            VariableSubstitutor varsubst = new VariableSubstitutor(this.compiler.getVariables());
            if (excludeGroup == null) {
                pack.setPreselected(this.validateYesNoAttribute(el, "preselected", YES));
            } else {
                pack.setPreselected(this.validateYesNoAttribute(el, "preselected", NO));
            }
            if (group != null) {
                pack.setGroup(group);
            }
            if (installGroups != null) {
                StringTokenizer st = new StringTokenizer(installGroups, ",");
                while (st.hasMoreTokens()) {
                    String igroup = st.nextToken();
                    pack.addInstallGroup(igroup);
                }
            }
            if (packImgId != null) {
                pack.setPackImgId(packImgId);
            }
            for (IXMLElement p : el.getChildrenNamed("parsable")) {
                String target = this.requireAttribute(p, "targetfile");
                String type = p.getAttribute("type", "plain");
                String encoding = p.getAttribute("encoding", null);
                List<OsConstraint> osList2 = OsConstraint.getOsList(p);
                String condition = p.getAttribute("condition");
                ParsableFile parsable = new ParsableFile(target, type, encoding, osList2);
                parsable.setCondition(condition);
                pack.addParsable(parsable);
            }
            for (IXMLElement e : el.getChildrenNamed("executable")) {
                ExecutableFile executable = new ExecutableFile();
                String condition = e.getAttribute("condition");
                executable.setCondition(condition);
                executable.path = this.requireAttribute(e, "targetfile");
                String val = e.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 2;
                }
                val = e.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase(val)) {
                    executable.type = 1;
                    executable.mainClass = e.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase(val = e.getAttribute("failure", "ask"))) {
                    executable.onFailure = 0;
                } else if ("warn".equalsIgnoreCase(val)) {
                    executable.onFailure = 1;
                } else if ("ignore".equalsIgnoreCase(val)) {
                    executable.onFailure = 3;
                }
                val = e.getAttribute("keep");
                executable.keepFile = "true".equalsIgnoreCase(val);
                IXMLElement args = e.getFirstChildNamed("args");
                if (null != args) {
                    for (IXMLElement arg : args.getChildrenNamed("arg")) {
                        executable.argList.add(this.requireAttribute(arg, "value"));
                    }
                }
                executable.osList = OsConstraint.getOsList(e);
                pack.addExecutable(executable);
            }
            for (IXMLElement f : el.getChildrenNamed("file")) {
                src = this.requireAttribute(f, "src");
                String targetdir = this.requireAttribute(f, "targetdir");
                osList = OsConstraint.getOsList(f);
                int override = this.getOverrideValue(f);
                additionals = this.getAdditionals(f);
                boolean unpack = "true".equalsIgnoreCase(f.getAttribute("unpack"));
                String condition = f.getAttribute("condition");
                File file = new File(src);
                if (!file.isAbsolute()) {
                    file = new File(this.basedir, src);
                }
                if (!file.exists()) {
                    file = new File(varsubst.substitute(file.getAbsolutePath(), null));
                }
                try {
                    if (unpack) {
                        this.addArchiveContent(baseDir, file, targetdir, osList, override, pack, additionals, condition);
                        continue;
                    }
                    this.addRecursively(baseDir, file, targetdir, osList, override, pack, additionals, condition);
                }
                catch (Exception x) {
                    this.parseError(f, x.getMessage(), x);
                }
            }
            for (IXMLElement f : el.getChildrenNamed("singlefile")) {
                src = this.requireAttribute(f, "src");
                String target = this.requireAttribute(f, "target");
                osList = OsConstraint.getOsList(f);
                int override = this.getOverrideValue(f);
                additionals = this.getAdditionals(f);
                String condition = f.getAttribute("condition");
                File file = new File(src);
                if (!file.isAbsolute()) {
                    file = new File(this.basedir, src);
                }
                if (!file.exists()) {
                    file = new File(varsubst.substitute(file.getAbsolutePath(), null));
                }
                try {
                    pack.addFile(baseDir, file, target, osList, override, additionals, condition);
                }
                catch (FileNotFoundException x) {
                    this.parseError(f, x.getMessage(), x);
                }
            }
            for (IXMLElement f : el.getChildrenNamed("fileset")) {
                String target;
                String dir_attr = this.requireAttribute(f, "dir");
                File dir = new File(dir_attr);
                if (!dir.isAbsolute()) {
                    dir = new File(this.basedir, dir_attr);
                }
                if (!dir.isDirectory()) {
                    this.parseError(f, "Invalid directory 'dir': " + dir_attr);
                }
                boolean casesensitive = this.validateYesNoAttribute(f, "casesensitive", YES);
                boolean defexcludes = this.validateYesNoAttribute(f, "defaultexcludes", YES);
                String targetdir = this.requireAttribute(f, "targetdir");
                List<OsConstraint> osList3 = OsConstraint.getOsList(f);
                int override = this.getOverrideValue(f);
                Map additionals2 = this.getAdditionals(f);
                String condition = f.getAttribute("condition");
                Vector<IXMLElement> xcludesList = null;
                String[] includes = null;
                xcludesList = f.getChildrenNamed("include");
                if (!xcludesList.isEmpty()) {
                    includes = new String[xcludesList.size()];
                    for (int j = 0; j < xcludesList.size(); ++j) {
                        IXMLElement xclude = xcludesList.get(j);
                        includes[j] = this.requireAttribute(xclude, "name");
                    }
                }
                String[] excludes = null;
                xcludesList = f.getChildrenNamed("exclude");
                if (!xcludesList.isEmpty()) {
                    excludes = new String[xcludesList.size()];
                    for (int j = 0; j < xcludesList.size(); ++j) {
                        IXMLElement xclude = xcludesList.get(j);
                        excludes[j] = this.requireAttribute(xclude, "name");
                    }
                }
                String[] toDo = new String[]{"includes", "excludes"};
                String[][] containers = new String[][]{includes, excludes};
                for (int j = 0; j < toDo.length; ++j) {
                    int k;
                    String inex = f.getAttribute(toDo[j]);
                    if (inex == null || inex.length() <= 0) continue;
                    StringTokenizer tok = new StringTokenizer(inex, ", ", false);
                    int newSize = tok.countTokens();
                    String[] nCont = null;
                    if (containers[j] != null && containers[j].length > 0) {
                        nCont = new String[newSize += containers[j].length];
                        for (k = 0; k < containers[j].length; ++k) {
                            nCont[k] = containers[j][k];
                        }
                    }
                    if (nCont == null) {
                        nCont = new String[newSize];
                    }
                    while (k < newSize) {
                        nCont[k] = tok.nextToken();
                        ++k;
                    }
                    containers[j] = nCont;
                }
                includes = containers[0];
                excludes = containers[1];
                DirectoryScanner ds = new DirectoryScanner();
                ds.setIncludes(includes);
                ds.setExcludes(excludes);
                if (defexcludes) {
                    ds.addDefaultExcludes();
                }
                ds.setBasedir(dir);
                ds.setCaseSensitive(casesensitive);
                ds.scan();
                String[] files = ds.getIncludedFiles();
                String[] dirs = ds.getIncludedDirectories();
                for (String file : files) {
                    try {
                        target = new File(targetdir, file).getPath();
                        pack.addFile(baseDir, new File(dir, file), target, osList3, override, additionals2, condition);
                    }
                    catch (FileNotFoundException x) {
                        this.parseError(f, x.getMessage(), x);
                    }
                }
                for (String dir1 : dirs) {
                    try {
                        target = new File(targetdir, dir1).getPath();
                        pack.addFile(baseDir, new File(dir, dir1), target, osList3, override, additionals2, condition);
                    }
                    catch (FileNotFoundException x) {
                        this.parseError(f, x.getMessage(), x);
                    }
                }
            }
            for (IXMLElement f : el.getChildrenNamed("updatecheck")) {
                String casesensitive = f.getAttribute("casesensitive");
                ArrayList<String> includesList = new ArrayList<String>();
                ArrayList<String> excludesList = new ArrayList<String>();
                for (IXMLElement inc_el : f.getChildrenNamed("include")) {
                    includesList.add(this.requireAttribute(inc_el, "name"));
                }
                for (IXMLElement excl_el : f.getChildrenNamed("exclude")) {
                    excludesList.add(this.requireAttribute(excl_el, "name"));
                }
                pack.addUpdateCheck(new UpdateCheck(includesList, excludesList, casesensitive));
            }
            for (IXMLElement dep : el.getChildrenNamed("depends")) {
                String depName = this.requireAttribute(dep, "packname");
                pack.addDependency(depName);
            }
            for (IXMLElement validator : el.getChildrenNamed("validator")) {
                pack.addValidator(this.requireContent(validator));
            }
            this.compiler.addPack(pack);
        }
        for (IXMLElement el : refPackElements) {
            String refFileName = this.requireAttribute(el, "file");
            String selfcontained = el.getAttribute("selfcontained");
            boolean isselfcontained = Boolean.valueOf(selfcontained);
            IXMLElement refXMLData = this.readRefPackData(refFileName, isselfcontained);
            Debug.log("Reading refpack from " + refFileName);
            this.addPacksSingle(refXMLData);
        }
        for (IXMLElement el : refPackSets) {
            String dir_attr = this.requireAttribute(el, "dir");
            File dir = new File(dir_attr);
            if (!dir.isAbsolute()) {
                dir = new File(this.basedir, dir_attr);
            }
            if (!dir.isDirectory()) {
                this.parseError(el, "Invalid refpackset directory 'dir': " + dir_attr);
            }
            String includeString = this.requireAttribute(el, "includes");
            String[] includes = includeString.split(", ");
            DirectoryScanner ds = new DirectoryScanner();
            ds.setIncludes(includes);
            ds.setBasedir(dir);
            ds.setCaseSensitive(true);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String refFileName = new File(dir, files[i]).toString();
                IXMLElement refXMLData = this.readRefPackData(refFileName, false);
                this.addPacksSingle(refXMLData);
            }
        }
        this.notifyCompilerListener("addPacksSingle", 2, data);
    }

    private IXMLElement readRefPackData(String refFileName, boolean isselfcontained) throws CompilerException {
        File refXMLFile = new File(refFileName);
        if (!refXMLFile.isAbsolute()) {
            refXMLFile = new File(this.basedir, refFileName);
        }
        if (!refXMLFile.canRead()) {
            throw new CompilerException("Invalid file: " + refXMLFile);
        }
        InputStream specin = null;
        if (isselfcontained) {
            if (!refXMLFile.getAbsolutePath().endsWith(".zip")) {
                throw new CompilerException("Invalid file: " + refXMLFile + ". Selfcontained files can only be of type zip.");
            }
            try {
                ZipFile zip = new ZipFile(refXMLFile, 1);
                ZipEntry specentry = zip.getEntry("META-INF/izpack.xml");
                specin = zip.getInputStream(specentry);
            }
            catch (IOException e) {
                throw new CompilerException("Error reading META-INF/izpack.xml in " + refXMLFile);
            }
        }
        try {
            specin = new FileInputStream(refXMLFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new CompilerException("FileNotFoundException exception while reading refXMLFile");
        }
        XMLParser refXMLParser = new XMLParser();
        IXMLElement refXMLData = refXMLParser.parse(specin, refXMLFile.getAbsolutePath());
        if (!"installation".equalsIgnoreCase(refXMLData.getName())) {
            this.parseError(refXMLData, "this is not an IzPack XML installation file");
        }
        if (!VERSION.equalsIgnoreCase(this.requireAttribute(refXMLData, "version"))) {
            this.parseError(refXMLData, "the file version is different from the compiler version");
        }
        this.substituteProperties(refXMLData);
        this.addResources(refXMLData);
        try {
            specin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return refXMLData;
    }

    public void checkDependencies(List<PackInfo> packs) throws CompilerException {
        HashMap<String, PackInfo> names = new HashMap<String, PackInfo>();
        for (PackInfo pack : packs) {
            names.put(pack.getPack().name, pack);
        }
        int result = this.dfs(packs, names);
        if (result == -2) {
            this.parseError("Circular dependency detected");
        } else if (result == -1) {
            this.parseError("A dependency doesn't exist");
        }
    }

    private int dfs(List<PackInfo> packs, Map<String, PackInfo> names) {
        HashMap<Edge, Integer> edges = new HashMap<Edge, Integer>();
        for (PackInfo pack : packs) {
            if (pack.colour != 0 || this.dfsVisit(pack, names, edges) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(edges);
    }

    private int checkBackEdges(Map<Edge, Integer> edges) {
        Set<Edge> keys = edges.keySet();
        for (Edge key : keys) {
            int color = edges.get(key);
            if (color != 1) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo u, Map<String, PackInfo> names, Map<Edge, Integer> edges) {
        u.colour = 1;
        List<String> deps = u.getDependencies();
        if (deps != null) {
            for (String name : deps) {
                int result;
                PackInfo v = names.get(name);
                if (v == null) {
                    System.out.println("Failed to find dependency: " + name);
                    return -1;
                }
                Edge edge = new Edge(u, v);
                if (edges.get(edge) == null) {
                    edges.put(edge, v.colour);
                }
                if (v.colour != 0 || (result = this.dfsVisit(v, names, edges)) == 0) continue;
                return result;
            }
        }
        u.colour = 2;
        return 0;
    }

    protected void addArchiveContent(File baseDir, File archive, String targetdir, List<OsConstraint> osList, int override, PackInfo pack, Map additionals, String condition) throws IOException {
        ZipEntry zentry;
        FileInputStream fin = new FileInputStream(archive);
        ZipInputStream zin = new ZipInputStream(fin);
        while ((zentry = zin.getNextEntry()) != null) {
            if (zentry.isDirectory()) continue;
            try {
                File temp = File.createTempFile("izpack", null);
                temp.deleteOnExit();
                FileOutputStream out = new FileOutputStream(temp);
                PackagerHelper.copyStream(zin, out);
                out.close();
                pack.addFile(baseDir, temp, targetdir + "/" + zentry.getName(), osList, override, additionals, condition);
            }
            catch (IOException e) {
                throw new IOException("Couldn't create temporary file for " + zentry.getName() + " in archive " + archive + " (" + e.getMessage() + ")");
            }
        }
        fin.close();
    }

    protected void addRecursively(File baseDir, File file, String targetdir, List<OsConstraint> osList, int override, PackInfo pack, Map additionals, String condition) throws IOException {
        String targetfile = targetdir + "/" + file.getName();
        if (!file.isDirectory()) {
            pack.addFile(baseDir, file, targetfile, osList, override, additionals, condition);
        } else {
            File[] files = file.listFiles();
            if (files.length == 0) {
                pack.addFile(baseDir, file, targetfile, osList, override, additionals, condition);
            } else {
                for (File file1 : files) {
                    this.addRecursively(baseDir, file1, targetfile, osList, override, pack, additionals, condition);
                }
            }
        }
    }

    protected void addPanels(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addPanels", 1, data);
        IXMLElement root = this.requireChildNamed(data, "panels");
        Vector<IXMLElement> panels = root.getChildrenNamed("panel");
        if (panels.isEmpty()) {
            this.parseError(root, "<panels> requires a <panel>");
        }
        Iterator<IXMLElement> iter = panels.iterator();
        int panelCounter = 0;
        while (iter.hasNext()) {
            Vector<IXMLElement> helps;
            String validator;
            IXMLElement validatorElement;
            IXMLElement xmlPanel = iter.next();
            ++panelCounter;
            Panel panel = new Panel();
            panel.osConstraints = OsConstraint.getOsList(xmlPanel);
            String className = xmlPanel.getAttribute("classname");
            String panelid = xmlPanel.getAttribute("id");
            panel.setPanelid(panelid);
            String condition = xmlPanel.getAttribute("condition");
            panel.setCondition(condition);
            String jarPath = xmlPanel.getAttribute("jar");
            if (jarPath == null) {
                jarPath = "bin/panels/" + className + ".jar";
            }
            URL url = null;
            if (!jarPath.equals("")) {
                url = this.findIzPackResource(jarPath, "Panel jar file", xmlPanel, true);
            }
            String fullClassName = null;
            if (url == null) {
                fullClassName = className;
            } else {
                try {
                    fullClassName = this.getFullClassName(url, className);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            panel.className = fullClassName != null ? fullClassName : className;
            IXMLElement configurationElement = xmlPanel.getFirstChildNamed("configuration");
            if (configurationElement != null) {
                Debug.trace("found a configuration for this panel.");
                Vector<IXMLElement> params = configurationElement.getChildrenNamed("param");
                if (params != null) {
                    for (IXMLElement param : params) {
                        IXMLElement keyElement = param.getFirstChildNamed("key");
                        IXMLElement valueElement = param.getFirstChildNamed("value");
                        if (keyElement == null || valueElement == null) continue;
                        panel.addConfiguration(keyElement.getContent(), valueElement.getContent());
                    }
                }
            }
            if ((validatorElement = xmlPanel.getFirstChildNamed("validator")) != null && !"".equals(validator = validatorElement.getAttribute("classname"))) {
                panel.setValidator(validator);
            }
            if ((helps = xmlPanel.getChildrenNamed("help")) != null) {
                for (int helpIndex = 0; helpIndex < helps.size(); ++helpIndex) {
                    URL originalUrl;
                    IXMLElement help = helps.get(helpIndex);
                    String iso3 = help.getAttribute("iso3");
                    String resourceId = panelid == null ? className + "_" + panelCounter + "_help_" + iso3 + ".html" : panelid + "_" + panelCounter + "_help_" + iso3 + ".html";
                    panel.addHelp(iso3, resourceId);
                    URL helpUrl = originalUrl = this.findProjectResource(help.getAttribute("src"), "Help", help);
                    this.compiler.addResource(resourceId, helpUrl);
                }
            }
            this.addPanelActions(xmlPanel, panel);
            this.compiler.addPanelJar(panel, url);
        }
        this.notifyCompilerListener("addPanels", 2, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResources(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addResources", 1, data);
        IXMLElement root = data.getFirstChildNamed("resources");
        if (root == null) {
            return;
        }
        for (IXMLElement res : root.getChildrenNamed("res")) {
            URL originalUrl;
            String id = this.requireAttribute(res, "id");
            String src = this.requireAttribute(res, "src");
            boolean substitute = this.validateYesNoAttribute(res, "parse", NO);
            boolean parsexml = this.validateYesNoAttribute(res, "parsexml", NO);
            String encoding = res.getAttribute("encoding");
            if (encoding == null) {
                encoding = "";
            }
            URL url = originalUrl = this.findProjectResource(src, "Resource", res);
            InputStream is = null;
            OutputStream os = null;
            try {
                Object writer;
                if (parsexml || !"".equals(encoding) || substitute && !this.compiler.getVariables().isEmpty()) {
                    File parsedFile = File.createTempFile("izpp", null);
                    parsedFile.deleteOnExit();
                    FileOutputStream outFile = new FileOutputStream(parsedFile);
                    os = new BufferedOutputStream(outFile);
                    url = parsedFile.toURL();
                }
                if (!"".equals(encoding)) {
                    File recodedFile = File.createTempFile("izenc", null);
                    recodedFile.deleteOnExit();
                    InputStreamReader reader = new InputStreamReader(originalUrl.openStream(), encoding);
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(recodedFile), "UTF-8");
                    char[] buffer = new char[1024];
                    int read = 0;
                    while ((read = reader.read(buffer)) != -1) {
                        ((OutputStreamWriter)writer).write(buffer, 0, read);
                    }
                    reader.close();
                    ((OutputStreamWriter)writer).close();
                    if (parsexml) {
                        originalUrl = recodedFile.toURL();
                    } else {
                        url = recodedFile.toURL();
                    }
                }
                if (parsexml) {
                    XMLParser parser = new XMLParser();
                    IXMLElement xml = parser.parse(originalUrl);
                    writer = new XMLWriter();
                    if (substitute && !this.compiler.getVariables().isEmpty()) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        writer.setOutput(baos);
                        is = new ByteArrayInputStream(baos.toByteArray());
                    } else {
                        writer.setOutput(os);
                    }
                    writer.write(xml);
                }
                if (substitute) {
                    if (this.compiler.getVariables().isEmpty()) {
                        url = originalUrl;
                        this.parseWarn(res, "No variables defined. " + url.getPath() + " not parsed.");
                    } else {
                        String type = res.getAttribute("type");
                        if (null == is) {
                            is = new BufferedInputStream(originalUrl.openStream());
                        }
                        VariableSubstitutor vs = new VariableSubstitutor(this.compiler.getVariables());
                        vs.substitute(is, os, type, "UTF-8");
                    }
                }
            }
            catch (Exception e) {
                this.parseError(res, e.getMessage(), e);
            }
            finally {
                if (null != os) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.compiler.addResource(id, url);
            if (!id.startsWith("packsLang.xml")) continue;
            List<Object> packsLangURLs = null;
            if (this.packsLangUrlMap.containsKey(id)) {
                packsLangURLs = this.packsLangUrlMap.get(id);
            } else {
                packsLangURLs = new ArrayList();
                this.packsLangUrlMap.put(id, packsLangURLs);
            }
            packsLangURLs.add(url);
        }
        this.notifyCompilerListener("addResources", 2, data);
    }

    protected void addLangpacks(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addLangpacks", 1, data);
        IXMLElement root = this.requireChildNamed(data, "locale");
        Vector<IXMLElement> locals = root.getChildrenNamed("langpack");
        if (locals.isEmpty()) {
            this.parseError(root, "<locale> requires a <langpack>");
        }
        for (IXMLElement el : locals) {
            String iso3 = this.requireAttribute(el, "iso3");
            String path = "bin/langpacks/installer/" + iso3 + ".xml";
            URL iso3xmlURL = this.findIzPackResource(path, "ISO3 file", el);
            path = "bin/langpacks/flags/" + iso3 + ".gif";
            URL iso3FlagURL = this.findIzPackResource(path, "ISO3 flag image", el);
            this.compiler.addLangPack(iso3, iso3xmlURL, iso3FlagURL);
        }
        this.notifyCompilerListener("addLangpacks", 2, data);
    }

    protected void addInfo(IXMLElement data) throws Exception {
        IXMLElement writeInstallInfo;
        IXMLElement slfPath;
        IXMLElement uninstallInfo;
        IXMLElement pack200;
        String kind;
        IXMLElement webDirURL;
        IXMLElement jdkRequired;
        IXMLElement javaVersion;
        IXMLElement authors;
        IXMLElement URLElem;
        this.notifyCompilerListener("addInfo", 1, data);
        IXMLElement root = this.requireChildNamed(data, "info");
        Info info = new Info();
        info.setAppName(this.requireContent(this.requireChildNamed(root, "appname")));
        info.setAppVersion(this.requireContent(this.requireChildNamed(root, "appversion")));
        IXMLElement subpath = root.getFirstChildNamed("appsubpath");
        if (subpath != null) {
            info.setInstallationSubPath(this.requireContent(subpath));
        }
        if ((URLElem = root.getFirstChildNamed("url")) != null) {
            URL appURL = this.requireURLContent(URLElem);
            info.setAppURL(appURL.toString());
        }
        if ((authors = root.getFirstChildNamed("authors")) != null) {
            for (IXMLElement author : authors.getChildrenNamed("author")) {
                String name = this.requireAttribute(author, "name");
                String email = this.requireAttribute(author, "email");
                info.addAuthor(new Info.Author(name, email));
            }
        }
        if ((javaVersion = root.getFirstChildNamed("javaversion")) != null) {
            info.setJavaVersion(this.requireContent(javaVersion));
        }
        if ((jdkRequired = root.getFirstChildNamed("requiresjdk")) != null) {
            info.setJdkRequired("yes".equals(jdkRequired.getContent()));
        }
        if ((webDirURL = root.getFirstChildNamed("webdir")) != null) {
            info.setWebDirURL(this.requireURLContent(webDirURL).toString());
        }
        if ((kind = this.compiler.getKind()) != null) {
            if (kind.equalsIgnoreCase(WEB) && webDirURL == null) {
                this.parseError(root, "<webdir> required when \"WEB\" installer requested");
            } else if (kind.equalsIgnoreCase(STANDARD) && webDirURL != null) {
                info.setWebDirURL(null);
            }
        }
        info.setPack200Compression((pack200 = root.getFirstChildNamed("pack200")) != null);
        IXMLElement privileged = root.getFirstChildNamed("run-privileged");
        info.setRequirePrivilegedExecution(privileged != null);
        if (privileged != null && privileged.hasAttribute("condition")) {
            info.setPrivilegedExecutionConditionID(privileged.getAttribute("condition"));
        }
        if (this.validateYesNoAttribute(uninstallInfo = root.getFirstChildNamed("uninstaller"), "write", YES)) {
            URL url = this.findIzPackResource("lib/uninstaller.jar", "Uninstaller", root);
            this.compiler.addResource("IzPack.uninstaller", url);
            if (privileged != null) {
                info.setRequirePrivilegedExecutionUninstaller(this.validateYesNoAttribute(privileged, "uninstaller", YES));
            }
            if (uninstallInfo != null) {
                String uninstallerPath;
                String uninstallerName = uninstallInfo.getAttribute("name");
                if (uninstallerName != null && uninstallerName.length() > ".jar".length()) {
                    info.setUninstallerName(uninstallerName);
                }
                if ((uninstallerPath = uninstallInfo.getAttribute("path")) != null) {
                    info.setUninstallerPath(uninstallerPath);
                }
                if (uninstallInfo.hasAttribute("condition")) {
                    String uninstallerCondition = uninstallInfo.getAttribute("condition");
                    info.setUninstallerCondition(uninstallerCondition);
                }
            }
        }
        if ((slfPath = root.getFirstChildNamed("summarylogfilepath")) != null) {
            info.setSummaryLogFilePath(this.requireContent(slfPath));
        }
        if ((writeInstallInfo = root.getFirstChildNamed("writeinstallationinformation")) != null) {
            String writeInstallInfoString = this.requireContent(writeInstallInfo);
            info.setWriteInstallationInformation(this.validateYesNo(writeInstallInfoString));
        }
        String unpackerclass = this.compiler.getProperty("UNPACKER_CLASS");
        info.setUnpackerClassName(unpackerclass);
        this.compiler.setInfo(info);
        this.notifyCompilerListener("addInfo", 2, data);
    }

    protected void addVariables(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addVariables", 1, data);
        IXMLElement root = data.getFirstChildNamed("variables");
        if (root == null) {
            return;
        }
        Properties variables = this.compiler.getVariables();
        for (IXMLElement var : root.getChildrenNamed("variable")) {
            String name = this.requireAttribute(var, "name");
            String value = this.requireAttribute(var, "value");
            if (variables.contains(name)) {
                this.parseWarn(var, "Variable '" + name + "' being overwritten");
            }
            variables.setProperty(name, value);
        }
        this.notifyCompilerListener("addVariables", 2, data);
    }

    protected void addDynamicVariables(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addDynamicVariables", 1, data);
        IXMLElement root = data.getFirstChildNamed("dynamicvariables");
        if (root == null) {
            return;
        }
        Map<String, List<DynamicVariable>> dynamicvariables = this.compiler.getDynamicVariables();
        for (IXMLElement var : root.getChildrenNamed("variable")) {
            String name = this.requireAttribute(var, "name");
            String value = var.getAttribute("value");
            if (value == null) {
                IXMLElement valueElement = var.getFirstChildNamed("value");
                if (valueElement != null) {
                    value = valueElement.getContent();
                    if (value == null) {
                        this.parseError("A dynamic variable needs either a value attribute or a value element.");
                    }
                } else {
                    this.parseError("A dynamic variable needs either a value attribute or a value element. Variable name: " + name);
                }
            }
            String conditionid = var.getAttribute("condition");
            List<Object> dynamicValues = new ArrayList();
            if (dynamicvariables.containsKey(name)) {
                dynamicValues = dynamicvariables.get(name);
            } else {
                dynamicvariables.put(name, dynamicValues);
            }
            DynamicVariable dynamicVariable = new DynamicVariable();
            dynamicVariable.setName(name);
            dynamicVariable.setValue(value);
            dynamicVariable.setConditionid(conditionid);
            if (dynamicValues.remove(dynamicVariable)) {
                this.parseWarn(var, "Dynamic Variable '" + name + "' will be overwritten");
            }
            dynamicValues.add(dynamicVariable);
        }
        this.notifyCompilerListener("addDynamicVariables", 2, data);
    }

    protected void addConditions(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("addConditions", 1, data);
        IXMLElement root = data.getFirstChildNamed("conditions");
        Map<String, Condition> conditions = this.compiler.getConditions();
        if (root != null) {
            for (IXMLElement conditionel : root.getChildrenNamed("condition")) {
                Condition condition = RulesEngine.analyzeCondition(conditionel);
                if (condition != null) {
                    String conditionid = condition.getId();
                    if (conditions.containsKey(conditionid)) {
                        this.parseWarn(conditionel, "Condition with id '" + conditionid + "' will be overwritten");
                    }
                    conditions.put(conditionid, condition);
                    continue;
                }
                this.parseWarn(conditionel, "Condition couldn't be instantiated.");
            }
        }
        this.notifyCompilerListener("addConditions", 2, data);
    }

    protected void substituteProperties(IXMLElement data) throws CompilerException {
        this.notifyCompilerListener("substituteProperties", 1, data);
        IXMLElement root = data.getFirstChildNamed("properties");
        if (root != null) {
            for (IXMLElement prop : root.getChildrenNamed("property")) {
                Property property = new Property(prop, this);
                property.execute();
            }
        }
        if (root != null) {
            data.removeChild(root);
        }
        this.substituteAllProperties(data);
        if (root != null) {
            data.addChild(root);
        }
        this.notifyCompilerListener("substituteProperties", 2, data);
    }

    protected void substituteAllProperties(IXMLElement element) throws CompilerException {
        Enumeration attributes = element.enumerateAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            String value = this.compiler.replaceProperties(element.getAttribute(name));
            element.setAttribute(name, value);
        }
        String content = element.getContent();
        if (content != null) {
            element.setContent(this.compiler.replaceProperties(content));
        }
        for (int i = 0; i < element.getChildren().size(); ++i) {
            IXMLElement child = element.getChildren().elementAt(i);
            this.substituteAllProperties(child);
        }
    }

    private void assertIsNormalReadableFile(File fileToCheck, String fileDescription) throws CompilerException {
        if (fileToCheck != null) {
            if (!fileToCheck.exists()) {
                throw new CompilerException(fileDescription + " does not exist: " + fileToCheck);
            }
            if (!fileToCheck.isFile()) {
                throw new CompilerException(fileDescription + " is not a regular file: " + fileToCheck);
            }
            if (!fileToCheck.canRead()) {
                throw new CompilerException(fileDescription + " is not readable by application: " + fileToCheck);
            }
        }
    }

    protected IXMLElement getXMLTree() throws CompilerException, IOException {
        XMLParser parser = new XMLParser();
        IXMLElement data = null;
        if (this.filename != null) {
            File file = new File(this.filename).getAbsoluteFile();
            this.assertIsNormalReadableFile(file, "Configuration file");
            data = parser.parse(new FileInputStream(this.filename), file.getAbsolutePath());
            this.compiler.setProperty("izpack.file", file.toString());
        } else if (this.installText != null) {
            data = parser.parse(this.installText);
        } else {
            throw new CompilerException("Neither install file nor text specified");
        }
        if (!"installation".equalsIgnoreCase(data.getName())) {
            this.parseError(data, "this is not an IzPack XML installation file");
        }
        if (!VERSION.equalsIgnoreCase(this.requireAttribute(data, "version"))) {
            this.parseError(data, "the file version is different from the compiler version");
        }
        return data;
    }

    protected int getOverrideValue(IXMLElement f) throws CompilerException {
        int override = 4;
        String override_val = f.getAttribute("override");
        if (override_val != null) {
            if ("true".equalsIgnoreCase(override_val)) {
                override = 1;
            } else if ("false".equalsIgnoreCase(override_val)) {
                override = 0;
            } else if ("asktrue".equalsIgnoreCase(override_val)) {
                override = 3;
            } else if ("askfalse".equalsIgnoreCase(override_val)) {
                override = 2;
            } else if ("update".equalsIgnoreCase(override_val)) {
                override = 4;
            } else {
                this.parseError(f, "invalid value for attribute \"override\"");
            }
        }
        return override;
    }

    private URL findProjectResource(String path, String desc, IXMLElement parent) throws CompilerException {
        URL url = null;
        File resource = new File(path);
        if (!resource.isAbsolute()) {
            resource = new File(this.basedir, path);
        }
        if (!resource.exists()) {
            this.parseError(parent, desc + " not found: " + resource);
        }
        try {
            url = resource.toURL();
        }
        catch (MalformedURLException how) {
            this.parseError(parent, desc + "(" + resource + ")", how);
        }
        return url;
    }

    private URL findIzPackResource(String path, String desc, IXMLElement parent) throws CompilerException {
        return this.findIzPackResource(path, desc, parent, false);
    }

    private URL findIzPackResource(String path, String desc, IXMLElement parent, boolean ignoreWhenNotFound) throws CompilerException {
        URL url = this.getClass().getResource("/" + path);
        if (url == null) {
            File resource = new File(path);
            if (!resource.isAbsolute()) {
                resource = new File(Compiler.IZPACK_HOME, path);
            }
            if (resource.exists()) {
                try {
                    url = resource.toURL();
                }
                catch (MalformedURLException how) {
                    this.parseError(parent, desc + "(" + resource + ")", how);
                }
            } else if (ignoreWhenNotFound) {
                this.parseWarn(parent, desc + " not found: " + resource);
            } else {
                this.parseError(parent, desc + " not found: " + resource);
            }
        }
        return url;
    }

    protected void parseError(String message) throws CompilerException {
        throw new CompilerException(this.filename + ":" + message);
    }

    protected void parseError(IXMLElement parent, String message) throws CompilerException {
        throw new CompilerException(this.filename + ":" + parent.getLineNr() + ": " + message);
    }

    protected void parseError(IXMLElement parent, String message, Throwable cause) throws CompilerException {
        throw new CompilerException(this.filename + ":" + parent.getLineNr() + ": " + message, cause);
    }

    protected void parseWarn(IXMLElement parent, String message) {
        System.out.println("Warning: " + this.filename + ":" + parent.getLineNr() + ": " + message);
    }

    protected IXMLElement requireChildNamed(IXMLElement parent, String name) throws CompilerException {
        IXMLElement child = parent.getFirstChildNamed(name);
        if (child == null) {
            this.parseError(parent, "<" + parent.getName() + "> requires child <" + name + ">");
        }
        return child;
    }

    protected URL requireURLContent(IXMLElement element) throws CompilerException {
        URL url = null;
        try {
            url = new URL(this.requireContent(element));
        }
        catch (MalformedURLException x) {
            this.parseError(element, "<" + element.getName() + "> requires valid URL", x);
        }
        return url;
    }

    protected String requireContent(IXMLElement element) throws CompilerException {
        String content = element.getContent();
        if (content == null || content.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires content");
        }
        return content;
    }

    protected boolean validateYesNo(String value) {
        boolean result = false;
        if ("yes".equalsIgnoreCase(value)) {
            result = true;
        } else if ("no".equalsIgnoreCase(value)) {
            result = false;
        } else {
            Debug.trace("yes/no not found. trying true/false");
            result = Boolean.valueOf(value);
        }
        return result;
    }

    protected String requireAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    protected int requireIntAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            this.parseError(element, "'" + attribute + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = this.requireAttribute(element, attribute);
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        this.parseError(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(IXMLElement element, String attribute, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(attribute, defaultValue ? "yes" : "no");
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        this.parseWarn(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no) if present");
        return defaultValue;
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println(".::  IzPack - Version 4.3.4 ::.");
        System.out.println("");
        System.out.println("< compiler specifications version: 1.0 >");
        System.out.println("");
        System.out.println("- Copyright (c) 2001-2008 Julien Ponge");
        System.out.println("- Visit http://izpack.org/ for the latest releases");
        System.out.println("- Released under the terms of the Apache Software License version 2.0.");
        System.out.println("");
        int exitCode = 1;
        String home = ".";
        String izHome = System.getProperty("izpack.home");
        if (izHome != null) {
            home = izHome;
        } else {
            izHome = System.getenv("IZPACK_HOME");
            if (izHome != null) {
                home = izHome;
            }
        }
        try {
            String base = ".";
            String kind = STANDARD;
            String compr_format = "default";
            int compr_level = -1;
            int nArgs = args.length;
            if (nArgs < 1) {
                throw new Exception("no arguments given");
            }
            if ("-?".equalsIgnoreCase(args[0])) {
                System.out.println("-> Command line parameters are : (xml file) [args]");
                System.out.println("   (xml file): the xml file describing the installation");
                System.out.println("   -h (IzPack home) : the root path of IzPack. This will be needed");
                System.out.println("               if the compiler is not called in the root directory  of IzPack.");
                System.out.println("               Do not forget quotations if there are blanks in the path.");
                System.out.println("   -b (base) : indicates the base path that the compiler will use for filenames");
                System.out.println("               of sources. Default is the current path. Attend to -h.");
                System.out.println("   -k (kind) : indicates the kind of installer to generate");
                System.out.println("               default is standard");
                System.out.println("   -o (out)  : indicates the output file name");
                System.out.println("               default is the xml file name\n");
                System.out.println("   -c (compression)  : indicates the compression format to be used for packs");
                System.out.println("               default is the internal deflate compression\n");
                System.out.println("   -l (compression-level)  : indicates the level for the used compression format");
                System.out.println("                if supported. Only integer are valid\n");
                System.out.println("   When using vm option -DSTACKTRACE=true there is all kind of debug info ");
                System.out.println("");
                exitCode = 0;
            } else {
                String filename = args[0];
                String output = filename.substring(0, filename.length() - 3) + "jar";
                block10: for (int pos = 1; pos < nArgs; ++pos) {
                    if (args[pos].startsWith("-") && args[pos].length() == 2) {
                        switch (args[pos].toLowerCase().charAt(1)) {
                            case 'b': {
                                if (pos + 1 < nArgs) {
                                    base = args[++pos];
                                    continue block10;
                                }
                                throw new Exception("base argument missing");
                            }
                            case 'k': {
                                if (pos + 1 < nArgs) {
                                    kind = args[++pos];
                                    continue block10;
                                }
                                throw new Exception("kind argument missing");
                            }
                            case 'o': {
                                if (pos + 1 < nArgs) {
                                    output = args[++pos];
                                    continue block10;
                                }
                                throw new Exception("output argument missing");
                            }
                            case 'c': {
                                if (pos + 1 < nArgs) {
                                    compr_format = args[++pos];
                                    continue block10;
                                }
                                throw new Exception("compression format argument missing");
                            }
                            case 'l': {
                                if (pos + 1 < nArgs) {
                                    compr_level = Integer.parseInt(args[++pos]);
                                    continue block10;
                                }
                                throw new Exception("compression level argument missing");
                            }
                            case 'h': {
                                if (pos + 1 < nArgs) {
                                    home = args[++pos];
                                    continue block10;
                                }
                                throw new Exception("IzPack home path argument missing");
                            }
                            default: {
                                throw new Exception("unknown argument");
                            }
                        }
                    }
                    throw new Exception("bad argument");
                }
                home = CompilerConfig.resolveIzPackHome(home);
                System.out.println("-> Processing  : " + filename);
                System.out.println("-> Output      : " + output);
                System.out.println("-> Base path   : " + base);
                System.out.println("-> Kind        : " + kind);
                System.out.println("-> Compression : " + compr_format);
                System.out.println("-> Compr. level: " + compr_level);
                System.out.println("-> IzPack home : " + home);
                System.out.println("");
                Compiler.setIzpackHome(home);
                Compiler.CmdlinePackagerListener listener = new Compiler.CmdlinePackagerListener();
                CompilerConfig compiler = new CompilerConfig(filename, base, kind, output, compr_format, compr_level, listener, null);
                compiler.executeCompiler();
                while (compiler.isAlive()) {
                    Thread.sleep(100L);
                }
                if (compiler.wasSuccessful()) {
                    exitCode = 0;
                }
                System.out.println("Build time: " + new Date());
            }
        }
        catch (Exception err) {
            System.err.println("-> Fatal error :");
            System.err.println("   " + err.getMessage());
            err.printStackTrace();
            System.err.println("");
            System.err.println("(tip : use -? to get the commmand line parameters)");
        }
        System.exit(exitCode);
    }

    private static String resolveIzPackHome(String home) {
        File test = new File(home, IZ_TEST_SUBDIR + File.separator + IZ_TEST_FILE);
        if (test.exists()) {
            return home;
        }
        String self = Compiler.class.getName();
        self = self.replace('.', '/');
        self = "/" + self + ".class";
        URL url = Compiler.class.getResource(self);
        String np = url.getFile();
        int start = np.indexOf(self);
        if ((np = np.substring(0, start)).endsWith("!")) {
            if (np.endsWith("standalone-compiler.jar!") || np.endsWith("standalone-compiler-4.0.0.jar!") || np.matches("standalone-compiler-[\\d\\.]+.jar!")) {
                return ".";
            }
            np = np.substring(0, np.length() - 1);
        }
        File root = null;
        root = URI.create(np).isAbsolute() ? new File(URI.create(np)) : new File(np);
        while (true) {
            if (root == null) {
                throw new IllegalArgumentException("No valid IzPack home directory found");
            }
            test = new File(root, IZ_TEST_SUBDIR + File.separator + IZ_TEST_FILE);
            if (test.exists()) {
                return root.getAbsolutePath();
            }
            root = root.getParentFile();
        }
    }

    private void addCustomListeners(IXMLElement data) throws Exception {
        IXMLElement root = data.getFirstChildNamed("listeners");
        if (root == null) {
            return;
        }
        for (IXMLElement xmlAction : root.getChildrenNamed("listener")) {
            Object[] listener = this.getCompilerListenerInstance(xmlAction);
            if (listener != null) {
                this.addCompilerListener((CompilerListener)listener[0]);
            }
            String[] typeNames = new String[]{"installer", "uninstaller"};
            int[] types = new int[]{0, 1};
            for (int i = 0; i < typeNames.length; ++i) {
                String className = xmlAction.getAttribute(typeNames[i]);
                if (className == null) continue;
                String jarPath = xmlAction.getAttribute("jar");
                if ((jarPath = this.compiler.replaceProperties(jarPath)) == null) {
                    jarPath = "bin/customActions/" + className + ".jar";
                }
                List<OsConstraint> constraints = OsConstraint.getOsList(xmlAction);
                this.compiler.addCustomListener(types[i], className, jarPath, constraints);
            }
        }
    }

    private List<String> getContainedFilePaths(URL url) throws Exception {
        JarInputStream jis = new JarInputStream(url.openStream());
        ZipEntry zentry = null;
        ArrayList<String> fullNames = new ArrayList<String>();
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            if (zentry.isDirectory()) continue;
            fullNames.add(name);
        }
        jis.close();
        return fullNames;
    }

    private String getFullClassName(URL url, String className) throws IOException {
        JarInputStream jis = new JarInputStream(url.openStream());
        ZipEntry zentry = null;
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            int lastPos = name.lastIndexOf(".class");
            if (lastPos < 0) continue;
            name = name.replace('/', '.');
            int pos = -1;
            int nonCasePos = -1;
            if (className != null) {
                pos = name.indexOf(className);
                nonCasePos = name.toLowerCase().indexOf(className.toLowerCase());
            }
            if (pos != -1 && name.length() == pos + className.length() + 6) {
                jis.close();
                return name.substring(0, lastPos);
            }
            if (nonCasePos == -1 || name.length() != nonCasePos + className.length() + 6) continue;
            throw new IllegalArgumentException("Fatal error! The declared panel name in the xml file (" + className + ") differs in case to the founded class file (" + name + ").");
        }
        jis.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCompilerListenerInstance(IXMLElement var) throws Exception {
        URL url;
        String fullName;
        String className = var.getAttribute("compiler");
        Class<?> listener = null;
        Object instance = null;
        if (className == null) {
            return null;
        }
        String jarPath = var.getAttribute("jar");
        if ((jarPath = this.compiler.replaceProperties(jarPath)) == null) {
            jarPath = "bin/customActions/" + className + ".jar";
        }
        if ((fullName = this.getFullClassName(url = this.findIzPackResource(jarPath, "CustomAction jar file", var), className)) == null) {
            return null;
        }
        if (url != null) {
            if (this.getClass().getResource("/" + jarPath) != null) {
                InputStream in = null;
                FileOutputStream outFile = null;
                byte[] buffer = new byte[5120];
                File tf = null;
                try {
                    int bytesInBuffer;
                    tf = File.createTempFile("izpj", ".jar");
                    tf.deleteOnExit();
                    outFile = new FileOutputStream(tf);
                    in = this.getClass().getResourceAsStream("/" + jarPath);
                    long bytesCopied = 0L;
                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                        outFile.write(buffer, 0, bytesInBuffer);
                        bytesCopied += (long)bytesInBuffer;
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (outFile != null) {
                        outFile.close();
                    }
                }
                url = tf.toURL();
            }
            URLClassLoader ucl = new URLClassLoader(new URL[]{url}, CompilerListener.class.getClassLoader());
            listener = ucl.loadClass(fullName);
        }
        if (listener != null) {
            instance = listener.newInstance();
        } else {
            this.parseError(var, "Cannot find defined compiler listener " + className);
        }
        if (!CompilerListener.class.isInstance(instance)) {
            this.parseError(var, "'" + className + "' must be implemented " + CompilerListener.class.toString());
        }
        List<OsConstraint> constraints = OsConstraint.getOsList(var);
        return new Object[]{instance, className, constraints};
    }

    private void addCompilerListener(CompilerListener pe) {
        this.compilerListeners.add(pe);
    }

    private void notifyCompilerListener(String callerName, int state, IXMLElement data) throws CompilerException {
        Iterator<CompilerListener> i = this.compilerListeners.iterator();
        IPackager packager = this.compiler.getPackager();
        while (i != null && i.hasNext()) {
            CompilerListener listener = i.next();
            listener.notify(callerName, state, data, packager);
        }
    }

    private Map getAdditionals(IXMLElement f) throws CompilerException {
        Iterator<CompilerListener> i = this.compilerListeners.iterator();
        Map retval = null;
        try {
            while (i != null && i.hasNext()) {
                retval = i.next().reviseAdditionalDataMap(retval, f);
            }
        }
        catch (CompilerException ce) {
            this.parseError(f, ce.getMessage());
        }
        return retval;
    }

    private void mergePacksLangFiles() throws CompilerException {
        if (this.packsLangUrlMap.size() <= 0) {
            return;
        }
        OutputStream os = null;
        try {
            XMLParser parser = new XMLParser();
            for (String id : this.packsLangUrlMap.keySet()) {
                URL mergedPackLangFileURL = null;
                List<URL> packsLangURLs = this.packsLangUrlMap.get(id);
                if (packsLangURLs.size() == 0) continue;
                if (packsLangURLs.size() == 1) {
                    mergedPackLangFileURL = packsLangURLs.get(0);
                } else {
                    IXMLElement mergedPacksLang = null;
                    for (URL packslangURL : packsLangURLs) {
                        IXMLElement xml = parser.parse(packslangURL);
                        if (mergedPacksLang == null) {
                            mergedPacksLang = xml;
                            continue;
                        }
                        Vector<IXMLElement> langStrings = xml.getChildrenNamed("str");
                        for (IXMLElement langString : langStrings) {
                            mergedPacksLang.addChild(langString);
                        }
                    }
                    File mergedPackLangFile = File.createTempFile("izpp", null);
                    mergedPackLangFile.deleteOnExit();
                    FileOutputStream outFile = new FileOutputStream(mergedPackLangFile);
                    os = new BufferedOutputStream(outFile);
                    XMLWriter xmlWriter = new XMLWriter(os);
                    xmlWriter.write(mergedPacksLang);
                    os.close();
                    os = null;
                    mergedPackLangFileURL = mergedPackLangFile.toURL();
                }
                this.compiler.addResource(id, mergedPackLangFileURL);
            }
        }
        catch (Exception e) {
            throw new CompilerException("Unable to merge multiple packsLang.xml files: " + e.getMessage(), e);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void addPanelActions(IXMLElement xmlPanel, Panel panel) throws CompilerException {
        IXMLElement xmlActions = xmlPanel.getFirstChildNamed("actions");
        if (xmlActions != null) {
            Vector<IXMLElement> actionList = xmlActions.getChildrenNamed("action");
            if (actionList != null) {
                for (IXMLElement action : actionList) {
                    String stage = action.getAttribute("stage");
                    String actionName = action.getAttribute("classname");
                    if (actionName != null) {
                        Vector<IXMLElement> params = action.getChildrenNamed("param");
                        PanelActionConfiguration config = new PanelActionConfiguration();
                        for (IXMLElement param : params) {
                            IXMLElement keyElement = param.getFirstChildNamed("key");
                            IXMLElement valueElement = param.getFirstChildNamed("value");
                            if (keyElement == null || valueElement == null) continue;
                            Debug.trace("Adding configuration property " + keyElement.getContent() + " with value " + valueElement.getContent() + " for action " + actionName);
                            config.addProperty(keyElement.getContent(), valueElement.getContent());
                        }
                        panel.putPanelActionConfiguration(actionName, config);
                    }
                    try {
                        PanelAction.ActionStage actionStage = PanelAction.ActionStage.valueOf(stage);
                        switch (actionStage) {
                            case preconstruct: {
                                panel.addPreConstructionActions(actionName);
                                break;
                            }
                            case preactivate: {
                                panel.addPreActivationAction(actionName);
                                break;
                            }
                            case prevalidate: {
                                panel.addPreValidationAction(actionName);
                                break;
                            }
                            case postvalidate: {
                                panel.addPostValidationAction(actionName);
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.parseError(action, "Invalid value [" + stage + "] for attribute : " + "stage");
                    }
                }
            } else {
                this.parseError(xmlActions, "<actions> requires a <action>");
            }
        }
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo u, PackInfo v) {
            this.u = u;
            this.v = v;
        }
    }
}

